/*
 * 路由管理类
 * EZOpenSDK
 *
 * Created by junecheng on 2024/3/22.
 * Copyright (c) 2024年 Ezviz. All rights reserved.
 */
import { router } from '@kit.ArkUI'

export default class RouterManager {
  /// 登录页面
  static loginPage: string = 'pages/Login/MainPage'
  /// 设备列表页面
  static deviceListPage: string = 'pages/DeviceList/EZDeviceListPage'
  /// 设备通道号列表页面
  static cameraListPage: string = 'pages/DeviceList/EZCameraListPage'
  /// 预览页面
  static realPlayPage: string = 'pages/Realplay/EZRealPlayPage'
  /// 回放页面
  static playbackPage: string = 'pages/Playback/EZPlaybackPage'

  /// 设置页面
  static settingPage: string = 'pages/Setting/EZSettingPage'
  /// 修改设备名称页面
  static editDeviceNamePage: string = 'pages/Setting/EZEditDeviceNamePage'
  /// 设备固件升级页面
  static deviceUpgradePage: string = 'pages/Setting/EZDeviceUpgradePage'

  /// 配网-设备二维码扫描页面
  static addByQRCodePage: string = 'pages/AddDevice/EZAddByQRCodePage'
  /// 手动输入设备信息页面
  static inputSerialPage: string = "pages/AddDevice/EZInputSerialPage"
  /// 接触式AP配网页面
  static touchAPPage: string = "pages/AddDevice/EZTouchAPPage"
  /// 配网结果页面
  static deviceResultPage: string = 'pages/AddDevice/EZDeviceResultPage'
  /// 配网前：第一步，准备好设备
  static wifiTipsPage: string = 'pages/AddDevice/EZWifiTipsPage'
  /// 配网前：第二步，连接WiFi
  static wifiInfoPage: string = 'pages/AddDevice/EZWifiInfoPage'
  /// AP配网页面
  static apWiFiConfigPage: string = 'pages/AddDevice/EZAPWiFiConfigPage'
  /// AP配网结果页面
  static apConfigResultPage: string = 'pages/AddDevice/EZAPConfigResultPage'
  /// 设备重启
  static deviceRestartTipsPage: string = 'pages/AddDevice/EZDeviceRestartTipsPage'

  /// 告警消息页面
  static messageListPage: string = 'pages/Message/EZMessageListPage'
  /// 告警消息详情页面
  static messagePhotoPage: string = 'pages/Message/EZMessagePhotoPage'

  /// 功能测试页面
  static testPage: string = 'pages/Others/EZTestPage'
  /// 取流方式设置页面
  static streamTypeSettingPage: string = 'pages/Others/EZStreamTypeSettingPage'
  /// 小权限tkToken设置页面
  static tkTokenTestPage: string = 'pages/Others/EZTKTokenTestPage'
  /// 接口测试页面
  static httpInterfaceTestPage: string = 'pages/Others/EZHttpInterfaceTestPage'
  /// 显示crash日志页面
  static showCrashLogTesPage='pages/Others/EZShowCrashLogPage'

  /**
   * 跳转页面
   * @param url 目标页面
   * @param params 参数
   */
  static pushUrl(url: string, params?: Object) {
    router.pushUrl({
      url, params
    })
  }

  /**
   * 替换页面
   * @param url 目标页面
   */
  static replaceUrl(url: string) {
    router.replaceUrl({
      url
    })
  }

  /**
   * 获取传递的数据
   * @returns
   */
  static getParams(): Object {
    return router.getParams()
  }

  /**
   * 返回
   * @param url 目标页面
   * @param params 参数回调
   */
  static back(url?: string, params?: Object) {
    router.back({
      url, params
    })
  }
}

