/*
 * Demo日志打印工具类
 * EZOpenSDK
 *
 * Created by junecheng on 2024/5/31.
 * Copyright (c) 2024年 Ezviz. All rights reserved.
 */
import hilog from '@ohos.hilog'

const LOG_PREFIX: string = 'EZOpenSDKDemo'

class EZLog {
  private domain: number
  private prefix: string

  // format Indicates the log format string.
  private format: string = '%{public}s %{public}s'

  /**
   * constructor.
   *
   * @param prefix Identifies the log tag.
   * @param domain Indicates the service domain, which is a hexadecimal integer ranging from 0x0 to 0xFFFFF
   * @param args Indicates the log parameters.
   */
  constructor(prefix: string = '', domain: number = 0xFF00) {
    this.prefix = prefix
    this.domain = domain
  }

  debug(...args: string[]): void {
    hilog.debug(this.domain, this.prefix, this.format, args)
  }

  info(...args: string[]): void {
    hilog.info(this.domain, this.prefix, this.format, args)
  }

  warn(...args: string[]): void {
    hilog.warn(this.domain, this.prefix, this.format, args)
  }

  error(...args: string[]): void {
    hilog.error(this.domain, this.prefix, this.format, args)
  }

}

export default new EZLog(LOG_PREFIX)