package com.videogo.openapi;

import com.ezviz.sdk.configwifi.EZConfigWifiErrorEnum;
import com.ezviz.sdk.configwifi.EZConfigWifiInfoEnum;
import com.ezviz.sdk.configwifi.mixedconfig.MixedConfigMode;

import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_0;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_16;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_1_16;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_1_2;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_1_4;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_1_8;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_2;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_32;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_4;
import static com.ez.player.EZMediaPlayer.EZ_PLAY_RATE_8;

public class EZConstants {

    /**
     * ptz 返回正常
     */
    public static final int EZ_PTZ_NO_ERROR = 100;

    /**
     * 视频画面大小变化
     */
    public static final int MSG_VIDEO_SIZE_CHANGED = 134;

    public class EZRealPlayConstants {
        /**
         * 半双工对讲
         */
        public static final int TALK_HALF_DUPLEX = 3;

        /**
         * 全双工对讲
         */
        public static final int TALK_FULL_DUPLEX = 1;

        // [[ below contants are from RealPlayMsg.java
        /**
         * 获取设备信息成功
         */
        public static final int MSG_GET_CAMERA_INFO_SUCCESS = 100;

        /**
         * 获取设备信息失败
         */
        public static final int MSG_GET_CAMERA_INFO_FAIL = 101;

        /**
         * 播放成功消息
         */
        public static final int MSG_REALPLAY_PLAY_SUCCESS = 102;

        /**
         * 播放失败消息
         */
        public static final int MSG_REALPLAY_PLAY_FAIL = 103;

        /**
         * 设置视频质量成功
         */
        public static final int MSG_SET_VEDIOMODE_SUCCESS = 105;

        /**
         * 设置视频质量失败
         */
        public static final int MSG_SET_VEDIOMODE_FAIL = 106;

        /**
         * 录像成功
         */
        public static final int MSG_START_RECORD_SUCCESS = 107;

        /**
         * 录像失败
         */
        public static final int MSG_START_RECORD_FAIL = 108;

        /**
         * 播放密码错误
         */
        public static final int MSG_REALPLAY_PASSWORD_ERROR = 111;

        /**
         * 修改本地密钥失败
         */
        public static final int MSG_REALPLAY_ENCRYPT_PASSWORD_ERROR = 112;

        /**
         * 对讲成功
         */
        public static final int MSG_REALPLAY_VOICETALK_SUCCESS = 113;

        /**
         * 对讲失败
         */
        public static final int MSG_REALPLAY_VOICETALK_FAIL = 114;

        /**
         * 对讲停止成功
         */
        public static final int MSG_REALPLAY_VOICETALK_STOP = 115;

        public static final int MSG_REALPLAY_UPDATE_TALK_VOLUME = 116;

        /**
         * 云台角度获取成功，从播放流里获取的信息
         */
        public static final int MSG_PTZ_GET_SUCCESS = 122;

        public static final int MSG_PTZ_SET_SUCCESS = 123;

        public static final int MSG_PTZ_SET_FAIL = 124;

        public static final int MSG_REALPLAY_PLAY_START = 125;

        public static final int MSG_REALPLAY_CONNECTION_START = 126;

        public static final int MSG_REALPLAY_CONNECTION_SUCCESS = 127;

        public static final int MSG_REALPLAY_CHECK_SUCCESS = 131;

        public static final int MSG_REALPLAY_CHECK_FAIL = 132;

        public static final int MSG_REALPLAY_STOP_SUCCESS = 133;

        /**
         * 开门token获取成功，从播放流里获取的信息
         */
        public static final int MSG_PRIVATE_TOKEN_GET_SUCCESS = 135;

        /**
         * 预览自动清晰度提升消息
         */
        public static final int MSG_VIDEO_LEVEL_AUTO_IMPROVE = 136;
        /**
         * 预览自动清晰度降低消息
         */
        public static final int MSG_VIDEO_LEVEL_AUTO_REDUCE = 137;
        /**
         * 设置自动清晰度成功
         */
        public static final int MSG_SET_VEDIOMODE_AUTO_SUCCESS = 138;
    }

    public static class EZPlaybackConstants {

        // [[ Below contants are from RemotePlayBackMsg.java
        public static final int MSG_REMOTEPLAYBACK_PLAY_FINISH = 201;

        //抓图成功
        public static final int MSG_CAPTURE_PICTURE_SUCCESS = 202;
        //抓图失败
        public static final int MSG_CAPTURE_PICTURE_FAIL = 203;

        /**
         * 播放成功消息
         */
        public static final int MSG_REMOTEPLAYBACK_PLAY_SUCCUSS = 205;

        /**
         * 播放失败
         */
        public static final int MSG_REMOTEPLAYBACK_PLAY_FAIL = 206;

        //回放分辨率变化
        public static final int MSG_REMOTEPLAYBACK_RATIO_CHANGED = 207;

        //回放链接中断
        public static final int MSG_REMOTEPLAYBACK_CONNECTION_EXCEPTION = 208;

        //加密密码错误
        public static final int MSG_REMOTEPLAYBACK_ENCRYPT_PASSWORD_ERROR = 209;

        //设备密码错误
        public static final int MSG_REMOTEPLAYBACK_PASSWORD_ERROR = 210;

        //录像开始成功
        public static final int MSG_START_RECORD_SUCCESS = 212;
        //录像开始失败
        public static final int MSG_START_RECORD_FAIL = 213;

        //搜索文件成功
        public static final int MSG_REMOTEPLAYBACK_SEARCH_FILE_SUCCUSS = 214;
        //搜索文件失败
        public static final int MSG_REMOTEPLAYBACK_SEARCH_FILE_FAIL = 215;
        public static final int MSG_REMOTEPLAYBACK_SEARCH_NO_FILE = 216;

        public static final int MSG_REMOTEPLAYBACK_PLAY_START = 217;

        public static final int MSG_REMOTEPLAYBACK_CONNECTION_START = 218;

        public static final int MSG_REMOTEPLAYBACK_CONNECTION_SUCCESS = 219;

        /**
         * 获取设备信息成功
         */
        public static final int MSG_GET_CAMERA_INFO_SUCCESS = 220;

        // 停止回放消息
        public static final int MSG_REMOTEPLAYBACK_STOP_SUCCESS = 221;

        /**
         * 回放倍速降低消息
         */
        public static final int MSG_REMOTE_PLAYBACK_RATE_LOWER = 222;

        public static final int MSG_REMOTE_PLAYBACK_PLAY_PREPARED = 223;

    }

    /**
     * 获取到当前取流类型
     */
    public static final int MSG_GOT_STREAM_TYPE = 300;

    public static enum EZSMSType {
        /**
         * 安全验证 2
         */
        EZSMSTypeSecure(2),
        /**
         * 安全验证 3
         */
        EZSMSTypeOperate(3);
        private int mSmsType;

        private EZSMSType(int type) {
            mSmsType = type;
        }

        public int getSmsType() {
            return mSmsType;
        }
    }

    public static enum EZAlarmType {
        /**
         * 所有类型
         */
        EZAlarmTypeAll(-1);

        private int mTypeId;

        private EZAlarmType(int id) {
            mTypeId = id;
        }

        public int getTypeId() {
            return mTypeId;
        }

        public void setTypeId(int mTypeId) {
            this.mTypeId = mTypeId;
        }
    }

    public static enum EZAlarmStatus {
        /**
         * 已读状态
         */
        EZAlarmStatusRead(2);

        private int mAlarmStatus;

        private EZAlarmStatus(int status) {
            mAlarmStatus = status;
        }

        public int getAlarmStatus() {
            return mAlarmStatus;
        }

        public void setAlarmSTatus(int mAlarmSTatus) {
            this.mAlarmStatus = mAlarmSTatus;
        }
    }

    public static enum EZMessageStatus {
        /**
         * 消息未读状态
         */
        EZMessageStatusUnRead(1),
        /**
         * 消息已读状态
         */
        EZMessageStatusRead(2);

        private int mMessageStatus;

        private EZMessageStatus(int status) {
            mMessageStatus = status;
        }

        public int getStatus() {
            return mMessageStatus;
        }

        public void setStatus(int mAlarmSTatus) {
            this.mMessageStatus = mAlarmSTatus;
        }
    }

    public static enum EZMessageType {
        /**
         * 报警消息
         */
        EZMessageTypeAlarm(1),
        /**
         * 留言消息
         */
        EZMessageTypeLeave(2);
        private int mMessageType;

        private EZMessageType(int type) {
            mMessageType = type;
        }

        public int getMessageType() {
            return mMessageType;
        }
    }

    public static enum EZLeaveMsgType {
        /**
         * 语音留言信息类型
         */
        EZLeaveMsgTypeVoice(1),
        /**
         * 视频留言信息类型
         */
        EZLeaveMsgTypeVideo(2);
        private int mLeaveMsgType;

        private EZLeaveMsgType(int type) {
            mLeaveMsgType = type;
        }

        public int getLeaveMsgType() {
            return mLeaveMsgType;
        }
    }

    public static enum EZVideoQuality {
        /**
         * 默认值
         */
        VIDEO_PRIORITY_NONE(0),
        /**
         * 性能优先，会设置最低清晰度
         */
        VIDEO_PERFORMANCE_PRIORITY(1),
        /**
         * 画质优先，会设置最高清晰度
         */
        VIDEO_QUALITY_PRIORITY(2);
        private int mVideoQuality;

        private EZVideoQuality(int mVideoQuality) {
            mVideoQuality = mVideoQuality;
        }

    }

    public static enum EZVideoLevel {
        /**
         * 4K
         */
        VIDEO_LEVEL_4K(6),  // 4K
        /**
         * 3K
         */
        VIDEO_LEVEL_3K(5),  // 3K
        /**
         * 极清
         */
        VIDEO_LEVEL_EXTREMECLEAR(4),  // 极清
        /**
         * 超清
         */
        VIDEO_LEVEL_SUPERCLEAR(3),  // 超清
        /**
         * 高清
         */
        VIDEO_LEVEL_HD(2), // 高清
        /**
         * 均衡
         */
        VIDEO_LEVEL_BALANCED(1), // 均衡
        /**
         * 流畅
         */
        VIDEO_LEVEL_FLUNET(0); // 流畅

        private int mVideoLevel;

        private EZVideoLevel(int videoLevel) {
            mVideoLevel = videoLevel;
        }

        public int getVideoLevel() {
            return mVideoLevel;
        }
    }

    public static enum EZPTZCommand {
        /**
         * 向左旋转
         */
        EZPTZCommandLeft(PTZ_LEFT), // 向左旋转
        /**
         * 向右旋转
         */
        EZPTZCommandRight(PTZ_RIGHT), // 向右旋转
        /**
         * 向上旋转
         */
        EZPTZCommandUp(PTZ_UP), // 向上旋转
        /**
         * 向下旋转
         */
        EZPTZCommandDown(PTZ_DOWN), // 向下旋转
        /**
         * 镜头拉近
         */
        EZPTZCommandZoomIn(PTZ_ZOOMIN),  // 镜头拉近
        /**
         * 镜头拉远
         */
        EZPTZCommandZoomOut(PTZ_ZOOMOUT), // 镜头拉远
        /**
         * 焦距拉近
         */
        EZPTZCommandFocusNear(PTZ_FOCUS_NEAR), // 焦距拉近
        /**
         * 焦距拉远
         */
        EZPTZCommandFocusFar(PTZ_FOCUS_FAR); // 焦距拉远

        private int mCommand;

        private EZPTZCommand(int command) {
            mCommand = command;
        }

        public int getCommand() {
            return mCommand;
        }
    }

    public static enum EZPTZAction {
        /**
         * ptz开始
         */
        EZPTZActionSTART("START"), // ptz开始
        /**
         * ptz停止
         */
        EZPTZActionSTOP("STOP"); // ptz停止

        private String mAction = null;

        private EZPTZAction(String action) {
            mAction = action;
        }

        public String getAction() {
            return mAction;
        }
    }

    public static enum EZPTZDisplayCommand {
        /**
         * display翻转
         */
        EZPTZDisplayCommandFlip(PTZ_FLIP); // display翻转

        private int mCommand;

        private EZPTZDisplayCommand(int command) {
            mCommand = command;
        }

        public int getCommand() {
            return mCommand;
        }
    }

    public static enum EZTalkbackCapability {
        /**
         * 不支持对讲 0
         */
        EZTalkbackNoSupport(0),
        /**
         * 支持全双工对讲 1
         */
        EZTalkbackFullDuplex(1),
        /**
         * 支持半双工对讲 3
         */
        EZTalkbackHalfDuplex(3);

        private int capability;

        private EZTalkbackCapability(int capability) {
            this.capability = capability;
        }

        public int getCapability() {
            return capability;
        }
    }

    public static enum EZNotificationDataType {

    }

    public static enum EZDefenceStatus {
        /**
         * IPC关闭布防 0
         */
        EZDefence_IPC_CLOSE(0),
        /**
         * IPC开启布防 1
         */
        EZDefence_IPC_OPEN(1),
        /**
         * 报警器有0:睡眠
         */
        EZDefence_ALARMHOST_SLEEP(0),
        /**
         * 报警器有8:在家
         */
        EZDefence_ALARMHOST_ATHOME(8),
        /**
         * 报警器有16:外出
         */
        EZDefence_ALARMHOST_OUTER(16);

        private int status;

        private EZDefenceStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return status;
        }
    }

    /**
     * ptz 慢速
     */
    public static final int PTZ_SPEED_SLOW = 0;
    /**
     * ptz 默认速度
     */
    public static final int PTZ_SPEED_DEFAULT = 1;
    /**
     * ptz 快速
     */
    public static final int PTZ_SPEED_FAST = 2;

    /**
     * ptz 上
     */
    public static final int PTZ_UP = 0;
    /**
     * ptz 下
     */
    public static final int PTZ_DOWN = 1;
    /**
     * ptz 左
     */
    public static final int PTZ_LEFT = 2;
    /**
     * ptz 右
     */
    public static final int PTZ_RIGHT = 3;
    /**
     * ptz 画面翻转
     */
    public static final int PTZ_FLIP = 4;
    /**
     * ptz 画面放大
     */
    public static final int PTZ_ZOOMIN = 8;
    /**
     * ptz 画面缩小
     */
    public static final int PTZ_ZOOMOUT = 9;
    /**
     * ptz 焦距拉近
     */
    public static final int PTZ_FOCUS_NEAR = 10;
    /**
     * ptz 焦距拉远
     */
    public static final int PTZ_FOCUS_FAR = 11;
    /**
     * 设置预置点
     */
    // 预置点控制命令：SET_PRESET-设置预置点，CLE_PRESET-清除预置点，GOTO_PRESET-转到预置点.
    public static final int PRESET_SET = 7;
    /**
     * 清除预置点
     */
    public static final int PRESET_CLEAN = 8;
    /**
     * 转到预置点
     */
    public static final int PRESET_GOTO = 9;

    // 配网过程回调参数定义
    public enum EZWifiConfigStatus {
        /**
         * 设备正在连接WiFi
         */
        DEVICE_WIFI_CONNECTING(EZConfigWifiInfoEnum.CONNECTING_TO_WIFI),
        /**
         * 设备连接WiFi成功
         */
        DEVICE_WIFI_CONNECTED(EZConfigWifiInfoEnum.CONNECTED_TO_WIFI),

        /**
         * 设备注册平台成功
         */
        DEVICE_PLATFORM_REGISTED(EZConfigWifiInfoEnum.CONNECTED_TO_PLATFORM),

        /**
         * 超时
         */
        TIME_OUT(EZConfigWifiErrorEnum.CONFIG_TIMEOUT);

        public int code;
        public String description;

        EZWifiConfigStatus(int code, String description) {
            this.code = code;
            this.description = description;
        }

        EZWifiConfigStatus(EZConfigWifiInfoEnum info) {
            this.code = info.code;
            this.description = info.description;
        }

        EZWifiConfigStatus(EZConfigWifiErrorEnum error) {
            this.code = error.code;
            this.description = error.description;
        }
    }

    // 配网过程回调参数定义
    public static class EZWiFiConfigMode {
        /**
         * SmartConfig配网
         */
        public static int EZWiFiConfigSmart = MixedConfigMode.EZWiFiConfigSmart;

        /**
         * 声波配网
         */
        public static int EZWiFiConfigWave = MixedConfigMode.EZWiFiConfigWave;

    }

    /**
     * SDCard回放速率
     */
    public enum EZPlaybackRate {
        /**
         * 1/16倍速
         */
        EZ_PLAYBACK_RATE_16_1(1 / (double) 16, EZ_PLAY_RATE_1_16),
        /**
         * 1/8倍速
         */
        EZ_PLAYBACK_RATE_8_1(1 / (double) 8, EZ_PLAY_RATE_1_8),
        /**
         * 1/4倍速
         */
        EZ_PLAYBACK_RATE_4_1(1 / (double) 4, EZ_PLAY_RATE_1_4),
        /**
         * 1/2倍速
         */
        EZ_PLAYBACK_RATE_2_1(1 / (double) 2, EZ_PLAY_RATE_1_2),
        /**
         * 1倍速
         */
        EZ_PLAYBACK_RATE_1(1, EZ_PLAY_RATE_0),
        /**
         * 2倍速
         */
        EZ_PLAYBACK_RATE_2(2, EZ_PLAY_RATE_2),
        /**
         * 4倍速
         */
        EZ_PLAYBACK_RATE_4(4, EZ_PLAY_RATE_4),
        /**
         * 8倍速
         */
        EZ_PLAYBACK_RATE_8(8, EZ_PLAY_RATE_8),
        /**
         * 16倍速
         */
        EZ_PLAYBACK_RATE_16(16, EZ_PLAY_RATE_16),
        /**
         * 32倍速
         */
        EZ_PLAYBACK_RATE_32(32, EZ_PLAY_RATE_32);

        public double speed = 0;
        public int value = 0;

        EZPlaybackRate(double speed, int value) {
            this.speed = speed;
            this.value = value;
        }
    }

    /**
     * 云存储回放速率
     *
     * @deprecated 云存储和本地录像倍速已经统一，直接使用EZPlaybackRate即可
     */
    public enum EZCloudPlaybackRate {

        /**
         * 1倍速
         */
        EZ_CLOUD_PLAYBACK_RATE_1(1, EZ_PLAY_RATE_0),
        /**
         * 4倍速
         */
        EZ_CLOUD_PLAYBACK_RATE_4(4, EZ_PLAY_RATE_4),
        /**
         * 8倍速
         */
        EZ_CLOUD_PLAYBACK_RATE_8(8, EZ_PLAY_RATE_8),
        /**
         * 16倍速
         */
        EZ_CLOUD_PLAYBACK_RATE_16(16, EZ_PLAY_RATE_16),
        /**
         * 32倍速
         */
        EZ_CLOUD_PLAYBACK_RATE_32(32, EZ_PLAY_RATE_32);

        public double speed = 0;
        public int value = 0;

        EZCloudPlaybackRate(float speed, int value) {
            this.speed = speed;
            this.value = value;
        }
    }

    /**
     * 录像类型
     */
    public enum EZVideoRecordType {
        /**
         * 所有类型
         */
        EZ_VIDEO_RECORD_TYPE_ALL("all"),
        /**
         * 定时录像
         */
        EZ_VIDEO_RECORD_TYPE_CMR("CMR"),
        /**
         * 事件类型
         */
        EZ_VIDEO_RECORD_TYPE_Event("event");

        public String recordType;

        EZVideoRecordType(String recordType) {
            this.recordType = recordType;
        }
    }

    /**
     * 录像类型扩展
     */
    public enum EZVideoRecordTypeEx {
        /**
         * 无效值
         */
        EZ_VIDEO_RECORD_TYPE_NONE(0),
        /**
         * 定时录像
         */
        EZ_VIDEO_RECORD_TYPE_CMR(1),
        /**
         * 事件录像
         */
        EZ_VIDEO_RECORD_TYPE_EVENT(2),
        /**
         * 智能-车 录像
         */
        EZ_VIDEO_RECORD_TYPE_CAR(3),
        /**
         * 智能-人型 录像
         */
        EZ_VIDEO_RECORD_TYPE_PERSON(4),
        /**
         * 自动浓缩 录像
         */
        EZ_VIDEO_RECORD_TYPE_COMPRESS_AUTO(5),
        /**
         * 定时浓缩 录像
         */
        EZ_VIDEO_RECORD_TYPE_COMPRESS_CMR(6),
        /**
         * 手动浓缩 录像
         */
        EZ_VIDEO_RECORD_TYPE_COMPRESS_MANUAL(7);

        public int recordType;

        EZVideoRecordTypeEx(int recordType) {
            this.recordType = recordType;
        }

    }

    /**
     * 云存储录像类型
     */
    public enum EZCloudVideoType {
        /**
         * 全部录像
         */
        EZ_CLOUD_VIDEO_TYPE_ALL(-1),
        /**
         * 连续录像
         */
        EZ_CLOUD_VIDEO_TYPE_SERIES(1),
        /**
         * 活动录像
         */
        EZ_CLOUD_VIDEO_TYPE_ACT(2);

        public int videoType;

        EZCloudVideoType(int videoType) {
            this.videoType = videoType;
        }

    }

    /**
     * 鱼眼设备矫正模式
     */
    public enum EZFecCorrectType {

        EZ_FEC_CORRECT_NONE(0),
        /**
         * 4分屏
         */
        EZ_FEC_CORRECT_4PTZ(1),
        /**
         * 180°全景
         */
        EZ_FEC_CORRECT_180(1<<1),
        /**
         * 360°全景
         */
        EZ_FEC_CORRECT_360(1<<2),
        /**
         * 支持鱼眼（原始码流）
         */
        EZ_FEC_CORRECT_FISH(1<<3),
        /**
         * 水平-维度拉伸
         */
        EZ_FEC_CORRECT_LAT(1<<4),
        /**
         * 水平ARC
         */
        EZ_FEC_CORRECT_ARC_HOR(1<<5),
        /**
         * 垂直ARC
         */
        EZ_FEC_CORRECT_ARC_VER(1<<6),
        /**
         * 画中画
         */
        EZ_FEC_CORRECT_PICINPIC(1<<7),
        /**
         * 全景5分屏
         */
        EZ_FEC_CORRECT_FULL5PTZ(1<<8),
        /**
         * 5分屏
         */
        EZ_FEC_CORRECT_5PTZ(1<<9),
        /**
         * 圆柱显示（桶形）
         */
        EZ_FEC_CORRECT_CYC(1<<10),
        /**
         * 广角
         */
        EZ_FEC_CORRECT_WIDEANGLE(1<<11),
        /**
         * 平铺
         */
        EZ_FEC_CORRECT_TILED(1<<12),
        /**
         * 辅助画中画听声辩位模式
         */
        EZ_FEC_CORRECT_LISTENINGRECOGNITION(1<<13);

        public int fecCorrectType;

        EZFecCorrectType(int fecCorrectType) {
            this.fecCorrectType = fecCorrectType;
        }
    }

    /**
     * 鱼眼设备安装模式
     */
    public enum EZFecPlaceType {

        EZ_FEC_PLACE_NONE(0),
        /**
         * 壁装
         */
        EZ_FEC_PLACE_WALL(1),
        /**
         * 底装
         */
        EZ_FEC_PLACE_FLOOR(2),
        /**
         * 顶装
         */
        EZ_FEC_PLACE_CEILING(3);

        public int fecPlaceType;

        EZFecPlaceType(int fecPlaceType) {
            this.fecPlaceType = fecPlaceType;
        }
    }

    /**
     * 对讲变声模式
     */
    public enum EZVoiceChangeType {
        /**
         * 大叔音
         */
        EZ_VOICE_CHANGE_TYPE_MAN(-7),
        /**
         * 原音
         */
        EZ_VOICE_CHANGE_TYPE_NORMAL(0),
        /**
         * 小丑音
         */
        EZ_VOICE_CHANGE_TYPE_CLOWN(7);

        public int voiceType;

        EZVoiceChangeType(int voiceType) {
            this.voiceType = voiceType;
        }
    }

    /**
     * 客户端/设备端带宽检测类型
     */
    public enum EZBandWidthType {
        /**
         * 客户端上行
         */
        EZ_BANDWIDTH_TYPE_CLIENT_UPWARD(1),
        /**
         * 客户端下行
         */
        EZ_BANDWIDTH_TYPE_CLIENT_DOWNWARD(2),
        /**
         * 设备端上行
         */
        EZ_BANDWIDTH_TYPE_DEVICE_UPWARD(3),
        /**
         * 设备端下行
         */
        EZ_BANDWIDTH_TYPE_DEVICE_DOWNWARD(4);

        public int bandWidthType;

        EZBandWidthType(int bandWidthType) {
            this.bandWidthType = bandWidthType;
        }
    }

    /**
     * 播放画面旋转角度
     */
    public enum EZPlayerViewRotationAngle {
        /**
         * 默认画面，未旋转
         */
        EZ_PLAYER_VIEW_ROTATION_ANGLE_0(0),
        /**
         * 旋转90°
         */
        EZ_PLAYER_VIEW_ROTATION_ANGLE_90(90),
        /**
         * 旋转180°
         */
        EZ_PLAYER_VIEW_ROTATION_ANGLE_180(180),
        /**
         * 旋转270°
         */
        EZ_PLAYER_VIEW_ROTATION_ANGLE_270(270);

        public int angle;

        EZPlayerViewRotationAngle(int angle) {
            this.angle = angle;
        }
    }

    // 权限类型
    public static final String EZPermisionTypeReal = "Real";
    public static final String EZPermisionTypeReplay = "Replay";

}
