#ifndef _SADP_H_
#define _SADP_H_


#if defined _WIN32 || defined _WIN64
#define CSADP_API  extern "C" __declspec(dllimport)
#elif defined __linux__ || defined __APPLE__
#define CSADP_API  extern "C"
#endif

#if defined _WIN32 || defined _WIN64
#define CALLBACK __stdcall
#elif defined __linux__ || defined __APPLE__
#define CALLBACK  
#endif

#define     BOOL int

//Ϣ
#define SADP_ADD          1         //һ豸
#define SADP_UPDATE       2         //豸
#define SADP_DEC          3         //豸
#define SADP_RESTART      4         //豸
#define SADP_UPDATEFAIL   5         //豸ʧ

//ⲿ
#define SADP_GET_DEVICE_CODE                1   //ȡ豸룬ӦṹSADP_SAFE_CODE
#define SADP_GET_ENCRYPT_STRING             2   //ȡܴӦṹSADP_ENCRYPT_STRING
#define SADP_GET_DEVICE_TYPE_UNLOCK_CODE    3   //ȡ豸ͽ룬ӦĽṹSADP_TYPE_UNLOCK_CODE
#define SADP_SET_DEVICE_CUSTOM_TYPE         4   //豸ԶͺţӦĽṹSADP_CUSTOM_DEVICE_TYPE
#define SADP_GET_GUID                       5   //ȡGUID
#define SADP_GET_SECURITY_QUESTION          6   //ȡȫ
#define SADP_SET_SECURITY_QUESTION          7   //ðȫ
#define SADP_SET_HCPLATFORM_STATUS          8   //HCPLATFORM״̬
#define SADP_SET_VERIFICATION_CODE          9   //֤루֤өʯ롢ԤƵΨһ룩
#define SADP_GET_BIND_LIST                  12  //ȡ豸б
#define SADP_SET_BIND_LIST                  13  //ð豸б
#define SADP_RESTORE_INACTIVE               14  //ָδ
#define SADP_SET_WIFI_REGION                15  //wifi
#define SADP_SET_CHANNEL_DEFAULT_PASSWORD   16  //ͨĬ
#define SADP_GET_SELF_CHECK                 17  //ȡ豸Լ״̬
#define SADP_DISK_LOCATE                    18  //̶λ
#define SADP_EHOME_ENABLE                   19  //EHomeʹ
#define SADP_SET_USER_MAILBOX               20  //û
#define SADP_GET_QR_CODES                   21  //ȡά
#define SADP_GET_PASSWORD_RESET_TYPE        27  //ȡ뷽ʽ
#define SADP_SET_EZVIZ_USER_TOKEN           28  //өʯûtoken
#define SADP_GET_PHONE_QR_CODES             29  //ȡֻɨά
#define SADP_GET_DEVICE_CODE_V31            30  //v3.1 ȡ豸룬ӦṹSADP_SAFE_CODE_V31
#define SADP_GET_ENCRYPT_STRING_V31         31  //v3.1 ȡܴӦṹSADP_ENCRYPT_STRING_V31
#define SADP_GET_GUID_V31                   32  //v3.1 ȡGUIDӦṹSADP_GUID_FILE_V31
#define SADP_GET_QR_CODES_V31               33  //v3.1 ȡάݣӦṹSADP_QR_CODES_V31


#define SADP_MAX_VERIFICATION_CODE_LEN  12   //֤볤
#define MAX_PASS_LEN                    16   //豸볤
#define MAX_PASS_LEN_V31                128  //豸볤
#define MAX_QUESTION_LIST_LEN           32   //б
#define SADP_MAX_BIND_NUM               32   //豸
#define MAX_CPU_LEN                     32   //CPU
#define MAX_MEMORY_LEN                  32   //ڴ泤
#define MAX_USERNAME_LEN                32   //û󳤶
#define SADP_MAX_SERIALNO_LEN           64   //豸кų
#define MAX_DEVICE_CODE                 128  //豸볤ȣݶ128
#define MAX_DEVICE_CODE_V31             512  //v3.1豸볤
#define MAX_MAILBOX_LEN                 128  //䳤ȣݶ128
#define MAX_GUID_LEN                    128  //GUID
#define MAX_GUID_LEN_V31                512  //v3.1 GUID
#define MAX_EXCHANGE_CODE               256  //볤
#define MAX_ENCRYPT_CODE                256  //豸ܺ󳤶
#define MAX_ENCRYPT_CODE_V31            1024 //豸ܺ󳤶
#define MAX_UNLOCK_CODE_KEY             256  //Կ
#define MAX_QR_CODES                    256  //άݳȣݶ256
#define MAX_QR_CODES_V31                1024 //v3.1 άݳ
#define MAX_ANSWER_LEN                  256  //𰸳
#define MAX_UNLOCK_CODE_RANDOM_LEN      256  //
#define MAX_FILE_PATH_LEN               260  //ļ·
#define MAX_TOKEN_LEN                   16   //өʯûtoken󳤶




// 
#define SADP_ERROR_BASE                 2000
#define SADP_NOERROR                    0                     // ûд
#define SADP_ALLOC_RESOURCE_ERROR       (SADP_ERROR_BASE+1)   // Դ
#define SADP_NOT_START_ERROR            (SADP_ERROR_BASE+2)   // SADPδ
#define SADP_NO_ADAPTER_ERROR           (SADP_ERROR_BASE+3)   // 
#define SADP_GET_ADAPTER_FAIL_ERROR     (SADP_ERROR_BASE+4)   // ȡϢʧ
#define SADP_PARAMETER_ERROR            (SADP_ERROR_BASE+5)   // 
#define SADP_OPEN_ADAPTER_FAIL_ERROR    (SADP_ERROR_BASE+6)   // ʧ
#define SADP_SEND_PACKET_FAIL_ERROR     (SADP_ERROR_BASE+7)   // ʧ
#define SADP_SYSTEM_CALL_ERROR          (SADP_ERROR_BASE+8)   // ϵͳӿڵʧ
#define SADP_DEVICE_DENY                (SADP_ERROR_BASE+9)   // 豸ܾ
#define SADP_NPF_INSTALL_ERROR          (SADP_ERROR_BASE+10)  // װNPFʧ
#define SADP_TIMEOUT                    (SADP_ERROR_BASE+11)  // 豸ʱ
#define SADP_CREATE_SOCKET_ERROR        (SADP_ERROR_BASE+12)  // socketʧ
#define SADP_BIND_SOCKET_ERROR          (SADP_ERROR_BASE+13)  // socketʧ
#define SADP_JOIN_MULTI_CAST_ERROR      (SADP_ERROR_BASE+14)  // ಥʧ
#define SADP_NETWORK_SEND_ERROR         (SADP_ERROR_BASE+15)  // ͳ
#define SADP_NETWORK_RECV_ERROR         (SADP_ERROR_BASE+16)  // ճ
#define SADP_XML_PARSE_ERROR            (SADP_ERROR_BASE+17)  // ಥXML
#define SADP_LOCKED                     (SADP_ERROR_BASE+18)  // 豸
#define SADP_NOT_ACTIVATED              (SADP_ERROR_BASE+19)  // 豸δ
#define SADP_RISK_PASSWORD              (SADP_ERROR_BASE+20)  // ոߵ
#define SADP_HAS_ACTIVATED              (SADP_ERROR_BASE+21)  // 豸Ѽ
#define SADP_EMPTY_ENCRYPT_STRING       (SADP_ERROR_BASE+22)  // ܴΪ
#define SADP_EXPORT_FILE_OVERDUE        (SADP_ERROR_BASE+23)  // ļ
#define SADP_PASSWORD_ERROR             (SADP_ERROR_BASE+24)  // 
#define SADP_LONG_SECURITY_ANSWER       (SADP_ERROR_BASE+25)  // ȫ̫
#define SADP_INVALID_GUID               (SADP_ERROR_BASE+26)  // ЧGUID
#define SADP_ANSWER_ERROR               (SADP_ERROR_BASE+27)  // 𰸴
#define SADP_QUESTION_NUM_ERR           (SADP_ERROR_BASE+28)  // ȫô
#define SADP_LOAD_WPCAP_FAIL            (SADP_ERROR_BASE+30)  // Wpcapʧ
#define SADP_ILLEGAL_VERIFICATION_CODE  (SADP_ERROR_BASE+33)  // Ƿ֤
#define SADP_BIND_ERROR_DEV             (SADP_ERROR_BASE+34)  // 󶨴豸
#define SADP_EXTED_MAX_BIND_NUM         (SADP_ERROR_BASE+35)  // 󶨸
#define SADP_MAILBOX_NOT_EXIST          (SADP_ERROR_BASE+36)  // 䲻
#define SADP_MAILBOX_NOT_SET            (SADP_ERROR_BASE+38)  // [add] <2019/01/08> by yangzheng δ
#define SADP_INVALID_RESET_CODE         (SADP_ERROR_BASE+39)  //   ÿ
#define SADP_NO_PERMISSION              (SADP_ERROR_BASE+40)  // ûȨޣ 1.Win&LinuxûйԱȨ޲ 2.Android IOSûжಥȨ
#define SADP_GET_EXCHANGE_CODE_ERROR    (SADP_ERROR_BASE+41)  // ȡõĽʧ
#define SADP_CREATE_RSA_KEY_ERROR       (SADP_ERROR_BASE+42)  // RSA˽Կʧ
#define SADP_BASE64_ENCODE_ERROR        (SADP_ERROR_BASE+43)  // BASE64
#define SADP_BASE64_DECODE_ERROR        (SADP_ERROR_BASE+44)  // BASE64
#define SADP_AES_ENCRYPT_ERROR          (SADP_ERROR_BASE+45)  // AESʧ
#define SADP_PHONE_NOT_SET              (SADP_ERROR_BASE+46)  // ֻɨδðȫֻ
#define SADP_NOENOUGH_BUF               (SADP_ERROR_BASE+47)  // Ȳ
#define SADP_INVALID_SUBNET_IP          (SADP_ERROR_BASE+48)  // ЧηΧʼipֹip߳4096ip


//SADP豸˹
//λʾΪ1ʾˣ0ʾ;
//bit 1:Ƿөʯ;bit 2:ǷOEM;
#define SADP_DISPLAY_ALL           0            //ʾ豸
#define SADP_FILTER_EZVIZ          0x01         //өʯ豸
#define SADP_FILTER_OEM            0x02         //OEM豸
#define SADP_FILTER_EZVIZ_OEM      0x03         //ͬʱөʯOEM豸
#define SADP_ONLY_DISPLAY_OEM      0xfffffffd   //ʾOEM豸,ӦṹSADP_DISPLAY_OEM_CFG
#define SADP_ONLY_DISPLAY_EZVIZ    0xfffffffe   //ʾөʯ豸
// ṹ

typedef struct tagSADP_DEVICE_INFO
{
    char            szSeries[12];          //豸ϵУ
    char            szSerialNO[48];        //豸к
    char            szMAC[20];             //豸ַ
    char            szIPv4Address[16];     //豸IPv4ַ
    char            szIPv4SubnetMask[16];  //豸IPv4
    unsigned int    dwDeviceType;          //豸ֵͣ豸ͺ
    unsigned int    dwPort;                //豸SDK˿ں(Ĭ8000)
    unsigned int    dwNumberOfEncoders;    //豸豸ͨڽֵΪ0
    unsigned int    dwNumberOfHardDisk;    //豸ӲĿ
    char            szDeviceSoftwareVersion[48];  //豸汾
    char            szDSPVersion[48];      //豸DSP汾
    char            szBootTime[48];        //ʱ
    int             iResult;               
                    //Ϣͣ 1.豸  2.豸  3.豸  4.豸  5.豸ʧ
                    //SADP_ADD        1   豸ߣ֮ǰSADPбδֵ豸
                    //SADP_UPDATE     2   ߵ豸ĳЩ״̬ı
                    //SADP_DEC        3   豸ߣ豸ԶϢ120ڼⲻ豸
                    //SADP_RESTART    4   ֮ǰSADPбгֹ֮ߵ豸ٴ
                    //SADP_UPDATEFAIL 5   豸ʧ
    char            szDevDesc[24];         //豸 dwDeviceTypeӦ
    char            szOEMinfo[24];         //OEMϢ
    char            szIPv4Gateway[16];     //IPv4
    char            szIPv6Address[46];     //IPv6ַ
    char            szIPv6Gateway[46];     //IPv6
    unsigned char   byIPv6MaskLen;         //IPv6ǰ׺
    unsigned char   bySupport;           
                    //λʾ,ӦΪΪ1ʾ֧
                    //0x01:Ƿ֧Ipv6
                    //0x02:Ƿ֧޸Ipv6
                    //0x04:Ƿ֧Dhcp	
                    //0x08:Ƿ֧udpಥ 
                    //0x10:Ƿ񺬼ܽڵ
                    //0x20:Ƿָֻ֧
                    //0x40:Ƿ֧
                    //0x80:Ƿ֧ͬIPC
    unsigned char   byDhcpEnabled;         //Dhcp״̬, 0  1 
    unsigned char   byDeviceAbility;       //豸
                                           //0豸֧֡豸 'OEM' 'IPv4' IPv6ַ 'IPv6' IPv6ǰ׺DHCP  
                                           //1֧߹
    unsigned short  wHttpPort;             //Http ˿
    unsigned short  wDigitalChannelNum;    //ͨ
    char            szCmsIPv4[16];         //CMSעIPv4ַ
    unsigned short  wCmsPort;              //CMSע˿
    unsigned char   byOEMCode;             //0-豸 1-OEM豸
    unsigned char   byActivated;           //豸Ƿ񼤻;0-1-δϵ豸Ѽ״̬
    char            szBaseDesc[24];        //߶ͺţ涨ƶ޸ĵͺţөʯƽ̨ͺŶԱ
    unsigned char   bySupport1; 
                    //λʾ,  1ʾ֧֣0ʾ֧
                    //0x01:Ƿ֧뷽ʽ2 
                    //0x02;Ƿ֧豸
                    //0x04:Ƿֵ֧GUID
                    //0x08:Ƿְ֧ȫ
                    //0x10:Ƿ֧OEMLogo
                    //0x20:Ƿְ֧󶨲
                    //0x40:Ƿָֻ֧δ
                    //0x80:Ƿ֧wifiźǿģʽ
    unsigned char   byHCPlatform;          //Ƿ֧HCPlatform 0-, 1-֧, 2-֧   
    unsigned char   byEnableHCPlatform;    //ǷHCPlatform  0-, 1-ã 2-
    unsigned char   byEZVIZCode;           //0-豸, 1-өʯ豸
    unsigned int    dwDetailOEMCode;       //ϸOEMCodeϢ:oemcodeɿͻţɱλ,1ʼ1~429496)+˵2λ+ţ2λֹɡ	
                                           //˵oemcodeֵΪ4294967295ʮλ
                                           //0: 豸
                                           //1: »豸
                                           //10101: оOEM codeΪOEM豸
    unsigned char   byModifyVerificationCode; //Ƿ޸֤ 0- 1-޸֤룬 2-޸֤
    unsigned char   byMaxBindNum;          //ְ֧󶨵ĿǰֻNVRֶָ֧Σ
    unsigned short  wOEMCommandPort;       //OEM˿
    unsigned char   bySupportWifiRegion;
                    //豸ֵ֧wifiбλʾ1ʾ֧֣0ʾ֧
                    //0x01:Ƿ֧defaultĬϹʺͱһ£
                    //0x02:Ƿ֧china
                    //0x04:Ƿ֧nothAmerica
                    //0x08:Ƿ֧japan
                    //0x10:Ƿ֧europe
                    //0x20:Ƿ֧world
    unsigned char   byEnableWifiEnhancement;//Ƿwifiǿģʽ,0-ã1-
    unsigned char   byWifiRegion;           //豸ǰ0-default1-china2-nothAmerica3-japan4-europe,5-world
    unsigned char   bySupport2; 
                    //λʾ,  1ʾ֧֣0ʾ֧
                    //0x01:Ƿ֧ͨĬãnvrIPC Ĭʹõnvr admin룬ᵥڱأ
                    //0x02:Ƿ֧
                    //0x04:Ƿ֧δSSIDPassword
}SADP_DEVICE_INFO, *LPSADP_DEVICE_INFO;

typedef struct tagSADP_DEVICE_INFO_V40
{
    SADP_DEVICE_INFO struSadpDeviceInfo;
    unsigned char   byLicensed;          //豸ǷȨ0-,1-豸δȨ2-豸Ȩ
    unsigned char   bySystemMode;        //ϵͳģʽ 0-,1-أ2-˫أ3-Ⱥ4-˫ؼȺ
    unsigned char   byControllerType;    // 0-1-Aأ2-B
    char            szEhmoeVersion[16];  //Ehmoe汾
    unsigned char   bySpecificDeviceType;//豸ͣ1-豸  2-豸
    unsigned int    dwSDKOverTLSPort;    //˽Э SDK Over TLS ˿
    unsigned char   bySecurityMode;      //豸ȫģʽ0-standard,1-high-A,2-high-B,3-custom
    unsigned char   bySDKServerStatus;   //豸SDK״̬, 0-1-ر
    unsigned char   bySDKOverTLSServerStatus;         //豸SDKOverTLS״̬, 0-رգ1-
    char            szUserName[MAX_USERNAME_LEN + 1]; //Աûû豸ȫģʽڷǱ׼ģʽûùԱûû׼ģʽĬΪadmin
    char            szWifiMAC[20];       //豸wifiMacַ
    unsigned char   byDataFromMulticast; //0-· 1-ಥ
    unsigned char   bySupportEzvizUnbind; //Ƿ֧өʯ 0-֧ 1-֧
    unsigned char   bySupportCodeEncrypt; //Ƿ֧ÿAES128_ECB  0-֧ 1-֧
    unsigned char   bySupportPasswordResetType; //Ƿֻ֧ȡ÷ʽ  0-֧ 1-֧
    unsigned char   byEZVIZBindStatus; //豸өʯư״̬,0-δ֪,1-Ѱ,2-δ
    char            szPhysicalAccessVerification[16]; //豸ֵ֧Ӵʽӷʽ,1#AP,2#ûƣûtoken,3#Ӵ,4#ɨ󶨣豸token
    unsigned short  wHttpsPort; // Https ˿
    unsigned char   bySupportEzvizUserToken; //Ƿ֧өʯûtoken  0-֧ 1-֧
    char            szDevDescEx[64];         //ǶSADP_DEVICE_INFOṹеszDevDescֶչ
    char            szSerialNOEx[128];        //ǶSADP_DEVICE_INFOṹеszSerialNOֶչ
    char            szManufacturer[32];     //豸Ϣ
    unsigned char   bySupportResetPwByPhoneNo; //Ƿֻ֧ɨ豸Ա  0-֧ 1-֧
    unsigned char   byRes[183];
}SADP_DEVICE_INFO_V40, *LPSADP_DEVICE_INFO_V40;

//޸ĵ豸
typedef struct tagSADP_DEV_NET_PARAM
{
    char            szIPv4Address[16];      // IPv4ַ
    char            szIPv4SubNetMask[16];   // IPv4
    char            szIPv4Gateway[16];      // IPv4
    char            szIPv6Address[128];     // IPv6ַ
    char            szIPv6Gateway[128];     // IPv6
    unsigned short  wPort;                  // 豸SDK˿ں(Ĭ8000)
    unsigned char   byIPv6MaskLen;          // IPv6볤
    unsigned char   byDhcpEnable;           // DHCPʹ
    unsigned short  wHttpPort;              // HTTP˿
    unsigned int    dwSDKOverTLSPort;       // ˽Э SDK Over TLS ˿
    unsigned char   byRes[122];
}SADP_DEV_NET_PARAM, *LPSADP_DEV_NET_PARAM;


//豸Ϣ
typedef struct tagSADP_DEV_RET_NET_PARAM
{
    unsigned char   byRetryModifyTime;  //ʣɳ޸
    unsigned char   bySurplusLockTime;  //ʣʱ䣬λӣûʱ˲Ч
    unsigned char   byRes[126];
}SADP_DEV_RET_NET_PARAM, *LPSADP_DEV_RET_NET_PARAM;

//豸ȫ룬ӦSADP_GET_DEVICE_CODEӿSADP_GetDeviceConfig
typedef struct tagSADP_SAFE_CODE
{
    unsigned int    dwCodeSize;
    char            szDeviceCode[MAX_DEVICE_CODE];
    unsigned char   byRes[128];
}SADP_SAFE_CODE, *LPSADP_SAFE_CODE;

//v3.1豸ȫ룬ӦSADP_GET_DEVICE_CODE_V31ӿSADP_GetDeviceConfig
typedef struct tagSADP_SAFE_CODE_V31
{
    unsigned int    dwCodeSize;
    char            szDeviceCode[MAX_DEVICE_CODE_V31];
    unsigned char   byRes[512];
}SADP_SAFE_CODE_V31, *LPSADP_SAFE_CODE_V31;

//豸ά
typedef struct tagSADP_QR_CODES
{
    unsigned int    dwCodeSize;
    unsigned int    dwMailBoxSize;
    unsigned int    dwServiceMailBoxSize;
    char            szQrCodes[MAX_QR_CODES];
    char            szMailBoxAddr[MAX_MAILBOX_LEN];         //Ҫõַ
    char            szServiceMailBoxAddr[MAX_MAILBOX_LEN];  //ַ
    unsigned char   byRes[128];
}SADP_QR_CODES, *LPSADP_QR_CODES;

//v3.1 豸ά
typedef struct tagSADP_QR_CODES_V31
{
    unsigned int    dwCodeSize;
    unsigned int    dwMailBoxSize;
    unsigned int    dwServiceMailBoxSize;
    char            szQrCodes[MAX_QR_CODES_V31];
    char            szMailBoxAddr[MAX_MAILBOX_LEN];         //Ҫõַ
    char            szServiceMailBoxAddr[MAX_MAILBOX_LEN];  //ַ
    unsigned char   byRes[256];
}SADP_QR_CODES_V31, *LPSADP_QR_CODES_V31;

//ܴṹ壬ӦSADP_GET_ENCRYPT_STRINGӿSADP_GetDeviceConfig
typedef struct tagSADP_ENCRYPT_STRING
{
    unsigned int    dwEncryptStringSize;               //ܴ
    char            szEncryptString[MAX_ENCRYPT_CODE]; //ܴ
    unsigned char   byRes[128];
}SADP_ENCRYPT_STRING, *LPSADP_ENCRYPT_STRING;

//ܴṹ壬ӦSADP_GET_ENCRYPT_STRING_V31ӿSADP_GetDeviceConfig
typedef struct tagSADP_ENCRYPT_STRING_V31
{
    unsigned int    dwEncryptStringSize;               //ܴ
    char            szEncryptString[MAX_ENCRYPT_CODE_V31]; //ܴ
    unsigned char   byRes[512];
}SADP_ENCRYPT_STRING_V31, *LPSADP_ENCRYPT_STRING_V31;

//ָ/ṹ
typedef struct tagSADP_RESET_PARAM
{
    char            szCode[MAX_ENCRYPT_CODE];     //תַܹ߼ַܺ - ΪϽӿ
    char            szAuthFile[MAX_FILE_PATH_LEN];//Ȩļ
    char            szPassword[MAX_PASS_LEN];     //û
    unsigned char   byEnableSyncIPCPW;            //ǷͬIPC롣0 - ã 1- 
    unsigned char   byRes[511];
}SADP_RESET_PARAM, *LSADP_RESET_PARAM;

//ʾOEMýṹ
typedef struct tagSADP_DISPLAY_OEM_CFG
{
    unsigned int    dwDisplayOEM;   //0-ʾOEMֵΪҪʾĳһ͵OEMCodedwDetailOEMCode	
    unsigned char   byRes[32];      //
}SADP_DISPLAY_OEM_CFG, *LPSADP_DISPLAY_OEM_CFG;

typedef struct tagSADP_TYPE_UNLOCK_CODE
{
    unsigned int   dwCodeSize;
    char           szDeviceTypeUnlockCode[MAX_UNLOCK_CODE_RANDOM_LEN/*256*/];//豸ͺŽ
    unsigned char  byRes[128];
}SADP_TYPE_UNLOCK_CODE, *LPSADP_TYPE_UNLOCK_CODE;

typedef struct tagSADP_CUSTOM_DEVICE_TYPE
{
    unsigned int   dwCodeSize;
    char           szDeviceTypeSecretKey[MAX_UNLOCK_CODE_KEY/*256*/];//ͽԿ
    unsigned char  byRes[128];
}SADP_CUSTOM_DEVICE_TYPE, *LPSADP_CUSTOM_DEVICE_TYPE;

//ȡGUIDṹ
typedef struct tagSADP_GUID_FILE_COND
{
    char           szPassword[MAX_PASS_LEN];  //û
    unsigned char  byRes[128];
}SADP_GUID_FILE_COND, *LPSADP_GUID_FILE_COND;

//GUIDṹ
typedef struct tagSADP_GUID_FILE
{
    unsigned int    dwGUIDSize;
    char            szGUID[MAX_GUID_LEN];
    unsigned char   byRetryGUIDTime;    //ʣɵ/GUID
    unsigned char   bySurplusLockTime;  //ʣʱ䣬λӣûʱ˲Ч
    unsigned char   byRes[254];
}SADP_GUID_FILE, *LPSADP_GUID_FILE;

typedef struct tagSADP_SINGLE_SECURITY_QUESTION_CFG
{
    unsigned int    dwSize;
    unsigned int    dwId;//
    char            szAnswer[MAX_ANSWER_LEN/*256*/];//𰸣ֻʱЧȡʱЧ
    unsigned char   byMark;//ǸŵǷ  0-δ 1-
    unsigned char   byRes[127];
}SADP_SINGLE_SECURITY_QUESTION_CFG, *LPSADP_SINGLE_SECURITY_QUESTION_CFG;

typedef struct tagSADP_SECURITY_QUESTION_CFG
{
    unsigned int   dwSize;
    SADP_SINGLE_SECURITY_QUESTION_CFG  struSecurityQuestion[MAX_QUESTION_LIST_LEN/*32*/];//ȫб
    char           szPassword[MAX_PASS_LEN];  //û
    unsigned char  byRes[512];
}SADP_SECURITY_QUESTION_CFG, *LPSADP_SECURITY_QUESTION_CFG;

typedef struct tagSADP_SECURITY_QUESTION
{
    unsigned char   byRetryAnswerTime;  //ʣðȫ
    unsigned char   bySurplusLockTime;  //ʣʱ䣬λӣûʱ˲Ч
    unsigned char   byRes[254];
}SADP_SECURITY_QUESTION, *LPSADP_SECURITY_QUESTION;

typedef struct tagSADP_RESET_PARAM_V40
{
    unsigned int    dwSize;
    unsigned char   byResetType;              // 0-,1- ͨ豸кŻָĬ()2-/ļ룬3-άã4-GUID5-ȫ⣬6-䣬7ֻɨ
    unsigned char   byEnableSyncIPCPW;        //ǷͬʱΪNVRͬIPC롣0 - ã 1- 
    unsigned char   byRes2[2];                //
    char            szPassword[MAX_PASS_LEN]; //û
    char            szCode[MAX_ENCRYPT_CODE]; //תַܹ߼ַܺ - byResetType Ϊ2367ʱЧ
    char            szAuthFile[MAX_FILE_PATH_LEN];//Ȩļ byResetType Ϊ2ʱЧ
    char            szGUID[MAX_GUID_LEN];     //GUID, byResetType Ϊ4ʱЧ
    SADP_SECURITY_QUESTION_CFG struSecurityQuestionCfg;//ȫṹ壬 byResetType Ϊ5ʱЧ
    unsigned char   byRes[512];
}SADP_RESET_PARAM_V40, *LPSADP_RESET_PARAM_V40;

typedef struct tagSADP_RESET_PARAM_V50
{
    unsigned int    dwSize;
    char            szPassword[MAX_PASS_LEN_V31];       //û
    char            szCode[MAX_ENCRYPT_CODE_V31];       //ÿbyResetTypeΪ2367ʱЧ
    char            szAuthFile[MAX_FILE_PATH_LEN];      //Ȩļ byResetTypeΪ2ʱЧ
    char            szGUID[MAX_GUID_LEN_V31];           //GUID, byResetTypeΪ4ʱЧ
    SADP_SECURITY_QUESTION_CFG struSecurityQuestionCfg; //ȫṹ壬 byResetTypeΪ5ʱЧ
    unsigned char   byResetType;                        // 0-1-ͨ豸кŻָĬ()2-/ļ룬3-άã4-GUID5-ȫ⣬6-䣬7ֻɨ
    unsigned char   byEnableSyncIPCPW;                  //ǷͬʱΪNVRͬIPC롣0-ã1-
    unsigned char   byRes[510];
}SADP_RESET_PARAM_V50, *LPSADP_RESET_PARAM_V50;

typedef struct tagSADP_RET_RESET_PARAM_V40
{
    unsigned char   byRetryGUIDTime;    //ʣô
    unsigned char   bySurplusLockTime;  //ʣʱ䣬λӣûʱ˲Ч
    unsigned char   bRetryTimeValid; //byRetryGUIDTimeֶǷЧ  0-Ч,1-Ч
    unsigned char   bLockTimeValid; //bySurplusLockTimeֶǷЧ  0-Ч,1-Ч
    unsigned char   byRes[252];
}SADP_RET_RESET_PARAM_V40, *LPSADP_RET_RESET_PARAM_V40;

//HCPlatform״̬
typedef struct tagSADP_HCPLATFORM_STATUS_INFO
{
    unsigned int    dwSize;
    unsigned char   byEnableHCPlatform;        //ǷHCPlatform0 -  1- ã 2-
    unsigned char   byRes[3];                  //
    char            szPassword[MAX_PASS_LEN];  //û
    unsigned char   byRes2[128];
}SADP_HCPLATFORM_STATUS_INFO, *LPSADP_HCPLATFORM_STATUS_INFO;

typedef struct tagSADP_USER_MAILBOX
{
    unsigned int    dwSize;
    char            szPassword[MAX_PASS_LEN];        //豸adminû
    char            szMailBoxAddr[MAX_MAILBOX_LEN];  //Ԥַڽصİȫ
    unsigned char   byRes[128];
}SADP_USER_MAILBOX, *LPSADP_USER_MAILBOX;
//豸֤
typedef struct tagSADP_VERIFICATION_CODE_INFO
{
    unsigned int    dwSize;
    char            szVerificationCode[SADP_MAX_VERIFICATION_CODE_LEN];  //֤루֤өʯ롢ԤƵΨһ룩
    char            szPassword[MAX_PASS_LEN];  //û
    unsigned char   byRes[128];
}SADP_VERIFICATION_CODE_INFO, *LPSADP_VERIFICATION_CODE_INFO;

//豸Ϣ
typedef struct tagSADP_DEV_LOCK_INFO
{
    unsigned char   byRetryTime;       //ʣɳԴ
    unsigned char   bySurplusLockTime; //ʣʱ䣬λӣûʱ˲Ч
    unsigned char   byRes[126];
}SADP_DEV_LOCK_INFO, *LPSADP_DEV_LOCK_INFO;

//豸Ϣṹ
typedef struct tagSADP_BIND_INFO
{
    char            szSerialNO[SADP_MAX_SERIALNO_LEN]; //豸к
    unsigned char   byiBind; //豸Ƿ 0-δ󶨣1-Ѱ
    unsigned char   byRes[127];
}SADP_BIND_INFO, *LPSADP_BIND_INFO;

typedef struct tagSADP_BIND_LIST
{
    SADP_BIND_INFO   struBindInfo[SADP_MAX_BIND_NUM]; //豸Ϣб
    char             szPassword[MAX_PASS_LEN]; //û
    unsigned char    byUnbindAll; //Ƿ豸 0-豸1-豸
    unsigned char    byRes[127];
}SADP_BIND_LIST, *LPSADP_BIND_LIST;

typedef struct tagSADP_INACTIVE_INFO
{
    char             szPassword[MAX_PASS_LEN];  //û
    unsigned char    byRes[128];
}SADP_INACTIVE_INFO, *LPSADP_INACTIVE_INFO;

//wifi Region
typedef struct tagSADP_WIFI_REGION_INFO
{
    unsigned char   byMode;                  //ģʽ0-1-wifiģʽ2-wifiǿģʽ
    unsigned char   byWifiRegion;            //wifi򣬵byModeΪ1ʱֶЧ0 -default 1- china, 2-nothAmerica,3-japan,4-europe,5-world
    unsigned char   byWifiEnhancementEnabled;//ǷwifiǿģʽbyModeΪ2ʱֶЧ 0 -ã 1- 
    unsigned char   byRes;                   //
    char            szPassword[MAX_PASS_LEN];//û
    unsigned char   byRes2[128];
}SADP_WIFI_REGION_INFO, *LPSADP_WIFI_REGION_INFO;

//ͨĬϢ
typedef struct tagSADP_CHANNEL_DEFAULT_PASSWORD
{
    char             szPassword[MAX_PASS_LEN]; //豸adminû
    char             szChannelDefaultPassword[MAX_PASS_LEN]; //ͨĬ루ûNVRIPC
    unsigned char    byRes[128];
}SADP_CHANNEL_DEFAULT_PASSWORD, *LPSADP_CHANNEL_DEFAULT_PASSWORD;


//豸Լ״̬ṹ
typedef struct tagSADP_SELF_CHECK_STATE
{
    unsigned int    dwSize;
    int             dwTotalDisk;               //ĬֵΪ-1
    int             dwGoodDisk;                //ĬֵΪ-1
    char            szCPU[MAX_CPU_LEN];        //CPU
    char            szMemory[MAX_MEMORY_LEN];  //ڴ
    unsigned char   byProgress;                //Լȣ0-100
    unsigned char   byTemperatureState;        //¶״̬0-Ч1-2-쳣
    unsigned char   byFanState;                //״̬0-Ч1-2-쳣
    unsigned char   byPowerState;              //Դ״̬0-Ч1-2-쳣
    unsigned char   bySASConnectState;         //SAS״̬0-Ч1-ӣ2-δ
    char            byTotalNetworkPort;        //ĬֵΪ-1
    char            byConnectNetworkPort;      //ĬֵΪ-1
    unsigned char   byRes[129];
}SADP_SELF_CHECK_STATE, *LPSADP_SELF_CHECK_STATE;

//EHomeʹܲ
typedef struct tagSADP_EHOME_ENABLE_PARAM
{
    unsigned int    dwSize;
    char            szDevID[MAX_PASS_LEN];     //豸ID
    char            szEhomeKey[MAX_PASS_LEN];  //Ehome Key
    char            szPassword[MAX_PASS_LEN];  //豸
    unsigned char   byRes[64];
}SADP_EHOME_ENABLE_PARAM, *LPSADP_EHOME_ENABLE_PARAM;

//WIFIýṹ
typedef struct tagSADP_WIFI_CONFIG_PARAM
{
    unsigned int    dwSize;
    char            szSSID[SADP_MAX_SERIALNO_LEN];      //SSID
    char            szPassword[SADP_MAX_SERIALNO_LEN];  //Password
    unsigned char   byWifiMode;  //wifiģʽ0-Ĭϣ1-Station 2-AP
    unsigned char   byRes[64];
}SADP_WIFI_CONFIG_PARAM, *LPSADP_WIFI_CONFIG_PARAM;

//Ͳýṹ
typedef struct tagSADP_PASSWORD_RESET_TYPE_PARAM
{
    unsigned int    dwSize;
    unsigned char   byEnable;  //0-δ  1-GUIDȫ⣬ȫ䣬HCùһֻ 
    unsigned char   byGuidEnabled;  //0-δGUID  1-GUID
    unsigned char   bySecurityQuestionEnabled;  //0-δùȫ  1-ùȫ
    unsigned char   bySecurityMailBoxEnabled;  //0-δùȫ  1-ùȫ
    unsigned char   byHikConnectEnabled;  //0-δHikConnect˺  1-󶨹HikConnect˺
    unsigned char   byRes1[3];
    unsigned char   byRes[64];
}SADP_PASSWORD_RESET_TYPE_PARAM, *LPSADP_PASSWORD_RESET_TYPE_PARAM;

//өʯûtokenṹ
typedef struct tagSADP_EZVIZ_USER_TOKEN_PARAM
{
    unsigned int    dwSize;
    char            szToken[MAX_TOKEN_LEN]; //token8-16ֽ
    char            szPassword[MAX_PASS_LEN]; //password8-16ֽ
    unsigned char   byRes[256];
}SADP_EZVIZ_USER_TOKEN_PARAM, *LPSADP_EZVIZ_USER_TOKEN_PARAM;

//ֻɨά
typedef struct tagSADP_PHONE_QR_CODES
{
    unsigned int    dwSize;
    char            szDomainName[MAX_QR_CODES];
    char            szDevModel[32];
    char            szQrCodes[MAX_QR_CODES_V31];
    unsigned char   byRes[128];
}SADP_PHONE_QR_CODES, *LPSADP_PHONE_QR_CODES;

//v3.1 GUIDṹ
typedef struct tagSADP_GUID_FILE_V31
{
    unsigned int    dwGUIDSize;
    char            szGUID[MAX_GUID_LEN_V31];
    SADP_DEV_LOCK_INFO struDevLockInfo; //豸Ϣ
    unsigned char   byRes[256];
}SADP_GUID_FILE_V31, *LPSADP_GUID_FILE_V31;

//Ϣ
typedef struct tagSADP_SUBNET_INFO
{
    unsigned int    dwSize;
    unsigned char   byIPType; //IPͣ0-IPv4 1-IPv6(ݲ֧)
    unsigned char   byRes1[3];
    char            szStartSubnetIP[48];           //ʼIP(IPַҪ\0)
    char            szStopSubnetIP[48];            //νIP(IPַҪ\0)
    unsigned char   byRes[128];
}SADP_SUBNET_INFO, *LPSADP_SUBNET_INFO;

//豸Ϣ
typedef struct tagSADP_SUBNET_DEVICE_INFO
{
    unsigned int    dwDeviceType;          //豸ֵͣ豸ͺ
    char            szDevDesc[64];         //豸 dwDeviceTypeӦ
    char            szSerialNO[128];       //豸к
    char            szIPv4Address[16];     //豸IPv4ַ
    char            szIPv4SubnetMask[16];  //豸IPv4
    char            szIPv4Gateway[16];     //IPv4
    char            szIPv6Address[46];     //IPv6ַ
    char            szIPv6Gateway[46];     //IPv6
    unsigned char   byIPv6MaskLen;         //IPv6ǰ׺
    unsigned char   bySupportIPv6;         //Ƿ֧IPv6, 0 ֧ 1 ֧
    unsigned char   bySupportModifyIPv6;   //Ƿ֧޸IPv6, 0 ֧ 1 ֧
    unsigned char   bySupportDhcp;         //Ƿ֧Dhcp, 0 ֧ 1 ֧
    unsigned char   byDhcpEnabled;         //Dhcp״̬, 0  1 
    unsigned char   byRes1[3];
    unsigned char   byRes[1024];
}SADP_SUBNET_DEVICE_INFO, *LPSADP_SUBNET_DEVICE_INFO;


//-----------------------------------------------------------------ӿ-----------------------------------------------------------------

//ص
typedef void (CALLBACK *PDEVICE_FIND_CALLBACK)(const SADP_DEVICE_INFO *lpDeviceInfo, void *pUserData);
typedef void (CALLBACK *PDEVICE_FIND_CALLBACK_V40)(const SADP_DEVICE_INFO_V40 *lpDeviceInfo, void *pUserData);
typedef void (CALLBACK *PSUBNET_DEVICE_FIND_CALLBACK)(const SADP_SUBNET_DEVICE_INFO *lpDeviceInfo, void *pUserData); //豸Ϣص

//
typedef struct tagSADP_START_PARAM
{
    PDEVICE_FIND_CALLBACK_V40 fnDevCB; //ͬ豸ص
    PSUBNET_DEVICE_FIND_CALLBACK fnSubnetDevCB; //豸صӦòʵֿʱNULL
    void* pUserData; //û
    unsigned char   byRes[1024];
}SADP_START_PARAM, *LPSADP_START_PARAM;

//sadp
CSADP_API BOOL CALLBACK SADP_Start_V30(PDEVICE_FIND_CALLBACK pDeviceFindCallBack, int bInstallNPF = 0, void* pUserData = NULL);
CSADP_API BOOL CALLBACK SADP_Start_V40(PDEVICE_FIND_CALLBACK_V40 pDeviceFindCallBack, int bInstallNPF = 0, void* pUserData = NULL);
CSADP_API BOOL CALLBACK SADP_Start_V50(const LPSADP_START_PARAM pStartParam);

//ֹͣsadp
CSADP_API BOOL CALLBACK SADP_Stop(void);

//豸
CSADP_API BOOL CALLBACK SADP_ActivateDevice(const char* sDevSerialNO, const char* sCommand);

//޸ ʹSADP_ModifyDeviceNetParam_V40
CSADP_API BOOL CALLBACK SADP_ModifyDeviceNetParam(const char* sMAC, const char* sPassword, const SADP_DEV_NET_PARAM *lpNetParam);
CSADP_API BOOL CALLBACK SADP_ModifyDeviceNetParam_V40(const char* sMAC, const char* sPassword, const SADP_DEV_NET_PARAM *lpNetParam, SADP_DEV_RET_NET_PARAM *lpRetNetParam, unsigned int  dwOutBuffSize);

// ʹSADP_ResetPasswd_V50
CSADP_API BOOL CALLBACK SADP_ResetDefaultPasswd(const char* sDevSerialNO, const char* sCommand);
CSADP_API BOOL CALLBACK SADP_ResetPasswd(const char* sDevSerialNO, const SADP_RESET_PARAM *pResetParam);
CSADP_API BOOL CALLBACK SADP_ResetPasswd_V40(const char* sDevSerialNO, const SADP_RESET_PARAM_V40 *pResetParam, SADP_RET_RESET_PARAM_V40 *pRetResetParam);
CSADP_API BOOL CALLBACK SADP_ResetPasswd_V50(const char* sDevSerialNO, const SADP_RESET_PARAM_V50 *pResetParam, SADP_DEV_LOCK_INFO *pLockInfo);

//
CSADP_API BOOL CALLBACK SADP_GetDeviceConfig(const char* sDevSerialNO, unsigned int dwCommand, void* lpInBuffer, unsigned int  dwinBuffSize, void *lpOutBuffer, unsigned int  dwOutBuffSize);
CSADP_API BOOL CALLBACK SADP_SetDeviceConfig(const char* sDevSerialNO, unsigned int dwCommand, void* lpInBuffer, unsigned int  dwInBuffSize, void* lpOutBuffer, unsigned int  dwOutBuffSize);
CSADP_API BOOL CALLBACK SADP_GetDeviceConfigByMAC(const char* sDevMAC, unsigned int dwCommand, void* lpInBuffer, unsigned int  dwinBuffSize, void *lpOutBuffer, unsigned int  dwOutBuffSize);

//SDKڲԶ
CSADP_API void CALLBACK SADP_SetAutoRequestInterval(unsigned int dwInterval); //Զʱ(λ룬Ϊ0ԶĬ60s)

//һξ
CSADP_API BOOL CALLBACK SADP_SendInquiry(void);
//һο
CSADP_API BOOL CALLBACK SADP_InquirySpecificSubnet(const SADP_SUBNET_INFO *pSubnetInfo);

//SDKڲ豸б
CSADP_API BOOL CALLBACK SADP_Clearup(void);

//豸˹
//dwFilterRule,λʾΪ1ʾˣȫ0ʾ;0x01:өʯ豸;0x02:OEM豸;0x03:өOEM豸;0xfffffffe:ʾөʯ豸;0xfffffffd:ʾOEM豸
CSADP_API BOOL CALLBACK SADP_SetDeviceFilterRule( unsigned int dwFilterRule, const void *lpInBuff, unsigned int dwInBuffLen);

//ȡSDK汾
CSADP_API unsigned int CALLBACK SADP_GetSadpVersion(void);

//SDK־
CSADP_API BOOL CALLBACK SADP_SetLogToFile(int nLogLevel=0, char const *strLogDir = NULL, int bAutoDel = 1);

//ȡ
CSADP_API unsigned int CALLBACK SADP_GetLastError(void);


#endif




