//
//  AppDelegate.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/27.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "AppDelegate.h"
#import "EZHCNetDeviceSDK.h"
#import "YKWoodpecker.h"
#import "FCFileManager.h"
#import "IQKeyboardManager.h"

@interface AppDelegate () <EZOpenSDKDelegate>

@end

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {
    [EZHCNetDeviceSDK initSDK];// 配网SDK初始化
    
    NSLog(@"EZOpenSDK Version = %@", [EZOPENSDK getVersion]);
    [self debug];// 连接Xcode调试时不做处理，没有连接时，将日志输出到文件
    [self setUpKeyboard];
    
    return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application {
    // Sent when the application is about to move from active to inactive state. This can occur for certain types of temporary interruptions (such as an incoming phone call or SMS message) or when the user quits the application and it begins the transition to the background state.
    // Use this method to pause ongoing tasks, disable timers, and throttle down OpenGL ES frame rates. Games should use this method to pause the game.
    NSLog(@"applicationWillResignActive");
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    // Use this method to release shared resources, save user data, invalidate timers, and store enough application state information to restore your application to its current state in case it is terminated later.
    // If your application supports background execution, this method is called instead of applicationWillTerminate: when the user quits.
    NSLog(@"applicationDidEnterBackground");
}

- (void)applicationWillEnterForeground:(UIApplication *)application {
    // Called as part of the transition from the background to the inactive state; here you can undo many of the changes made on entering the background.
    NSLog(@"applicationWillEnterForeground");
}

- (void)applicationDidBecomeActive:(UIApplication *)application {
    // Restart any tasks that were paused (or not yet started) while the application was inactive. If the application was previously in the background, optionally refresh the user interface.
    NSLog(@"applicationDidBecomeActive");
}

- (void)applicationWillTerminate:(UIApplication *)application {
    // Called when the application is about to terminate. Save data if appropriate. See also applicationDidEnterBackground:.
    NSLog(@"applicationWillTerminate");
}

- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window {
    return UIInterfaceOrientationMaskAllButUpsideDown;
}

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey, id> *)options {
    return [EZOPENSDK handleOpenUrl:url options:options delegate:self];
}

#pragma mark - EZAuthSDKDelegate

- (void)ezvizLoginResult:(BOOL)result {
    NSLog(@"EZVIZ login %@", result ? @"success" : @"fail");
}

#pragma mark - Custom Methods

- (void)debug {
    // Show the woodpecker, the 'ViewPicker' plugin will be open on launch.
    [YKWoodpeckerManager sharedInstance].autoOpenUICheckOnShow = YES;
    [[YKWoodpeckerManager sharedInstance] show];
    
    // Register the crash handler to log crash * Optional
    [[YKWoodpeckerManager sharedInstance] registerCrashHandler];

    // 如果没有连接Xcode调试，则输出到文件
    if (!isatty(STDOUT_FILENO)) {
        [self redirectNSLog];
    }
}

- (void)redirectNSLog {
    // 将NSlog打印信息保存到Document目录下的ezopensdk/Log文件夹下
    NSString *logDirectory = PATH_ProjectLog;
    [FCFileManager createDirectoriesForPath:PATH_ProjectLog];

    // 每次启动后都保存一个新的日志文件中
    NSString *dateStr = [[NSDate date] formattedDateWithFormat:@"yyyy-MM-dd_HH" locale:[[NSLocale alloc] initWithLocaleIdentifier:@"zh_CN"]];
    NSString *logFilePath = [logDirectory stringByAppendingFormat:@"/a_%@.log", dateStr];
    
    // 将log输入到文件
    freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding], "a+", stdout);
    freopen([logFilePath cStringUsingEncoding:NSASCIIStringEncoding], "a+", stderr);
}

- (void)setUpKeyboard {
    // 键盘处理的设置
    IQKeyboardManager *manager = [IQKeyboardManager sharedManager];
    manager.enable = YES;
    manager.shouldResignOnTouchOutside = YES;
    manager.shouldToolbarUsesTextFieldTintColor = YES;
    manager.enableAutoToolbar = YES;
}

@end
