//
//  EZBusinessTool.h
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2022/2/15.
//  Copyright © 2022 hikvision. All rights reserved.
//

#import <Foundation/Foundation.h>
@class EZDeviceInfo;
@class EZCameraInfo;
@class EZDeviceDetailPublicInfo;

NS_ASSUME_NONNULL_BEGIN

@interface EZBusinessTool : NSObject

#pragma mark - 预览

/** 根据videoLevel获取设备视频质量名，0-流畅，1-均衡，2-高清，3-超清，4-极清，5-3K，6-4K */
+ (NSString *)getDeviceQualityTitle:(NSInteger)videoLevel;

/** 获取比当前清晰度高一级的清晰度 */
+ (NSInteger)getHigherVideoLevel:(NSInteger)currentVideoLevel deviceDetailPublicInfo:(EZDeviceDetailPublicInfo *)deviceDetailPublicInfo;

/** 获取比当前清晰度低一级的清晰度 */
+ (NSInteger)getLowerVideoLevel:(NSInteger)currentVideoLevel deviceDetailPublicInfo:(EZDeviceDetailPublicInfo *)deviceDetailPublicInfo;

/** 根据type获取取流方式名 */
+ (NSString *)getStreamType:(int)type;

/** 根据type获取视频编码格式 */
+ (NSString *)getVideoEncodeType:(int)type;

/** 检查是否有对讲权限 */
+ (void)checkMicPermissionResult:(void(^)(BOOL enable))retCb;

/** 检查是否有相机权限 */
+ (void)checkCameraPermissionResult:(void(^)(BOOL enable))retCb;

#pragma mark - 能力集判断

/** 是否支持对讲 */
+ (NSInteger)isSupportTalk:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持云台 */
+ (BOOL)isSupportPTZ:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持内网直连时倍数设置 */
+ (BOOL)isSupportDirectInnerRelaySpeed:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持回放倍率设置 */
+ (BOOL)isSupportPlaybackRate:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持SD卡录像封面 */
+ (BOOL)isSupportSdCover:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持SD卡录像下载 */
+ (BOOL)isSupportSDRecordDownload:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持双目 */
+ (BOOL)isSupportMultiChannel:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 是否支持自动清晰度 */
+ (BOOL)isSupportDeviceAutoVideolevel:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo;

/** 获取设备热点前缀 */
+ (NSString *)getWiFiConfigPrefix:(NSInteger)deviceHotSpot;

#pragma mark - 其他方法

+ (void)judgeRect:(CGRect *)rect;

@end

NS_ASSUME_NONNULL_END
