//
//  EZBusinessTool.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2022/2/15.
//  Copyright © 2022 hikvision. All rights reserved.
//

#import "EZBusinessTool.h"
#import <AVFoundation/AVFoundation.h>
#import "EZDeviceInfo.h"
#import "EZCameraInfo.h"
#import "EZSubDeviceInfo.h"
#import "EZDeviceDetailPublicInfo.h"
#import "EZVideoQualityInfo.h"

@implementation EZBusinessTool

#pragma mark - 预览

+ (NSString *)getDeviceQualityTitle:(NSInteger)videoLevel {
    NSString *qualityTitle = NSLocalizedString(@"device_quality_low",@"流畅");
    switch (videoLevel) {
        case 1:
            qualityTitle = NSLocalizedString(@"device_quality_median", @"均衡");
            break;
        case 2:
            qualityTitle = NSLocalizedString(@"device_quality_high", @"高清");
            break;
        case 3:
            qualityTitle = NSLocalizedString(@"device_quality_super", @"超清");
            break;
        case 4:
            qualityTitle = NSLocalizedString(@"device_quality_extreme", @"极清");
            break;
        case 5:
            qualityTitle = NSLocalizedString(@"device_quality_3k", @"3K");
            break;
        case 6:
            qualityTitle = NSLocalizedString(@"device_quality_4k", @"4K");
            break;
            
        default:
            break;
    }
    return qualityTitle;
}

+ (NSInteger)getHigherVideoLevel:(NSInteger)currentVideoLevel deviceDetailPublicInfo:(EZDeviceDetailPublicInfo *)deviceDetailPublicInfo {
    if (deviceDetailPublicInfo && deviceDetailPublicInfo.videoQualityInfos) {
        NSInteger targetVideoLevel = 0;
        NSInteger dif = 100;
        for (int i = 0; i < deviceDetailPublicInfo.videoQualityInfos.count; i ++) {
            EZVideoQualityInfo *videoQualityInfo = deviceDetailPublicInfo.videoQualityInfos[i];
            NSInteger videoLevel = videoQualityInfo.videoLevel;
            // 遍历找出比当前videoLevel大 且 最接近 的清晰度值
            if (videoLevel > currentVideoLevel && videoLevel - currentVideoLevel < dif) {
                targetVideoLevel = videoLevel;
                dif = videoLevel - currentVideoLevel;
            }
        }
        if (targetVideoLevel > 0) {
            return targetVideoLevel;
        }
    }
    
    return currentVideoLevel;
}

+ (NSInteger)getLowerVideoLevel:(NSInteger)currentVideoLevel deviceDetailPublicInfo:(EZDeviceDetailPublicInfo *)deviceDetailPublicInfo {
    if (deviceDetailPublicInfo && deviceDetailPublicInfo.videoQualityInfos) {
        NSInteger targetVideoLevel = 0;
        NSInteger dif = 100;
        for (int i = 0; i < deviceDetailPublicInfo.videoQualityInfos.count; i ++) {
            EZVideoQualityInfo *videoQualityInfo = deviceDetailPublicInfo.videoQualityInfos[i];
            NSInteger videoLevel = videoQualityInfo.videoLevel;
            // 遍历找出比当前videoLevel大 且 最接近 的清晰度值
            if (videoLevel < currentVideoLevel && currentVideoLevel - videoLevel < dif) {
                targetVideoLevel = videoLevel;
                dif = currentVideoLevel - videoLevel;
            }
        }
        if (targetVideoLevel > 0) {
            return targetVideoLevel;
        }
    }
    
    return currentVideoLevel;
}

+ (NSString *)getStreamType:(int)type {
    NSString *streamTypeName = @"";
    switch (type) {
        case 0:
            streamTypeName = @"private_stream";
            break;
        case 1:
            streamTypeName = @"p2p";
            break;
        case 2:
            streamTypeName = @"direct_inner";
            break;
        case 3:
            streamTypeName = @"direct_outer";
            break;
        case 4:
            streamTypeName = @"cloud_playback";
            break;
        case 5:
            streamTypeName = @"cloud_leave_msg";
            break;
        case 6:
            streamTypeName = @"direct_reverse";
            break;
        case 7:
            streamTypeName = @"hcnetsdk";
            break;
        default:
            streamTypeName = [NSString stringWithFormat:@"unknown(%d)", type];
            break;
    }
    return [NSString stringWithFormat:@"stream type: %@", streamTypeName];
}

+ (NSString *)getVideoEncodeType:(int)type {
    NSString *videoEncodeTypeName = @"";
    switch (type) {
        case 0:
            videoEncodeTypeName = @"无编码";
            break;
        case 1:
            videoEncodeTypeName = @"HIK264";
            break;
        case 2:
            videoEncodeTypeName = @"MPEG2";
            break;
        case 3:
            videoEncodeTypeName = @"MPEG4";
            break;
        case 4:
            videoEncodeTypeName = @"MJPEG";
            break;
        case 5:
            videoEncodeTypeName = @"H265";
            break;
        case 6:
            videoEncodeTypeName = @"SVAC";
            break;
        case 256:
            videoEncodeTypeName = @"H264";
            break;
        default:
            videoEncodeTypeName = [NSString stringWithFormat:@"unknown(%d)", type];
            break;
    }
    return [NSString stringWithFormat:@"videoEncode type: %@", videoEncodeTypeName];
}

+ (void)checkMicPermissionResult:(void(^)(BOOL enable))retCb {
    AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeAudio];
    
    switch (authStatus) {
        case AVAuthorizationStatusNotDetermined:// 未决
        {
            AVAudioSession *avSession = [AVAudioSession sharedInstance];
            [avSession performSelector:@selector(requestRecordPermission:) withObject:^(BOOL granted) {
                if (granted) {
                    if (retCb) {
                        retCb(YES);
                    }
                } else {
                    if (retCb) {
                        retCb(NO);
                    }
                }
            }];
        }
            break;
            
        case AVAuthorizationStatusRestricted:// 未授权，家长限制
        case AVAuthorizationStatusDenied:// 未授权
            if (retCb) {
                retCb(NO);
            }
            break;
            
        case AVAuthorizationStatusAuthorized:// 已授权
            if (retCb) {
                retCb(YES);
            }
            break;
            
        default:
            if (retCb) {
                retCb(NO);
            }
            break;
    }
}

+ (void)checkCameraPermissionResult:(void(^)(BOOL enable))retCb {
    AVAuthorizationStatus authStatus = [AVCaptureDevice authorizationStatusForMediaType:AVMediaTypeVideo];
    
    switch (authStatus) {
        case AVAuthorizationStatusNotDetermined:// 未决
        {
            [AVCaptureDevice requestAccessForMediaType:AVMediaTypeVideo completionHandler:^(BOOL granted) {
                if (granted) {
                    if (retCb) {
                        retCb(YES);
                    }
                } else {
                    if (retCb) {
                        retCb(NO);
                    }
                }
            }];
        }
            break;
            
        case AVAuthorizationStatusRestricted:// 未授权，家长限制
        case AVAuthorizationStatusDenied:// 未授权
            if (retCb) {
                retCb(NO);
            }
            break;
            
        case AVAuthorizationStatusAuthorized:// 已授权
            if (retCb) {
                retCb(YES);
            }
            break;
            
        default:
            if (retCb) {
                retCb(NO);
            }
            break;
    }
}

#pragma mark - 能力集判断

/** 是否支持对讲 */
+ (NSInteger)isSupportTalk:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    // 网关下子设备的能力集挂载在自己的对象上
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportTalk;
    }
    return deviceInfo.isSupportTalk;
}

/** 是否支持云台 */
+ (BOOL)isSupportPTZ:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportPTZ;
    }
    return deviceInfo.isSupportPTZ;
}

/** 是否支持内网直连时倍数设置 */
+ (BOOL)isSupportDirectInnerRelaySpeed:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    // 网关下子设备的能力集挂载在自己的对象上
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportDirectInnerRelaySpeed;
    }
    return deviceInfo.isSupportDirectInnerRelaySpeed;
}

/** 是否支持回放倍率设置 */
+ (BOOL)isSupportPlaybackRate:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportPlaybackRate;
    }
    return deviceInfo.isSupportPlaybackRate;
}

/** 是否支持SD卡录像封面 */
+ (BOOL)isSupportSdCover:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportSdCover;
    }
    return deviceInfo.isSupportSdCover;
}

/** 是否支持SD卡录像下载 */
+ (BOOL)isSupportSDRecordDownload:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportSDRecordDownload;
    }
    return deviceInfo.isSupportSDRecordDownload;
}

/** 是否支持双目 */
+ (BOOL)isSupportMultiChannel:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportMultiChannel;
    }
    return deviceInfo.isSupportMultiChannel;
}

/** 是否支持自动清晰度 */
+ (BOOL)isSupportDeviceAutoVideolevel:(EZDeviceInfo *)deviceInfo cameraInfo:(EZCameraInfo *)cameraInfo {
    if ([cameraInfo isKindOfClass:[EZSubDeviceInfo class]]) {
        EZSubDeviceInfo *subDeviceInfo = (EZSubDeviceInfo *)cameraInfo;
        return subDeviceInfo.isSupportDeviceAutoVideolevel;
    }
    return deviceInfo.isSupportDeviceAutoVideolevel;
}

/** 获取设备热点前缀 */
+ (NSString *)getWiFiConfigPrefix:(NSInteger)deviceHotSpot {
    NSString *WiFiConfigPrefix = @"EZVIZ";
    switch (deviceHotSpot) {
        case 1:
            WiFiConfigPrefix = @"SoftAP";
            break;
        case 2:
            WiFiConfigPrefix = @"CAMGO";
            break;
            
        default:
            break;
    }
    return WiFiConfigPrefix;
}

#pragma mark - 其他方法

+ (void)judgeRect:(CGRect *)rect {
    CGFloat offsetX = 0;
    CGFloat offsetY = 0;
    if (rect->origin.x < 0) {
        offsetX = ABS(rect->origin.x);
    }
    if (rect->origin.y < 0) {
        offsetY = ABS(rect->origin.y);
    }
    if (rect->origin.x + rect->size.width > 1.0) {
        offsetX = 1.0 - rect->origin.x - rect->size.width;
    }
    if (rect->origin.y + rect->size.height > 1.0) {
        offsetY = 1.0 - rect->origin.y - rect->size.height;
    }
    rect->origin.x += offsetX;
    rect->origin.y += offsetY;
}

@end
