//
//  EZScreenOrientationTool.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2023/8/16.
//  Copyright © 2023 hikvision. All rights reserved.
//

#import "EZScreenOrientationTool.h"

@implementation EZScreenOrientationTool

/** 竖屏 */
+ (void)portrait:(UIViewController *)vc {
    if (@available(iOS 16.0, *)) {
        [vc setNeedsUpdateOfSupportedInterfaceOrientations];
        [self orientationSwitch];
    } else {
        NSNumber *value = [NSNumber numberWithInt:UIInterfaceOrientationPortrait];
        [[UIDevice currentDevice] setValue:value forKey:@"orientation"];
    }
}


/** 横屏 */
+ (void)landscape:(UIViewController *)vc {
    if (@available(iOS 16.0, *)) {
        [vc setNeedsUpdateOfSupportedInterfaceOrientations];
        [self orientationSwitch];
    } else {
        NSNumber *value = [NSNumber numberWithInt:UIInterfaceOrientationLandscapeLeft];
        [[UIDevice currentDevice] setValue:value forKey:@"orientation"];
    }
}

/** 横竖屏切换 */
+ (void)orientationSwitch {
    if (@available(iOS 16.0, *)) {
        NSArray *array = [[[UIApplication sharedApplication] connectedScenes] allObjects];
        UIWindowScene *scene = [array firstObject];
        UIInterfaceOrientationMask orientationMask = scene.interfaceOrientation == UIInterfaceOrientationPortrait ? UIInterfaceOrientationMaskLandscapeLeft : UIInterfaceOrientationMaskPortrait;
        UIWindowSceneGeometryPreferencesIOS *geometryPreferencesIOS = [[UIWindowSceneGeometryPreferencesIOS alloc] initWithInterfaceOrientations:orientationMask];
        [scene requestGeometryUpdateWithPreferences:geometryPreferencesIOS errorHandler:^(NSError * _Nonnull error) {
            
        }];
    }
}

@end
