//
//  EZMacros.h
//  EZOpenSDKDemo 存放常用的一些宏
//
//  Created by JuneCheng on 2021/08/12.
//  Copyright © 2021年  Ezviz. All rights reserved.
//

// 弱引用
#define EZWeak(type) __weak typeof(type) weak##type = type;
#define EZStrong(type) __strong typeof(type) strong##type = weak##type;

// app版本
#define CFBundleVersion @"CFBundleVersion"
#define CFBundleShortVersionString @"CFBundleShortVersionString"
#define kAppVersionCode [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"]
#define kAppVersionName [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleShortVersionString"]

// 色值
#define RGBColor(r, g, b) [UIColor colorWithRed:(r)/255.0 green:(g)/255.0 blue:(b)/255.0 alpha:1.0]
#define RGBAColor(r, g, b ,a) [UIColor colorWithRed:(r)/255.0 green:(g)/255.0 blue:(b)/255.0 alpha:a]
#define HEXColor(hex) [UIColor colorWithRed:((float)((hex & 0xFF0000) >> 16)) / 255.0 green:((float)((hex & 0xFF00) >> 8)) / 255.0 blue:((float)(hex & 0xFF)) / 255.0 alpha:1]
#define COLOR_RGB(rgbValue,a) [UIColor colorWithRed:((float)(((rgbValue) & 0xFF0000) >> 16))/255.0 green:((float)(((rgbValue) & 0xFF00)>>8))/255.0 blue: ((float)((rgbValue) & 0xFF))/255.0 alpha:(a)]
#define RandomColor [UIColor colorWithHue: (arc4random() % 256 / 256.0) saturation:((arc4random()% 128 / 256.0 ) + 0.5) brightness:(( arc4random() % 128 / 256.0 ) + 0.5) alpha:1]

// 屏幕宽高
#define kScreenWidth [[UIScreen mainScreen] bounds].size.width
#define kScreenHeight [[UIScreen mainScreen] bounds].size.height

#define kStatusBarHeight [[UIApplication sharedApplication] statusBarFrame].size.height
#define kNavigationBarHeight 44.0f
#define kNavBarAndStatusBarHeight (kStatusBarHeight + kNavigationBarHeight)
#define kTabbarSafeBottomMargin (kStatusBarHeight > 20 ? 34.f : 0.f)
#define kTabBarHeight 49.f
#define kContentViewHeight (kScreenHeight - kStatusBarHeight - kNavigationBarHeight - kTabbarSafeBottomMargin)

// 日期格式化
#define yMdHmsFormat   @"yyyy-MM-dd HH:mm:ss"
#define yMdHmFormat    @"yyyy-MM-dd HH:mm"
#define yMdFormat      @"yyyy-MM-dd"
#define yMFormat       @"yyyy-MM"
#define MdFormat       @"MM-dd"
#define MdHmFormat     @"MM-dd HH:mm"
#define HmsFormat      @"HH:mm:ss"
#define HmFormat       @"HH:mm"

// Global Fonsts

// 中文字体
#define CHINESE_FONT_NAME  @"Heiti SC"
#define CHINESE_SYSTEM(x) [UIFont fontWithName:CHINESE_FONT_NAME size:x]

// 不同屏幕尺寸字体适配（320，568是因为效果图为IPHONE5 如果不是则根据实际情况修改）
#define kScreenWidthRatio  (kScreenWidth / 320.0)
#define kScreenHeightRatio (kScreenHeight / 568.0)
#define AdaptedWidth(x)  ceilf((x) * kScreenWidthRatio)
#define AdaptedHeight(x) ceilf((x) * kScreenHeightRatio)
#define AdaptedFontSize(R)     CHINESE_SYSTEM(AdaptedWidth(R))

// 大标题 40点
#define kBigTitleFont [UIFont fontWithName:@"Helvetica Neue" size:20]
// 小标题 28点
#define kSmallTitleFont [UIFont fontWithName:@"Helvetica Neue" size:14]
// 普通文本，正文
#define kNormalTextFont [UIFont fontWithName:@"Helvetica Neue" size:15]
// 步骤条文字
#define kSmallTextFont [UIFont fontWithName:@"Helvetica Neue" size:11]
// 正文按钮字体
#define kButtonTitleFont [UIFont fontWithName:@"Helvetica Neue" size:14]
// 弹出框按钮大小
#define kSmallButtonTitleFont [UIFont fontWithName:@"Helvetica Neue" size:13]

// 判断系统版本
#define iOS11_Later ([UIDevice currentDevice].systemVersion.floatValue >= 11.0f)

// AppDelegate对象
#define AppDelegateInstance [[UIApplication sharedApplication] delegate]
// 一些缩写
#define Main_Screen_Bounds  [[UIScreen mainScreen] bounds]
#define kApplication        [UIApplication sharedApplication]
#define kKeyWindow          [UIApplication sharedApplication].keyWindow
#define kUserDefaults       [NSUserDefaults standardUserDefaults]
#define kNotificationCenter [NSNotificationCenter defaultCenter]
#define kBundle             [NSBundle mainBundle]

// 获取图片资源
#define GetImage(imageName) [UIImage imageNamed:[NSString stringWithFormat:@"%@",imageName]]
// Library/Caches 文件路径
#define FilePath ([[NSFileManager defaultManager] URLForDirectory:NSCachesDirectory inDomain:NSUserDomainMask appropriateForURL:nil create:YES error:nil])
// 获取temp
#define kPathTemp NSTemporaryDirectory()
// 获取沙盒 Document
#define kPathDocument [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) firstObject]
#define kPathDocumentWithName(name) [kPathDocument stringByAppendingPathComponent:name]
// 获取沙盒 Cache
#define kPathCache [NSSearchPathForDirectoriesInDomains(NSCachesDirectory, NSUserDomainMask, YES) firstObject]
#define kPathCacheWithName(name) [kPathCache stringByAppendingPathComponent:name]

// 将nil转化成空值
#define nil2Empty(string) string?:@""
// 字符串是否为空
#define kStringIsEmpty(str) ([str isKindOfClass:[NSNull class]] || str == nil || [str length] < 1 ? YES : NO )
// 数组是否为空
#define kArrayIsEmpty(array) (array == nil || [array isKindOfClass:[NSNull class]] || array.count == 0)
// 字典是否为空
#define kDictIsEmpty(dic) (dic == nil || [dic isKindOfClass:[NSNull class]] || dic.allKeys == 0)
// 是否是空对象
#define kObjectIsEmpty(_object) (_object == nil \
|| [_object isKindOfClass:[NSNull class]] \
|| ([_object respondsToSelector:@selector(length)] && [(NSData *)_object length] == 0) \
|| ([_object respondsToSelector:@selector(count)] && [(NSArray *)_object count] == 0))

// 在Main线程上运行
#define DISPATCH_ON_MAIN_THREAD(mainQueueBlock) dispatch_async(dispatch_get_main_queue(), mainQueueBlock);

// 主线程上Demo
//DISPATCH_ON_MAIN_THREAD(^{
//更新UI
//})


// 在Global Queue上运行
#define DISPATCH_ON_GLOBAL_QUEUE_HIGH(globalQueueBlocl) dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_HIGH, 0), globalQueueBlocl);
#define DISPATCH_ON_GLOBAL_QUEUE_DEFAULT(globalQueueBlocl) dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), globalQueueBlocl);
#define DISPATCH_ON_GLOBAL_QUEUE_LOW(globalQueueBlocl) dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_LOW, 0), globalQueueBlocl);
#define DISPATCH_ON_GLOBAL_QUEUE_BACKGROUND(globalQueueBlocl) dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_BACKGROUND, 0), globalQueueBlocl);

#define DISPATCH_AFTER(seconds, block) dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(seconds * NSEC_PER_SEC)), main_queue, block)

#define global_queue dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0)
#define main_queue dispatch_get_main_queue()

// 查看一段代码的执行时间
#define TICK   NSDate *startTime = [NSDate date];
#define TOCK   NSLog(@"Time: %f", -[startTime timeIntervalSinceNow]);

#define NSLogFunc NSLog(@"=====Begin==========\n FILE: %@\n FUNC: %s\n LINE: %d\n", [NSString stringWithUTF8String:__FILE__].lastPathComponent, __PRETTY_FUNCTION__, __LINE__)


