//
//  GlobalKit.h
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/27.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface GlobalKit : NSObject

@property (nonatomic, copy) NSString *deviceSerialNo;   // 设备序列号
@property (nonatomic, copy) NSString *deviceModel;      // 设备类型字符串
@property (nonatomic, copy) NSString *deviceVerifyCode; // 设备验证码
@property (nonatomic, copy) NSMutableDictionary *deviceVerifyCodeBySerial;// 内存存储：设备验证码（Value）序列号（Key）字典

// 配网的前缀：萤石是EZVIZ，定制设备根据能力集获取，方法为[EZBusinessTool getWiFiConfigPrefix:deviceInfo.deviceHotSpot]
@property (nonatomic, copy) NSString *WiFiConfigPrefix;

@property (nonatomic, copy) NSString *previewStreamToken; // 小权限预览取流token
@property (nonatomic, copy) NSString *talkStreamToken;    // 小权限对讲取流token
@property (nonatomic, copy) NSString *playbackStreamToken;// 小权限回放取流token

@property (nonatomic, assign) EZVideoQualityType videoQuality;//视频质量

// 应用层本地记录各个取流方式的开关状态
@property (nonatomic, assign) BOOL enableDirectInner;// 是否允许内网直连取流
@property (nonatomic, assign) BOOL enableP2P;// 是否允许P2P取流
@property (nonatomic, assign) BOOL enableVTDU;// 是否允许流媒体取流

+ (instancetype)shareKit;

- (void)clearDeviceInfo;

- (void)saveDeviceVerifyCodes2File;

- (void)clearAllDeviceSerialVerifyCode;

/** 保存账号信息 */
- (void)saveLastSDKInitAppkey:(NSString *)appKey accessToken:(NSString *)accessToken apiUrl:(NSString *)apiUrl authUrl:(NSString *)authUrl specifiedDevice:(NSString *)specifiedDevice;

/** 移除账号信息 */
- (void)removeLastSDKInitParams;

@end
