//
//  GlobalKit.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/27.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "GlobalKit.h"

@implementation GlobalKit

+ (instancetype)shareKit {
    static GlobalKit *kit = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        kit = [GlobalKit new];
        kit.previewStreamToken = @"";
        kit.talkStreamToken = @"";
        kit.playbackStreamToken = @"";
        kit.videoQuality = EZVideoQualityTypeNone;
        
        // SDK中内网直连 和 流媒体默认开启，P2P默认关闭
        kit.enableDirectInner = YES;
        kit.enableP2P = NO;
        kit.enableVTDU = YES;
    });
    return kit;
}

- (instancetype)init
{
    self = [super init];
    if (self) {
        _deviceVerifyCodeBySerial = [NSKeyedUnarchiver unarchiveObjectWithFile:PATH_DeviceVerifyCodeBySerial];
        if (!_deviceVerifyCodeBySerial) {
            _deviceVerifyCodeBySerial = [NSMutableDictionary dictionary];
        }
        self.WiFiConfigPrefix = @"EZVIZ";
    }
    return self;
}

- (void)clearDeviceInfo {
    self.deviceVerifyCode = nil;
    self.deviceSerialNo = nil;
    self.deviceModel = nil;
}

- (void)saveDeviceVerifyCodes2File {
    [NSKeyedArchiver archiveRootObject:[GlobalKit shareKit].deviceVerifyCodeBySerial toFile:PATH_DeviceVerifyCodeBySerial];
}

- (void)clearAllDeviceSerialVerifyCode {
    _deviceVerifyCodeBySerial = [NSMutableDictionary dictionary];
    [self saveDeviceVerifyCodes2File];
}

- (void)saveLastSDKInitAppkey:(NSString *)appKey accessToken:(NSString *)accessToken apiUrl:(NSString *)apiUrl authUrl:(NSString *)authUrl specifiedDevice:(NSString *)specifiedDevice {
    [kUserDefaults setObject:appKey forKey:UserAppKey];
    [kUserDefaults setObject:accessToken forKey:UserToken];
    [kUserDefaults setObject:apiUrl forKey:UserApiUrl];
    [kUserDefaults setObject:authUrl forKey:UserAuthUrl];
    [kUserDefaults setObject:specifiedDevice forKey:UserDevSerial];
    [kUserDefaults synchronize];
}

- (void)removeLastSDKInitParams {
    [kUserDefaults setObject:@"" forKey:UserAppKey];
    [kUserDefaults setObject:@"" forKey:UserToken];
//    [kUserDefaults setObject:nil forKey:UserApiUrl];
//    [kUserDefaults setObject:nil forKey:UserAuthUrl];
//    [kUserDefaults setObject:@"" forKey:UserDevSerial];
    [kUserDefaults synchronize];
}

@end
