//
//  NSString+EZExtension.h
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2021/10/19.
//  Copyright © 2021 hikvision. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

@interface NSString (EZExtension)


+ (BOOL)isBlank:(NSString *)str;

- (NSString *)add:(NSString *)str;

- (CGSize)sizeWithFont:(UIFont *)font maxW:(CGFloat)maxW;

- (CGSize)sizeWithFont:(UIFont *)font maxH:(CGFloat)maxH;

- (CGSize)sizeWithFont:(UIFont *)font;

- (NSString *)substringBeforeLast:(NSString *)str;

- (NSString *)substringBeforeFirst:(NSString *)str;


- (NSString *)substringAfterLast:(NSString *)str;


- (NSInteger)lastIndexOfStr:(NSString *)str;

- (NSString *)replaceStrWith:(NSString *)replaceStr afater:(NSString *)str between:(NSString *)start and:(NSString *)end;

- (NSInteger) indexOfStr:(NSString *)str;

- (NSRange)getRangeWithStart:(NSString *)start andEnd:(NSString *)end;

- (NSString *)getStrWithStart:(NSString *)start andEnd:(NSString *)end;

- (NSString *)getStrBetween:(NSString *)start andEnd:(NSString *)end;


- (int) compareTo:(NSString *)anotherString;

- (int) compareToIgnoreCase:(NSString *)str;


- (BOOL)isContainChinese;

- (BOOL)contains:(NSString *)str;

- (BOOL)startsWith:(NSString *)prefix;

- (BOOL)endsWith:(NSString *)suffix;

- (BOOL)equals:(NSString *)anotherString;

- (BOOL)equalsIgnoreCase:(NSString *)anotherString;

- (int)indexOfChar:(unichar)ch;

- (int)indexOfChar:(unichar)ch fromIndex:(int)index;

- (int)indexOfString:(NSString *)str;

- (int)indexOfString:(NSString *)str fromIndex:(int)index;

- (int)lastIndexOfChar:(unichar)ch;

- (int)lastIndexOfChar:(unichar)ch fromIndex:(int)index;

- (int)lastIndexOfString:(NSString *)str;

- (int)lastIndexOfString:(NSString *)str fromIndex:(int)index;

- (NSString *)substringFromIndex:(int)beginIndex toIndex:(int)endIndex;

- (NSString *)toLowerCase;

- (NSString *)toUpperCase;

- (NSString *)trim;

- (NSString *)replaceAll:(NSString *)origin with:(NSString *)replacement;

- (NSArray *)split:(NSString *)separator;

- (NSString *)urlEncode;

- (NSString *)urlDecode;

- (NSString *)md5StringForString;

- (NSString *)getMd5_32Bit;


- (NSString *)deleteFanXieGang;


- (BOOL)isIdentityNum;

- (NSDictionary *)dictionaryWithJsonString;

- (NSString *)removeEscapeChar;

- (NSString *)removeHTMLTags;

- (NSString *)encodeUTF8;

/** 获取uuid */
+ (NSString *)getUUIDString;

/** 添加xml声明header */
- (NSString *)addXMLStatementHead;

/** 字符串与数组中的任何一个字符相等即返回YES */
- (BOOL)isEqualToAnyStringInArray:(NSArray *)array;

/** 字符串包含数组中的任何一个字符即返回YES */
- (BOOL)isContainsAnyStringInArray:(NSArray *)array;

/** 是否是Url */
- (BOOL)isRegularUrl;

/** 是否是纯数字 */
- (BOOL)isNumberString;

/** 16进制字符串转换成NSData */
- (NSData *)convertHexStringToData;

/** 从字符串中取出数字字符串 */
- (NSString *)getNumberFromString;

/** 将字符串中的关键字加粗放大 */
- (NSMutableAttributedString *)stressWithKeywords:(NSArray<NSString *> *)keywords;

/** 获取这个字符串中的所有abc的所在的index */
- (NSMutableArray *)rangesOfKeyword:(NSString *)keyword;

@end
