//
//  UIAlertController+DeviceVerifyCodeBySerial.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2021/8/14.
//  Copyright © 2021 hikvision. All rights reserved.
//

#import "UIAlertController+DeviceVerifyCodeBySerial.h"
#import "JXTAlertController.h"

@implementation UIAlertController (DeviceVerifyCodeBySerial)

+ (void)showAlertWithDeviceSerial:(NSString *)deviceSerial confirmBlock:(void(^)(NSString *code))confirmBlock {
    [self showAlertWithDeviceSerial:deviceSerial confirmBlock:confirmBlock cancelBlock:^{}];
}

+ (void)showAlertWithDeviceSerial:(NSString *)deviceSerial confirmBlock:(void(^)(NSString *code))confirmBlock cancelBlock:(void(^)())cancelBlock {
    [self showAlertWithDeviceSerial:deviceSerial title:NSLocalizedString(@"device_input_verify_code", @"请输入视频图片加密密码") message:NSLocalizedString(@"device_verify_code_tip", @"您的视频已加密，请输入密码进行查看，初始密码为机身标签上的验证码，如果没有验证码，请输入ABCDEF（密码区分大小写)") confirmBlock:confirmBlock cancelBlock:cancelBlock];
}

+ (void)showAlertWithDeviceSerial:(NSString *)deviceSerial title:(NSString *)title message:(NSString *)message confirmBlock:(void(^)(NSString *code))confirmBlock cancelBlock:(void(^)())cancelBlock {
    [UIAlertController showAlertWithTitle:title message:message appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
        alertMaker.addActionCancelTitle(NSLocalizedString(@"cancel", @"取消"));
        alertMaker.addActionDefaultTitle(NSLocalizedString(@"done", @"确定"));
        [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
            textField.placeholder = @"请输入验证码";
            textField.clearButtonMode = UITextFieldViewModeWhileEditing;
        }];
    } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
        if (buttonIndex == 1) {
            NSString *code = alertSelf.textFields.firstObject.text;
            if (deviceSerial.length > 0 && code.length > 0) {
                [[GlobalKit shareKit].deviceVerifyCodeBySerial setValue:code forKey:deviceSerial];
                [[GlobalKit shareKit] saveDeviceVerifyCodes2File];
            }
            if (confirmBlock) {
                confirmBlock(code);
            }
        } else {
            if (cancelBlock) {
                cancelBlock();
            }
        }
    }];
}


+ (void)showDeviceSerialRetryAlert:(void(^)())confirmBlock {
    [UIAlertController showAlertWithTitle:NSLocalizedString(@"device_tip_title", @"温馨提示") message:NSLocalizedString(@"device_verify_code_wrong", @"设备密码错误") appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
        alertMaker.addActionCancelTitle(NSLocalizedString(@"cancel", @"取消"));
        alertMaker.addActionDefaultTitle(NSLocalizedString(@"retry", @"重试"));
    } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
        if (buttonIndex == 1) {
            if (confirmBlock) {
                confirmBlock();
            }
        }
    }];
}

@end
