//
//  UIButton+EZNav.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2021/9/16.
//  Copyright © 2021 hikvision. All rights reserved.
//

#import "UIButton+EZNav.h"

#undef	NAV_BUTTON_MIN_WIDTH
#define	NAV_BUTTON_MIN_WIDTH	(40.0f)

#undef	NAV_BUTTON_MIN_HEIGHT
#define	NAV_BUTTON_MIN_HEIGHT	(40.0f)

#undef	NAV_BAR_HEIGHT
#define	NAV_BAR_HEIGHT	(44.0f)

@implementation UIButton (EZNav)

- (UIButton *)initNavigationButton:(UIImage *)image {
    return [self initNavigationButton:image highImage:nil];
}

- (UIButton *)initNavigationButton:(UIImage *)image highImage:(UIImage *)highImage {
    CGRect buttonFrame = CGRectZero;
    
    self = [self initWithFrame:buttonFrame];
    self.contentMode = UIViewContentModeScaleAspectFit;
    self.backgroundColor = [UIColor clearColor];
    [self setBackgroundImage:image forState:UIControlStateNormal];
    if (highImage) {
        [self setBackgroundImage:highImage forState:UIControlStateHighlighted];
    }
    
    self.size = self.currentBackgroundImage.size;
    return self;
}

- (UIButton *)initNavigationButtonWithTitle:(NSString *)str color:(UIColor *)color {
    CGRect buttonFrame = CGRectZero;
    
    CGSize titleSize = [str boundingRectWithSize:CGSizeMake(999999.0f, NAV_BAR_HEIGHT) options:NSStringDrawingUsesLineFragmentOrigin attributes:@{NSFontAttributeName:[UIFont boldSystemFontOfSize:16]} context:nil].size;
    
    buttonFrame = CGRectMake(0, 0, titleSize.width, NAV_BAR_HEIGHT);
    
    self = [self initWithFrame:buttonFrame];
    self.contentMode = UIViewContentModeScaleAspectFit;
    self.backgroundColor = [UIColor clearColor];
    self.titleLabel.font = [UIFont systemFontOfSize:16.0f];
    [self setTitleColor:color forState:UIControlStateNormal];
    [self setTitle:str forState:UIControlStateNormal];
    return self;
}

@end
