//
//  UIView+EZExtension.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2021/8/12.
//  Copyright © 2021 hikvision. All rights reserved.
//

#import "UIView+EZExtension.h"
#import <objc/runtime.h>

@implementation UIView (EZExtension)

@dynamic option, paramet;

- (id)paramet
{
    id paramet = objc_getAssociatedObject(self, @"UIView (Extension)");
    return paramet;
}

- (void)setParamet:(id)paramet
{
    objc_setAssociatedObject(self, @"UIView (Extension)", paramet, OBJC_ASSOCIATION_RETAIN);
}

- (void)removeAllSubView {
//    [self.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
   for (UIView *view in [self subviews]) {
        [view removeFromSuperview];
    }
}

- (ViewBlock)option
{
    id paramet = objc_getAssociatedObject(self, @"UIView+option");
    return paramet;
}

- (void)setOption:(ViewBlock)option
{
    objc_setAssociatedObject(self, @"UIView+option", option, OBJC_ASSOCIATION_RETAIN);
}

- (void)addActionBlock:(ViewBlock)option {
    self.option = option;
    self.userInteractionEnabled = YES;
    UITapGestureRecognizer *singleTap1 = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(viewAction)];
    [self addGestureRecognizer:singleTap1];
}

- (void)viewAction {
    if (self.option) {
        __weak __typeof(self)weakSelf = self;
        self.option(weakSelf);
    }
}




- (void)setX:(CGFloat)x
{
    CGRect frame = self.frame;
    frame.origin.x = x;
    self.frame = frame;
}

- (void)setY:(CGFloat)y
{
    CGRect frame = self.frame;
    frame.origin.y = y;
    self.frame = frame;
}

- (CGFloat)x
{
    return self.frame.origin.x;
}

- (CGFloat)y
{
    return self.frame.origin.y;
}

- (void)setCenterX:(CGFloat)centerX
{
    CGPoint center = self.center;
    center.x = centerX;
    self.center = center;
}

- (CGFloat)centerX
{
    return self.center.x;
}

- (void)setCenterY:(CGFloat)centerY
{
    CGPoint center = self.center;
    center.y = centerY;
    self.center = center;
}

- (CGFloat)centerY
{
    return self.center.y;
}

- (void)setWidth:(CGFloat)width
{
    CGRect frame = self.frame;
    frame.size.width = width;
    self.frame = frame;
}

- (void)setHeight:(CGFloat)height
{
    CGRect frame = self.frame;
    frame.size.height = height;
    self.frame = frame;
}

- (CGFloat)height
{
    return self.frame.size.height;
}

- (CGFloat)width
{
    return self.frame.size.width;
}

- (void)setSize:(CGSize)size
{
    CGRect frame = self.frame;
    frame.size = size;
    self.frame = frame;
}

- (CGSize)size
{
    return self.frame.size;
}

- (void)setOrigin:(CGPoint)origin
{
    CGRect frame = self.frame;
    frame.origin = origin;
    self.frame = frame;
}

- (CGPoint)origin
{
    return self.frame.origin;
}




- (void)setLeft:(CGFloat)left {
    CGRect frame = self.frame;
    frame.origin.x = left;
    self.frame = frame;
}

- (CGFloat)left {
    return self.frame.origin.x;
}

- (void)setRight:(CGFloat)right {
    CGRect frame = self.frame;
    frame.origin.x = right - self.frame.size.width;
    self.frame = frame;
}

- (CGFloat)right {
    return self.frame.origin.x + self.frame.size.width;
}

- (void)setTop:(CGFloat)top {
    CGRect frame = self.frame;
    frame.origin.y = top;
    self.frame = frame;
}

- (CGFloat)top {
    return self.frame.origin.y;
}

- (void)setBottom:(CGFloat)bottom {
    CGRect frame = self.frame;
    frame.origin.y = bottom - self.frame.size.height;
    self.frame = frame;
}

- (CGFloat)bottom {
    return self.frame.origin.y + self.frame.size.height;
}

@end
