//
//  BaseTableViewController.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2022/1/5.
//  Copyright © 2022 hikvision. All rights reserved.
//

#import "BaseTableViewController.h"

@interface BaseTableViewController ()<UITableViewDelegate, UITableViewDataSource>

@property (nonatomic, assign) UITableViewStyle tableViewStyle;

@end

@implementation BaseTableViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    
    [self.view addSubview:self.tableView];
}

#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return 0;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    return [UITableViewCell new];
}

- (instancetype)initWithStyle:(UITableViewStyle)style {
    if (self = [super init]) {
        _tableViewStyle = style;
    }
    return self;
}

#pragma mark 懒加载

- (UITableView *)tableView {
    if (!_tableView) {
        _tableView = [[UITableView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, kContentViewHeight) style:self.tableViewStyle];
        // 当tableView设置StyleGrouped类型，去除顶部空白区域，frame不能设置为CGRectZero
        _tableView.tableHeaderView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, kScreenWidth, CGFLOAT_MIN)];
        _tableView.tableFooterView = [[UIView alloc] initWithFrame:CGRectZero];
        _tableView.backgroundColor = self.view.backgroundColor;
        //    _tableView.separatorStyle = UITableViewCellSeparatorStyleNone;
        
        //    UITableViewCellSeparatorStyleNone,
        //    UITableViewCellSeparatorStyleSingleLine,
        //    UITableViewCellSeparatorStyleSingleLineEtched
        
        // 适配 ios 11
        _tableView.estimatedRowHeight = 0;
        _tableView.estimatedSectionHeaderHeight = 0;
        _tableView.estimatedSectionFooterHeight = 0;
        
        _tableView.delegate = self;
        _tableView.dataSource = self;
    }
    return _tableView;
}

@end
