//
//  EZNavigationController.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2021/9/26.
//  Copyright © 2021 hikvision. All rights reserved.
//

#import "EZNavigationController.h"

@interface EZNavigationController ()

@end

@implementation EZNavigationController

+ (void)initialize
{
    /************** UINavigationBar设置 ***************/
    UINavigationBar *navBar = [UINavigationBar appearance];
    navBar.barTintColor = [UIColor whiteColor];
    // 去掉导航栏下面的黑线
    [navBar setBackgroundImage:[[UIImage alloc] init]
                                      forBarPosition:UIBarPositionAny
                                          barMetrics:UIBarMetricsDefault];
    [navBar setShadowImage:[[UIImage alloc] init]];
    // 导航栏title字体大小、颜色
    NSDictionary *attributes = [NSDictionary dictionaryWithObjectsAndKeys:
                                [UIColor blackColor],
                                NSForegroundColorAttributeName, nil];
    [navBar setTitleTextAttributes:attributes];
    // 导航栏图标颜色
    [navBar setTintColor:HEXColor(0x3263f7)];
    if (@available(iOS 15, *)) {
        UINavigationBarAppearance *app = [[UINavigationBarAppearance alloc] init];
        [app configureWithOpaqueBackground];// 重置背景和阴影颜色
        [app setTitleTextAttributes:attributes];
        app.backgroundColor = [UIColor whiteColor];// 设置导航栏背景色
        app.shadowColor = [UIColor clearColor];
        app.shadowImage = [[UIImage alloc] init];// 设置导航栏下边界分割线透明
        navBar.scrollEdgeAppearance = app;// 带scroll滑动的页面
        navBar.standardAppearance = app;// 常规页面
    }
    
    /************** UIBarButtonItem设置 ***************/
    // 设置整个项目所有item的主题样式
    UIBarButtonItem *item = [UIBarButtonItem appearance];
    // 设置普通状态
    // key：NS****AttributeName
    NSMutableDictionary *textAttrs = [NSMutableDictionary dictionary];
    textAttrs[NSForegroundColorAttributeName] = HEXColor(0x3263f7);
    textAttrs[NSFontAttributeName] = [UIFont systemFontOfSize:17];
    [item setTitleTextAttributes:textAttrs forState:UIControlStateNormal];

    // 设置不可用状态
    NSMutableDictionary *disableTextAttrs = [NSMutableDictionary dictionary];
    //    disableTextAttrs[NSForegroundColorAttributeName] = [UIColor colorWithRed:0.6 green:0.6 blue:0.6 alpha:0.7];
    disableTextAttrs[NSForegroundColorAttributeName] = [UIColor whiteColor];
    disableTextAttrs[NSFontAttributeName] = textAttrs[NSFontAttributeName];
    [item setTitleTextAttributes:disableTextAttrs forState:UIControlStateDisabled];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationBar.translucent = NO;
}

@end
