//
//  PreviewTableViewController.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2022/1/5.
//  Copyright © 2022 hikvision. All rights reserved.
//

#import "PreviewTableViewController.h"

@interface PreviewTableViewController ()

@property (nonatomic, assign) UITableViewCellStyle tableViewCellStyle;

@end

@implementation PreviewTableViewController

- (instancetype)init {
    return [super initWithStyle:UITableViewStylePlain];
}

- (void)viewDidLoad {
    [super viewDidLoad];
}

- (void)setupDataArr:(NSArray *)dataArr {
    
    NSMutableArray *tempTitleArr = [NSMutableArray array];
    NSMutableArray *tempNamesArr = [NSMutableArray array];
    
    for (NSArray *arr in dataArr) {
        [tempTitleArr addObject:arr[0]];
        [tempNamesArr addObject:arr[1]];
    }
    self.titles = tempTitleArr;
    self.classNames = tempNamesArr;
    
    [self.tableView reloadData];
}


#pragma mark - UITableViewDataSource
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    
    return self.titles.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellIdentifier = @"previewCellIdentifier";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if (cell == nil) {
        UITableViewCellStyle style = self.tableViewCellStyle ?:UITableViewCellStyleSubtitle;
        cell = [[UITableViewCell alloc] initWithStyle:style reuseIdentifier:cellIdentifier];
        // UITableViewCellStyleValue1 模式下不加箭头
        if (self.tableViewCellStyle == UITableViewCellStyleValue1) {
            
        } else {
            cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
        }
    }
    cell.selectionStyle = UITableViewCellSelectionStyleGray;
    NSString *labelText;
    if (indexPath.row < 9) {
        labelText = [NSString stringWithFormat:@"0%zd - %@", indexPath.row + 1, self.titles[indexPath.row]];
    } else {
        labelText = [NSString stringWithFormat:@"%zd - %@", indexPath.row + 1, self.titles[indexPath.row]];
    }
    cell.textLabel.text = labelText;
    cell.detailTextLabel.text = self.classNames[indexPath.row];
    return cell;
}

#pragma mark - UITableViewDelegate
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    return 50;
}


- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    NSString *className = self.classNames[indexPath.row];
    if (kStringIsEmpty(className)) {
        return;
    }
    
    // 注意: 如果是sb来搭建, 必须以 _UIStoryboard 结尾
    NSUInteger classNameLength = className.length;
    NSUInteger storyBoardLength = @"_UIStoryboard".length;
    NSUInteger xibLength = @"_xib".length;
    
    NSString *suffixClassName;
    if (classNameLength > storyBoardLength) {
        suffixClassName = [className substringFromIndex:classNameLength - storyBoardLength];
    }
    //    else {
    //        suffixClassName = className;
    //    }
    
    if ([suffixClassName isEqualToString:@"_UIStoryboard"]) {
        className = [className substringToIndex:classNameLength - storyBoardLength];
        // 注意: 这个storyboard的名字必须是控制器的名字
        UIStoryboard *storyBoard = [UIStoryboard storyboardWithName:className bundle:nil];
        UIViewController *cardVC = [storyBoard instantiateInitialViewController];
        if (!cardVC) {
            cardVC = [storyBoard instantiateViewControllerWithIdentifier:className];
        }
        cardVC.title = self.titles[indexPath.row];
        [self.navigationController pushViewController:cardVC animated:YES ];
        
    } else if ([[className substringFromIndex:classNameLength - xibLength] isEqualToString:@"_xib"]) {
        
        className = [className substringToIndex:classNameLength - xibLength];
        
        UIViewController *vc = [[NSClassFromString(className) alloc]initWithNibName:className bundle:nil];
        vc.title = self.titles[indexPath.row];
        [self.navigationController pushViewController:vc animated:YES];
        
    } else {
        NSLog(@"className = %@", className);
        UIViewController *vc = [[NSClassFromString(className) alloc] init];
        vc.title = self.titles[indexPath.row];
        [self.navigationController pushViewController:vc animated:YES];
    }
}

- (instancetype)initWithTableViewCellStyle:(UITableViewCellStyle)style {
    if (self = [super init]) {
        _tableViewCellStyle = style;
    }
    return self;
}

@end

