//
//  EZCustomSlider.h
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/9/22.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import <Foundation/Foundation.h>
@class EZCustomSlider;

// 协议
@protocol EZCustomSliderDelegate<NSObject>

@optional
- (void)customSlider:(EZCustomSlider *_Nullable)slider valueChanged:(float)value;

@end


NS_ASSUME_NONNULL_BEGIN

@interface EZCustomSlider : UIView

@property (nonatomic, strong) UISlider *slider;///<
@property (nonatomic, strong) UILabel *lab_minValue;///< 最小值组件
@property (nonatomic, strong) UILabel *lab_maxValue;///< 最大值组件
@property (nonatomic, strong) UILabel *lab_currentValue;///< 当前值
@property (nonatomic, strong) UILabel *lab_title;///< 组件名

@property (nonatomic, weak) id <EZCustomSliderDelegate> delegate;

- (instancetype)initWithTitle:(NSString *)title minimumValue:(float)minimumValue maximumValue:(float)maximumValue currentValue:(float)currentValue;
- (void)setTitleWidth:(float)width;

@end



NS_ASSUME_NONNULL_END
