//
//  EZCustomSlider.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/9/22.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import "EZCustomSlider.h"

NS_ASSUME_NONNULL_BEGIN

@interface EZCustomSlider()

@property (nonatomic, copy) NSString *title;
@property (nonatomic, assign) float minimumValue;
@property (nonatomic, assign) float maximumValue;
@property (nonatomic, assign) float currentValue;

@end

@implementation EZCustomSlider

- (instancetype)initWithTitle:(NSString *)title minimumValue:(float)minimumValue maximumValue:(float)maximumValue currentValue:(float)currentValue {
    self.title = title;
    self.minimumValue = minimumValue;
    self.maximumValue = maximumValue;
    self.currentValue = currentValue;
    
    return [self initWithFrame:CGRectZero];
}

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setUI];
        [self setLayout];
        
        self.slider.value = (self.currentValue - self.minimumValue) / (self.maximumValue - self.minimumValue);
        DISPATCH_AFTER(0.1, ^{
            [self setCurrentValueAndPostion:self.slider];
        });
    }
    return self;
}

/** 创建UI */
- (void)setUI {
    [self addSubview:self.slider];
    [self addSubview:self.lab_title];
    [self addSubview:self.lab_minValue];
    [self addSubview:self.lab_maxValue];
    [self addSubview:self.lab_currentValue];
}

/** Slider滑动变化 */
- (void)sliderValueChanged:(id)sender {
    UISlider *slider = (UISlider *)sender;
    [self setCurrentValueAndPostion:slider];
    
    if (self.delegate && [self.delegate respondsToSelector:@selector(customSlider:valueChanged:)]) {
        [self.delegate customSlider:self valueChanged:self.currentValue];
    }
}

/** 设置当前Slider显示的值 和 位置 */
- (void)setCurrentValueAndPostion:(UISlider *)slider {
    self.currentValue = (self.maximumValue - self.minimumValue) * slider.value + self.minimumValue;
    if (self.maximumValue >= 9) {
        self.lab_currentValue.text = [NSString stringWithFormat:@"%0.0f", self.currentValue];
    } else {
        self.lab_currentValue.text = [NSString stringWithFormat:@"%0.1f", self.currentValue];
    }
    
    // 计算滑块thumbRect的位置
    CGRect trackRect = [slider trackRectForBounds:slider.bounds];
    CGRect thumbRect = [slider thumbRectForBounds:slider.bounds trackRect:trackRect value:slider.value];
    // 将thumbRect转换为view坐标系
    CGRect convertedThumbRect = [slider convertRect:thumbRect toView:self];
    [self.lab_currentValue mas_updateConstraints:^(MASConstraintMaker *make) {
        make.left.mas_equalTo(CGRectGetMidX(convertedThumbRect)-self.lab_currentValue.width*0.5);
    }];
}

#pragma mark - Public Methods

- (void)setTitleWidth:(float)width {
    [self.lab_title mas_updateConstraints:^(MASConstraintMaker *make) {
        make.width.mas_equalTo(width);
    }];
}

#pragma mark - 懒加载

- (UISlider *)slider {
    if (!_slider) {
        _slider = [[UISlider alloc] init];
        _slider.minimumTrackTintColor = HEXColor(0x3fb895);
        _slider.thumbTintColor = HEXColor(0x3fb895);
        [_slider setThumbImage:[UIImage imageNamed:@"watermark_slider"] forState:UIControlStateNormal];
        [_slider setThumbImage:[UIImage imageNamed:@"watermark_slider"] forState:UIControlStateHighlighted];
        [_slider addTarget:self action:@selector(sliderValueChanged:) forControlEvents:UIControlEventValueChanged];
    }
    return _slider;
}

- (UILabel *)lab_title {
    if (!_lab_title) {
        _lab_title = [[UILabel alloc] init];
        _lab_title.font = [UIFont systemFontOfSize:14.f];
        _lab_title.textColor = [UIColor grayColor];
        _lab_title.textAlignment = NSTextAlignmentRight;
        _lab_title.text = [NSString stringWithFormat:@"%@：", self.title];
    }
    return _lab_title;
}

- (UILabel *)lab_minValue {
    if (!_lab_minValue) {
        _lab_minValue = [[UILabel alloc] init];
        _lab_minValue.font = [UIFont systemFontOfSize:14.f];
        _lab_minValue.textColor = [UIColor lightGrayColor];
        _lab_minValue.text = [NSString stringWithFormat:@"%0.0f", self.minimumValue];
    }
    return _lab_minValue;
}

- (UILabel *)lab_maxValue {
    if (!_lab_maxValue) {
        _lab_maxValue = [[UILabel alloc] init];
        _lab_maxValue.font = [UIFont systemFontOfSize:14.f];
        _lab_maxValue.textColor = [UIColor lightGrayColor];
        _lab_maxValue.textAlignment = NSTextAlignmentRight;
        _lab_maxValue.text = [NSString stringWithFormat:@"%0.0f", self.maximumValue];
    }
    return _lab_maxValue;
}

- (UILabel *)lab_currentValue {
    if (!_lab_currentValue) {
        _lab_currentValue = [[UILabel alloc] init];
        _lab_currentValue.font = [UIFont systemFontOfSize:14.f];
        _lab_currentValue.textColor = HEXColor(0x3fb895);
        if (self.maximumValue >= 9) {
            _lab_currentValue.text = [NSString stringWithFormat:@"%0.0f", self.currentValue];
        } else {
            _lab_currentValue.text = [NSString stringWithFormat:@"%0.1f", self.currentValue];
        }
    }
    return _lab_currentValue;
}

#pragma mark - 设置约束

- (void)setLayout {
    [self.slider mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self);
        make.left.equalTo(self.lab_title.mas_right).offset(5);
        make.right.equalTo(self).offset(-10);
    }];
    [self.lab_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.equalTo(self).offset(10);
        make.width.mas_equalTo(110);
        make.centerY.equalTo(self.slider).offset(3);
    }];
    [self.lab_minValue mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self);
        make.left.equalTo(self.slider);
    }];
    [self.lab_maxValue mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.lab_minValue);
        make.right.equalTo(self.slider);
    }];
    [self.lab_currentValue mas_makeConstraints:^(MASConstraintMaker *make) {
        make.bottom.equalTo(self.lab_minValue);
    }];
}


@end

NS_ASSUME_NONNULL_END
