//
//  YSHorDashRadiusBoard.m
//  YSRealBaseModule
//
//  Created by zhilshi on 2018/11/8.
//

#import "YSHorDashRadiusBoard.h"

@interface YSHorDashBoard :UIView
@property (nonatomic,assign)float percent;

@end
@implementation YSHorDashBoard
- (id)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame])
    {
        self.backgroundColor = [UIColor clearColor];
        _percent = 0.5;
    }
    return self;
}

- (void)updatePercent:(float)percent
{
    int curValue = self.percent *100;
    int nValue   = 100 *percent;
    if(curValue == nValue)return;
    
    self.percent = percent;
    [self setNeedsDisplay];
}

- (void)drawRect:(CGRect)rect {
    // Drawing code
    CGContextRef context = UIGraphicsGetCurrentContext();//获得当前view的图形上下文(context)
    CGContextSetLineWidth(context, 1.0);//制定了线的宽度
    CGContextSetStrokeColorWithColor(context, [UIColor whiteColor].CGColor);//也是创建颜色,一句话即可
    
    CGContextSetLineWidth(context, 1.0);//制定了线的宽度
//    CGContextMoveToPoint(context, 4, self.height-1);//设置线段起始
//    CGContextAddLineToPoint(context,self.width-4,self.height-1);//设置线段终点
//    CGContextStrokePath(context);//绘制
    
    int x = _percent*360.0/90.0;
    float offsetx = (_percent * 360 - 90*x)*6.0/45.0;
    NSLog(@"offsetx is %f",offsetx);
//    if(self.increase)
//    {
        float firstX = 4.0;
        for(int i = 0;i < 10;i++)
        {
            if(firstX-offsetx+i*6 < 4)continue;
            if(firstX-offsetx+i*6 > self.width-4)continue;
            CGContextMoveToPoint(context, firstX-offsetx+i*6, self.height-1);//设置线段起始
            CGContextAddLineToPoint(context,firstX-offsetx+i*6,i%2?self.height/2.0:0);//
            CGContextStrokePath(context);//绘制
        }
//    }
//    else
//    {
//        float firstX = self.width-4;
//        for (int i = 8; i > 0; i--) {
//            CGContextMoveToPoint(context, firstX + offsetx -i*6, self.height-1);//设置线段起始
//            CGContextAddLineToPoint(context,firstX + offsetx -i*6,i%2?self.height/2.0:0);//
//            CGContextStrokePath(context);//绘制
//        }
//    }
}

@end
@interface YSHorDashRadiusBoard()
@property (nonatomic,strong)YSHorDashBoard *dashBoard;
@property (nonatomic,strong)UIImageView *arrowView;
@property (nonatomic,strong)CAGradientLayer *lineLayer;

@end


@implementation YSHorDashRadiusBoard

- (instancetype)initWithFrame:(CGRect)frame percent:(float)percent
{
    if(self = [super initWithFrame:frame])
    {
        [self addSubview:self.arrowView];
        [self addSubview:self.dashBoard];
        [self.layer addSublayer:self.lineLayer];
        [self updatePercent:percent isSupportNoLimit:NO];
    }
    return self;
}

- (void)updatePercent:(float)percent isSupportNoLimit:(BOOL)isSupportNoLimit;
{
    if(isSupportNoLimit)
    {
        [self.dashBoard updatePercent:percent];
        [self.dashBoard setNeedsLayout];
        [self.dashBoard layoutIfNeeded];
        self.arrowView.frame = CGRectMake(self.width/2-6, 0 , 12, 12);
    }
    else
    {
        [self.dashBoard updatePercent:0.5];
        float curWidth = percent * (self.width-8);
        self.arrowView.frame = CGRectMake(curWidth+4-6, 0 , 12, 12);
    }
}

- (UIImageView *)arrowView
{
    if(!_arrowView)
    {
        _arrowView = [[UIImageView alloc]initWithImage:[UIImage imageNamed:@"ptz_scale_arrow_down"]];
        _arrowView.frame = CGRectMake(self.width/2-6, 0 , 12, 12);
    }
    return _arrowView;
}
- (YSHorDashBoard *)dashBoard
{
    if(!_dashBoard)
    {
        _dashBoard = [[YSHorDashBoard alloc]initWithFrame:CGRectMake(0, self.height-8, 4+48+4, 8)];
    }
    return _dashBoard;
}
- (CAGradientLayer*)lineLayer
{
    if(!_lineLayer)
    {
        _lineLayer = ({
            CAGradientLayer *_gradientLayer = [CAGradientLayer layer];
            _gradientLayer.bounds = CGRectMake(0, self.height-1, self.width, 1);
            _gradientLayer.borderWidth = 0;
            _gradientLayer.frame = CGRectMake(0, self.height-1, self.width, 1);
            _gradientLayer.colors = [NSArray arrayWithObjects:
                                     (id)[UIColor colorWithWhite:1.0 alpha:0].CGColor,
                                     (id)[UIColor whiteColor].CGColor,
                                     (id)[UIColor whiteColor].CGColor,
                                     (id)[UIColor colorWithWhite:1.0 alpha:0].CGColor,nil];
            _gradientLayer.locations = @[@(1.0/self.width),@(4.0/self.width),@((self.width-4.0)/self.width),@((self.width-1.0)/self.width)];
            _gradientLayer.startPoint = CGPointMake(0.0, 0);
            _gradientLayer.endPoint = CGPointMake(1.0, 0);
            _gradientLayer;
        });
    }
    return _lineLayer;
}
@end
