//
//  YSVerDashRadiusBoard.m
//  YSRealBaseModule
//
//  Created by zhilshi on 2018/11/8.
//

#import "YSVerDashRadiusBoard.h"

@interface YSVerDashBoard :UIView
@end
@implementation YSVerDashBoard
- (id)initWithFrame:(CGRect)frame
{
    if(self = [super initWithFrame:frame])
    {
        self.backgroundColor = [UIColor clearColor];
    }
    return self;
}

- (void)drawRect:(CGRect)rect {
    // Drawing code
    CGContextRef context = UIGraphicsGetCurrentContext();//获得当前view的图形上下文(context)
    CGContextSetLineWidth(context, 1.0);//制定了线的宽度
    CGContextSetStrokeColorWithColor(context, [UIColor whiteColor].CGColor);//也是创建颜色,一句话即可
    
    CGContextSetLineWidth(context, 1.0);//制定了线的宽度

    
    int max = 9;
    float margin = ceilf(self.height/8);
    for (int i = 0; i <= max; i++) {
        if(i == 0)
        {
            CGContextMoveToPoint(context, 0, 1);//设置线段起始
            CGContextAddLineToPoint(context,self.width-1,1);//设置线段终点
        }
        else if (i == max)
        {
            CGContextMoveToPoint(context, 0, self.height-0.5);//设置线段起始
            CGContextAddLineToPoint(context,self.width-1,self.height-0.5);//设置线段终点
        }
        else
        {
            CGContextMoveToPoint(context, i%2?self.width/2:0, i*margin);//设置线段起始
            CGContextAddLineToPoint(context,self.width-1,i*margin);//设置线段终点
        }
        CGContextStrokePath(context);//绘制
    }
    
    CGContextMoveToPoint(context, self.width-1, 0);//设置线段起始
    CGContextAddLineToPoint(context,self.width-1,self.height);//设置线段终点
    CGContextStrokePath(context);//绘制
}
@end
@interface YSVerDashRadiusBoard()
@property (nonatomic,strong)YSVerDashBoard *dashBoard;
@property (nonatomic,strong)UIImageView *arrowView;
@end


@implementation YSVerDashRadiusBoard

- (instancetype)initWithFrame:(CGRect)frame percent:(float)percent
{
    if(self = [super initWithFrame:frame])
    {
        [self addSubview:self.arrowView];
        [self addSubview:self.dashBoard];
        [self updatePercent:percent animated:NO];
    }
    return self;
}

- (void)updatePercent:(float)percent animated:(BOOL)animated
{
    float curHeight = percent *self.height;
    if(animated)
    {
        [UIView animateWithDuration:0.1 animations:^{
            self.arrowView.frame = CGRectMake(0, curHeight-6, 12, 12);
        }];
    }
    else
    {
        self.arrowView.frame = CGRectMake(0, curHeight-6, 12, 12);
    }
}

- (YSVerDashBoard *)dashBoard
{
    if(!_dashBoard)
    {
        _dashBoard = [[YSVerDashBoard alloc]initWithFrame:CGRectMake(self.width-8, 0, 8, self.height)];
    }
    return  _dashBoard;
}
- (UIImageView *)arrowView
{
    if(!_arrowView)
    {
        _arrowView = [[UIImageView alloc]initWithImage:[UIImage imageNamed:@"ptz_scale_arrow_right"]];
        _arrowView.size = CGSizeMake(12, 12);
    }
    return _arrowView;
}
@end
