//
//  EZCommonTool.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2021/11/12.
//  Copyright © 2021 hikvision. All rights reserved.
//

#import "EZCommonTool.h"
#import <SystemConfiguration/CaptiveNetwork.h>

@implementation EZCommonTool

+ (NSString *)getWiFiName {
    NSString *currentSsid = @"";
    NSArray *interfaces = CFBridgingRelease(CNCopySupportedInterfaces());
    for (NSString *ifnam in interfaces) {
        NSDictionary *info = CFBridgingRelease(CNCopyCurrentNetworkInfo((__bridge CFStringRef)ifnam));
        currentSsid = info[@"SSID"];
        break;
    }
    return currentSsid;
}

+ (void)toSystemWiFiSettingPage {
    NSString *urlStr = [[[UIDevice currentDevice] systemVersion] floatValue] >= 10.0 ? @"App-Prefs:root=WIFI" : @"prefs:root=WIFI";

    NSURL * url = [NSURL URLWithString:urlStr];
    if ([[UIApplication sharedApplication] canOpenURL:url]) {
        [[UIApplication sharedApplication] openURL:url options:@{} completionHandler:^(BOOL success) {
            
        }];
    }
}

+ (NSString *)convToUIDuration:(NSTimeInterval)playSeconds {
    NSString *time = @"00:00";
    if (playSeconds >= 3600) {
        int hour = (int)playSeconds / 3600;
        int minute =  ((int)playSeconds % 3600) / 60;
        int seconds = (int)playSeconds % 60;
        time = [NSString stringWithFormat:@"%02d:%02d:%02d", hour, minute, seconds];
    } else {
        int minute =  (int)playSeconds / 60;
        int seconds = (int)playSeconds % 60;
        time = [NSString stringWithFormat:@"%02d:%02d", minute, seconds];
    }
    
    return time;
}

+ (NSMutableArray *)reverseArray:(NSMutableArray *)array {
    NSArray *reversedArray = [[array reverseObjectEnumerator] allObjects];
    return [NSMutableArray arrayWithArray:reversedArray];
}

@end
