//
//  EZIoTBLECommonDefine.h
//  EZIoTBluetoothSDK
//
//  Created by yuqian on 2021/9/17.
//
#import <CoreBluetooth/CBManager.h>

#define EZIOT_CID @"2B18"
#define EZIOT_BEACON_CID @"2B19"
#define EZIOT_SERVICE_UUID  [CBUUID UUIDWithString:@"0xFCCC"]
#define EZIOT_SERVICE_UUID1  [CBUUID UUIDWithString:@"0xFDCC"]
#define EZIOT_READ_CHARACTERISTIC_UUID  [CBUUID UUIDWithString:@"0xFED4"]
#define EZIOT_WRITE_CHARACTERISTIC_UUID  [CBUUID UUIDWithString:@"0xFED5"]
#define EZIOT_INDICATE_CHARACTERISTIC_UUID  [CBUUID UUIDWithString:@"0xFED6"]
#define EZIOT_WRITE_NO_RSP_CHARACTERISTIC_UUID  [CBUUID UUIDWithString:@"0xFED7"]
#define EZIOT_NOTIFY_CHARACTERISTIC_UUID  [CBUUID UUIDWithString:@"0xFED8"]

#define EZIOT_READ_CHARACTERISTIC_UUID_STR               @"FED4"
#define EZIOT_WRITE_CHARACTERISTIC_UUID_STR              @"FED5"
#define EZIOT_INDICATE_CHARACTERISTIC_UUID_STR           @"FED6"
#define EZIOT_WRITE_NO_RSP_CHARACTERISTIC_UUID_STR       @"FED7"
#define EZIOT_NOTIFY_CHARACTERISTIC_UUID_STR             @"FED8"
#define EZIOT_WRITE_AUTH_CHARACTERISTIC_UUID_STR         @"FED9"
#define EZIOT_WRITE_NO_RSP_AUTH_CHARACTERISTIC_UUID_STR  @"FEDA"
#define EZIOT_TRANS_PRO_READ_CHARACTERISTIC_UUID_STR     @"FEDB"

#define EZIOT_OTA_TX_CHARACTERISTIC_UUID_STR             @"FDC1"
#define EZIOT_OTA_RX_CHARACTERISTIC_UUID_STR             @"FDC2"
#define EZIOT_FILE_TX_CHARACTERISTIC_UUID_STR            @"FDC3"
#define EZIOT_FILE_RX_CHARACTERISTIC_UUID_STR            @"FDC4"
#define EZIOT_PAIRING_CHECK_CHARACTERISTIC_UUID_STR      @"FDC5"

//CMD Type
#define COMMON_CMDTYPE_RSP                    0x0101

#define BASE_CMDTYPE_PROTOCOL_VERSION         0x0001
#define BASE_CMDTYPE_SET_BIND_STATUS          0x0011
#define BASE_CMDTYPE_CAPABILITY               0x0002
#define BASE_CMDTYPE_DEVINFO                  0x0006
#define BASE_CMDTYPE_TIME_MODIFY              0x0010
#define BASE_CMDTYPE_MCU_DEVINFO              0x0081

#define DAUTH_CMDTYPE_DEVINFO                 0x2001
#define DAUTH_CMDTYPE_FIRSTAUTH               0x2002
#define DAUTH_CMDTYPE_AUTHRESULT              0x2003
#define DAUTH_CMDTYPE_SECOND_AUTH             0x2004
#define DAUTH_CMDTYPE_SECOND_AUTHRESULT       0x2005
#define ECDH_AUTH_CMDTYPE_PUBLICKEY           0x2007
#define ECDH_AUTH_CMDTYPE_SESSIONKEY          0x2008

#define NOTIFY_NET_STATUS_CMDTYPE_RESULT      0x0201
#define WIFICONFIG_CMDTYPE_LIST               0x0202
#define WIFICONFIG_CMDTYPE_RESULT             0x0203
#define QUERY_BIND_STATUS_CMDTYPE_RESULT      0x0205
#define NOTIFY_BIND_STATUS_CMDTYPE_RESULT     0x0206
#define QUERY_NET_STATUS_CMDTYPE_RESULT       0x0207

#define OTA_CMDTYPE_START                     0x0301
#define OTA_CMDTYPE_SEND                      0x0302
#define OTA_CMDTYPE_EXEC                      0x0303
#define OTA_CMDTYPE_RECOVERY                  0x0304
#define OTA_CMDTYPE_INFO                      0x0305
#define OTA_CMDTYPE_PROGRESS_REPORT           0x0306
#define OTA_CMDTYPE_MCU_START                 0x0381
#define OTA_CMDTYPE_MCU_SEND                  0x0382
#define OTA_CMDTYPE_MCU_EXEC                  0x0383

#define FILE_TRANSFER_CMDTYPE_START           0x0320
#define FILE_TRANSFER_CMDTYPE_SEND            0x0321
#define FILE_TRANSFER_CMDTYPE_END             0x0322

#define DEBUG_CMDTYPE_SWITCH                  0x0401
#define DEBUG_CMDTYPE_LOG_FETCH               0x0402

#define DEV_CONTROL_CMDTYPE_PROP_RESERVED     0x8000
#define DEV_CONTROL_CMDTYPE_PROP_REPORT       0x8001
#define DEV_CONTROL_CMDTYPE_PROP_SET          0x8002
#define DEV_CONTROL_CMDTYPE_PROP_GET          0x8003
#define DEV_CONTROL_CMDTYPE_EVENT_REPORT      0x8004
#define DEV_CONTROL_CMDTYPE_ACTION_SET        0x8005
#define DEV_CONTROL_CMDTYPE_BATCH_EVENT_REPORT 0x8006
#define DEV_CONTROL_CMDTYPE_ALL_PROP_GET      0x8007

//timeout
#define CONNECT_REQUEST_TIME_OUT    20
#define AUTH_REQUEST_TIME_OUT       20
#define PROFILE_REQUEST_TIME_OUT    85
#define CONTROL_REQUEST_TIME_OUT    15
#define WIFILIST_REQUEST_TIME_OUT   20
#define OTA_PAGK_TRANS_TIME_OUT     15
#define UPGRADE_EXEC_TIME_OUT       31

//BizType
#define EZBLE_BIZ_CONNECT               @"connect"
#define EZBLE_BIZ_DOUBLEAUTH            @"doubleAuth"
#define EZBLE_BIZ_GET_PROTOCAL          @"getProtocal"
#define EZBLE_BIZ_GET_DEVINFO           @"getDeviceInfo"
#define EZBLE_BIZ_GET_MCUINFO           @"getMcuInfo"
#define EZBLE_BIZ_GET_CAPABILITY        @"getCapability"
#define EZBLE_BIZ_SET_TIME              @"setTime"
#define EZBLE_BIZ_SET_BINDSTATUS        @"setBindStatus"
#define EZBLE_BIZ_GET_PROPFEATURE       @"getPropFeature"
#define EZBLE_BIZ_SET_PROPFEATURE       @"setPropFeature"
#define EZBLE_BIZ_SET_ACTIONFEATURE     @"setActionFeature"
#define EZBLE_BIZ_SEND_FILENOTIFY       @"sendFileNotify"
#define EZBLE_BIZ_SEND_FILEEXEC         @"sendFileExec"
#define EZBLE_BIZ_SEND_FILEPACKAGE      @"sendFilePackage"
#define EZBLE_BIZ_OTA_UPGRADENOTIFY     @"upgradeNotify"
#define EZBLE_BIZ_OTA_UPGRADEEXEC       @"upgradExec"
#define EZBLE_BIZ_OTA_PACKTRANS         @"packTrans"
#define EZBLE_BIZ_LOCALAUTH_PUBLICKEY   @"sendEcdhPublicKey"
#define EZBLE_BIZ_LOCALAUTH_SESSIONKEY  @"sendEcdhSessionKey"
#define EZBLE_BIZ_GET_WIFI_LIST         @"wifiList"
#define EZBLE_BIZ_GET_WIFI_CONFIG       @"wifiConfig"
#define EZBLE_BIZ_QUERY_BIND_STATUS     @"queryBindStatus"
#define EZBLE_BIZ_QUERY_NET_STATUS      @"queryNetStatus"
#define EZBLE_BIZ_SET_DEBUG_LOG         @"setDebugLog"
#define EZBLE_BIZ_FETCH_DEBUG_LOG       @"fetchDevLog"

@class EZIoTPeripheral,EZIoTFeatureLiteConfigParam;

typedef enum : NSUInteger {
    EZIoTFeatureValueTypeBool,
    EZIoTFeatureValueTypeInt,
    EZIoTFeatureValueTypeDouble,
    EZIoTFeatureValueTypeString,
    EZIoTFeatureValueTypeArray,
    EZIoTFeatureValueTypeObject,
    EZIoTFeatureValueTypeNone,
} EZIoTFeatureValueType;

typedef void(^EZIoTBLECenterStateDidChangedBlock)(CBManagerState *state);
typedef void(^EZIoTBLEPeripheralStateDidChangedBlock)(EZIoTPeripheral * peripheral, NSDictionary *_Nullable otherInfo);
typedef void(^EZIoTBLEScanTargetPeripheralBlock)(EZIoTPeripheral * _Nullable peripheral);
typedef void(^EZIoTBLEScanPeripheralsBlock)(EZIoTPeripheral * _Nullable peripheral, NSError * _Nullable error);

typedef void(^EZIoTBLEUniversalSetResultBlock)(EZIoTPeripheral * _Nullable peripheral, BOOL status, NSError * _Nullable error);
typedef void(^EZIoTBLEUniversalArrayResultBlock)(EZIoTPeripheral * _Nullable peripheral, NSArray * _Nullable list, NSError * _Nullable error);

typedef void(^EZIoTBLEDidConnectPeripheralBlock)(EZIoTPeripheral * _Nullable peripheral);
typedef void(^EZIoTBLEDidFailToConnectPeripheralBlock)(EZIoTPeripheral *_Nullable peripheral, NSError * _Nullable error);
typedef void(^EZIoTBLEDidDisconnectPeripheralBlock)(EZIoTPeripheral * _Nullable peripheral, NSError *_Nullable error);
typedef void(^EZIoTBLEDidRecivedAuthStatusBlock)(BOOL status, int failType, NSDictionary *_Nullable statistics, NSError * _Nullable error);

typedef void(^EZIoTBLERecivedDevInfoBlock)(EZIoTPeripheral *_Nullable peripheral, NSError * _Nullable error);
typedef void(^EZIoTBLERecivedProtocolVerBlock)(EZIoTPeripheral *_Nullable peripheral, NSString *_Nullable protocolVersion, NSError * _Nullable error);
typedef void(^EZIoTBLERecivedCapabilityBlock)(EZIoTPeripheral *_Nullable peripheral, NSError * _Nullable error);

typedef void(^EZIoTBleDidRecivedProgressBlock)(double progress);
typedef void(^EZIoTBleDidFinishedDownloadBlock)(NSString *_Nullable filePath, NSError * _Nullable error);
typedef void(^EZIoTBLEDidFinishedOTAUpdateBlock)(BOOL status, NSError * _Nullable error);
typedef void(^EZIoTBLEDidFinishedFileTransferBlock)(BOOL status, NSError * _Nullable error);

typedef void(^EZIoTBLEDidBindDeviceBlock)(NSString *_Nullable resourceId, NSString *_Nullable resourceName, NSError * _Nullable error);

typedef void(^EZIoTBLEWiFiConfigResultBlock)(BOOL result, NSError * _Nullable error);
typedef void(^EZIoTBLEFetchDevlogBlock)(EZIoTPeripheral * _Nullable peripheral, NSString *log, NSError * _Nullable error);

typedef void(^EZIoTBLEDevControlFeatureGetBlock)(EZIoTPeripheral *_Nullable peripheral, NSArray <EZIoTFeatureLiteConfigParam *> *_Nonnull featureInfos, NSError *_Nullable error);
typedef void(^EZIoTBLEDevControlFeatureSetBlock)(EZIoTPeripheral *_Nullable peripheral, EZIoTFeatureLiteConfigParam *_Nullable value, NSError *_Nullable error);
typedef void(^EZIoTBLEDevControlFeatureReportBlock)(EZIoTPeripheral *_Nullable peripheral, NSArray <EZIoTFeatureLiteConfigParam *> *_Nonnull featureInfos, NSUInteger seqNum, NSUInteger cmdType, NSError *_Nullable error);



