//
//  EZIoTBLEUtil.h
//  EZIoTBluetoothSDK
//
//  Created by yuqian on 2021/9/10.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN


@interface EZIoTBLEUtil : NSObject

+ (uint8_t) calculateCrc:(NSData *)data;
+ (NSString *)convertDataToHexStr:(NSData *)data;
+ (NSString *)convertDataToHexStrBigPoint:(NSData *)data;
+ (NSData *)convertHexStrToData:(NSString *)str;
+ (NSData *)dataForHexString:(NSString*)hexString;

+ (NSData *)AES128Encrypt:(NSData *)data key:(NSString *)key ivkey:(NSString *)ivkey;
+ (NSData *)AES128Decrypt:(NSData *)data key:(NSString *)key ivkey:(NSString *)ivkey;
+ (NSData *)AES256Encrypt:(NSData *)data key:(NSString *)key ivkey:(NSString *)ivkey;
+ (NSData *)AES256Decrypt:(NSData *)data key:(NSString *)key ivkey:(NSString *)ivkey;

+ (NSString *)md5EncryptStr:(NSString *)str bateNum:(NSInteger)bateNum isLowercaseStr:(BOOL)isLowercaseStr;
+ (NSString *)md5WithData:(NSData *)data;
+ (NSString *)md5OfFilePath:(NSString *)filePath;

+ (NSString *)createUUid;
+ (NSString *)randomString:(NSInteger)number;

+ (NSString *)sha256StrToString:(NSString *)content;
+ (NSData *)sha256StrToData:(NSString *)content;
+ (NSString *)sha256DataToString:(NSData *)content;
+ (NSData *)sha256DataToData:(NSData *)content;

@end

NS_ASSUME_NONNULL_END
