//
//  EZIoTBluetoothGlobalSetting.h
//  EZIoTBluetoothSDK
//
//  Created by yuqian on 2021/8/20.
//

#import <Foundation/Foundation.h>
#import "EZIoTBLEInitConfigParam.h"

NS_ASSUME_NONNULL_BEGIN

@interface EZIoTBluetoothGlobalSetting : NSObject

+ (BOOL) initSDKWithParam:(EZIoTBLEInitConfigParam *)param;
+ (BOOL) initSDKWithParam:(EZIoTBLEInitConfigParam *)param paramChangeBlock:(EZIoTBLEInitConfigParam *(^)(void))paramChangeBlock;
+ (BOOL) updateSDKWithParam:(EZIoTBLEInitConfigParam *)param;

#pragma mark - Util & Debug
+ (NSString *) getVersion;

/// 设置日志等级及回调： 默认日志等级： DEBUG
/// @param callback 对应日志等级回调
+ (void)setLogCallBack:(void(^)(NSString *log))callback;

/// 设置日志等级及回调
/// @param loglevel   0 DEBUG  1 INFO  2 ERROR
/// @param callback 对应日志等级回调
+ (void)setLogLevel:(NSUInteger)loglevel callBack:(void(^)(NSString *log))callback;

@end

NS_ASSUME_NONNULL_END
