//
//  EZAddByQRCodeViewController.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/28.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "EZAddByQRCodeViewController.h"
#import "SystemFunctions.h"
#import "HMScannerBorder.h"
#import "HMScannerMaskView.h"
#import "HMScanner.h"

#import "EZInputSerialViewController.h"
#import "EZDeviceResultViewController.h"

@interface EZAddByQRCodeViewController () {
    /// 扫描框
    HMScannerBorder *scannerBorder;
    /// 扫描器
    HMScanner *scanner;
}

@end

@implementation EZAddByQRCodeViewController

#pragma mark - Life Cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor darkGrayColor];
    self.title = NSLocalizedString(@"ad_scan_qr_title", @"扫描二维码");
    self.navigationItem.rightBarButtonItem = [[UIBarButtonItem alloc] initWithTitle:NSLocalizedString(@"ad_input_manual", @"手动输入") style:UIBarButtonItemStylePlain target:self action:@selector(inputEditAction)];

    [self prepareScanerBorder];
    [self prepareOtherControls];
    // 实例化扫描器
    EZWeak(self);
    scanner = [HMScanner scanerWithView:self.view scanFrame:scannerBorder.frame completion:^(NSString *stringValue) {
        EZStrong(self);
        [strongself checkQRCode:stringValue];
    }];
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [scannerBorder startScannerAnimating];
    [scanner startScan];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [scannerBorder stopScannerAnimating];
    [scanner stopScan];
}

#pragma mark - Actions

- (void)touchLampAction:(id)sender {
    UIButton *btn = (UIButton *)sender;
    if (btn.selected == YES) {
        [btn setImage:[UIImage imageNamed:@"HMScanner.bundle/turn_off"] forState:UIControlStateNormal];
        btn.backgroundColor = [UIColor whiteColor];
    } else {
        [btn setImage:[UIImage imageNamed:@"HMScanner.bundle/turn_on"] forState:UIControlStateNormal];
        btn.backgroundColor = [UIColor clearColor];
    }
    btn.selected = !btn.selected;
    [SystemFunctions openLight:btn.selected];
}

- (void)inputEditAction {
    EZInputSerialViewController *inputSerialVC = [[EZInputSerialViewController alloc] init];
    [self.navigationController pushViewController:inputSerialVC animated:YES];
}

#pragma mark - 设置界面

/// 准备扫描框
- (void)prepareScanerBorder {
    CGFloat width = self.view.bounds.size.width - 120;
    scannerBorder = [[HMScannerBorder alloc] initWithFrame:CGRectMake(0, 0, width, width)];
    scannerBorder.center = CGPointMake(self.view.center.x, self.view.center.y-kStatusBarHeight-kNavigationBarHeight);
    scannerBorder.tintColor = [UIColor greenColor];
    [self.view addSubview:scannerBorder];
    
    HMScannerMaskView *maskView = [HMScannerMaskView maskViewWithFrame:self.view.bounds cropRect:scannerBorder.frame];
    [self.view insertSubview:maskView atIndex:0];
}

/// 准备提示标签
- (void)prepareOtherControls {
    // 1> tip
    UILabel *tipLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, scannerBorder.bottom + 20, kScreenWidth, 20)];
    tipLabel.text = NSLocalizedString(@"ad_scan_qr_hint", @"将二维码放入框中，即可自动扫描");
    tipLabel.font = [UIFont systemFontOfSize:14];
    tipLabel.textColor = [UIColor whiteColor];
    tipLabel.numberOfLines = 0;
    tipLabel.textAlignment = NSTextAlignmentCenter;
    [self.view addSubview:tipLabel];
    
    // 2> 照明灯
    CGFloat lampWidth = AdaptedWidth(50);
    UIButton *lamp = [[UIButton alloc] initWithFrame:CGRectMake((kScreenWidth-lampWidth)*0.5, tipLabel.bottom+40, lampWidth, lampWidth)];
    lamp.alpha = 0.6;
    lamp.selected = NO;
    [lamp.layer setMasksToBounds:YES];
    [lamp.layer setCornerRadius:lampWidth/2];
    [lamp.layer setBorderWidth:2.0];
    [lamp.layer setBorderColor:[[UIColor whiteColor] CGColor]];
    lamp.backgroundColor = [UIColor whiteColor];
    [lamp setImage:[UIImage imageNamed:@"HMScanner.bundle/turn_off"] forState:UIControlStateNormal];
    [lamp addTarget:self action:@selector(touchLampAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:lamp];
}

#pragma mark - Custom Methods

- (void)checkQRCode:(NSString *)strQRcode {
    NSLog(@"strQRcode--->%@", strQRcode);
    // 个别类型设备使用\r\n进行换行，需要统一替换成\r
    strQRcode = [strQRcode stringByReplacingOccurrencesOfString:@"\r\n" withString:@"\r"];
    NSArray *arrString = [strQRcode componentsSeparatedByCharactersInSet:[NSCharacterSet newlineCharacterSet]];
    
    if (arrString.count >= 3) {
        [GlobalKit shareKit].deviceSerialNo = arrString[1];
        [GlobalKit shareKit].deviceVerifyCode = arrString[2];
        [GlobalKit shareKit].deviceModel = arrString[3];
        EZDeviceResultViewController *resultVC = [[EZDeviceResultViewController alloc] init];
        [self.navigationController pushViewController:resultVC animated:YES];
    } else {
        [UIView dd_showMessage:NSLocalizedString(@"ad_not_support_scan", @"不支持的二维码类型，转用手动输入")];
        [self inputEditAction];
    }
}

@end
