//
//  EZInputSerialViewController.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/28.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "EZInputSerialViewController.h"

@interface EZInputSerialViewController ()<UITextFieldDelegate>

@property (nonatomic, weak) IBOutlet UIButton *nextButton;
@property (nonatomic, weak) IBOutlet UITextField *serialTextField;
@property (weak, nonatomic) IBOutlet UITextField *verifyCodeTextField;
@property (weak, nonatomic) IBOutlet UIButton *touchAPButton;
@property (weak, nonatomic) IBOutlet UIButton *bluetoothConfigButton;

@end

@implementation EZInputSerialViewController

- (instancetype)init {
    if (self = [super init]) {
        self = [EZStoryBoardTool getViewController:@"AddDevice" andIdentifier:@"EZInputSerialViewController"];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = NSLocalizedString(@"ad_input_manual", @"手动输入");
    
    self.serialTextField.leftView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 10, 30)];
    self.serialTextField.leftViewMode = UITextFieldViewModeAlways;
    [self.serialTextField dd_addSeparatorWithType:ViewSeparatorTypeVerticalSide];

    self.verifyCodeTextField.leftView = [[UIView alloc] initWithFrame:CGRectMake(0, 0, 10, 30)];
    self.verifyCodeTextField.leftViewMode = UITextFieldViewModeAlways;
    [self.verifyCodeTextField dd_addSeparatorWithType:ViewSeparatorTypeVerticalSide];
    
#ifdef JCTest
    self.serialTextField.text = @"C4219413";
    self.verifyCodeTextField.text = @"GIAIFP";
    
    self.nextButton.enabled = YES;
#endif
    
#ifdef EZVIZ_OPEN_DEMO
    self.touchAPButton.hidden = NO;
    self.bluetoothConfigButton.hidden = NO;
#endif
}

- (void)viewDidDisappear:(BOOL)animated {
    [self.serialTextField resignFirstResponder];
    [self.verifyCodeTextField resignFirstResponder];
}

#pragma mark - UITextFieldDelegate Methods

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    BOOL nextButtonEnable = self.serialTextField.text.length == 9 && self.verifyCodeTextField.text.length > 4;
    if (self.serialTextField == textField) {
        self.nextButton.enabled = nextButtonEnable;
        
        NSString *strTemp = [NSString stringWithFormat:@"%@%@", textField.text, string];
        if ([strTemp length] > 9) {
            return NO;
        }
    } else if (self.verifyCodeTextField == textField) {
        self.nextButton.enabled = nextButtonEnable;
        
        NSString *strTemp = [NSString stringWithFormat:@"%@%@", textField.text, string];
        if ([strTemp length] > 6) {
            return NO;
        }
    }
    
    return YES;
}

#pragma mark - Custom Methods

- (IBAction)go2Result:(id)sender {
    [GlobalKit shareKit].deviceSerialNo = self.serialTextField.text;
    [GlobalKit shareKit].deviceVerifyCode = self.verifyCodeTextField.text;
    [GlobalKit shareKit].deviceModel = @"";
    
    [self performSegueWithIdentifier:@"go2InputResult" sender:nil];
}

@end
