//
//  EZWifiInfoViewController.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/29.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "EZWifiInfoViewController.h"
#import "EZCommonTool.h"
#import "EZWifiConfigViewController.h"
#import "EZAPWiFiConfigViewController.h"

@interface EZWifiInfoViewController () {
    EZAPConfigType apConfigType;
}

@property (nonatomic, weak) IBOutlet UIButton *nextButton;
@property (nonatomic, weak) IBOutlet UILabel *tipsLabel;
@property (nonatomic, weak) IBOutlet UITextField *nameTextField;
@property (nonatomic, weak) IBOutlet UITextField *passwordTextField;
@property (nonatomic, weak) IBOutlet UILabel *nameLabel;
@property (nonatomic, weak) IBOutlet UILabel *passwordLabel;

@end

@implementation EZWifiInfoViewController

#pragma mark - Life Cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = NSLocalizedString(@"wifi_connect_wifi_title", @"第二步，连接WiFi");
    // 从后台进入前台时不会执行viewDidAppear，需要监听
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(refreshWifiInfo) name:UIApplicationDidBecomeActiveNotification object:nil];
    
    self.nameTextField.leftView = self.nameLabel;
    self.nameTextField.leftViewMode = UITextFieldViewModeAlways;
    self.passwordTextField.leftView = self.passwordLabel;
    self.passwordTextField.leftViewMode = UITextFieldViewModeAlways;
    [self.nameTextField dd_addCornerRadius:4.0f lineColor:[UIColor lightGrayColor]];
    [self.passwordTextField dd_addCornerRadius:4.0f lineColor:[UIColor lightGrayColor]];
    [self.nextButton dd_addCornerRadius:19.0 lineColor:[UIColor dd_hexStringToColor:@"0x1b9ee2"]];
    self.tipsLabel.hidden = self.supportWiFi5G;
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self refreshWifiInfo];
}

#pragma mark - Actions

/** 下一步Action */
- (IBAction)nextAction:(id)sender {
    if (!self.supportWiFi5G && [self.nameTextField.text containsString:@"5G"]) {
        [self showAlertWithTitle:@"该设备不支持5G频段WiFi配网，请不要连接5G频段的Wi-Fi"];
        return;
    }
    [self showModeSelect];
}

/** 显示支持的配网模式 */
- (void)showModeSelect {
    UIAlertController *alertController =
    [UIAlertController alertControllerWithTitle:nil
                                        message:NSLocalizedString(@"wifi_mode_select_msg", @"请选择配网模式")
                                 preferredStyle:UIAlertControllerStyleActionSheet];
    
    UIAlertAction *normalAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"wifi_mode_normal",@"一般配网")
                                                           style:UIAlertActionStyleDefault
                                                         handler:^(UIAlertAction * _Nonnull action) {
                                                             [self performSegueWithIdentifier:@"go2WifiConfig" sender:nil];
                                                         }];
    
    UIAlertAction *soundAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"wifi_mode_sound",@"声波配网")
                                                          style:UIAlertActionStyleDefault
                                                        handler:^(UIAlertAction * _Nonnull action) {
                                                             [self performSegueWithIdentifier:@"go2WifiConfig" sender:nil];
                                                        }];
    
    UIAlertAction *apNetSDKAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"wifi_mode_ap",@"热点配网")
                                                       style:UIAlertActionStyleDefault
                                                     handler:^(UIAlertAction * _Nonnull action) {
                                                            apConfigType = EZAPConfigTypeNetSDK;
                                                            [self performSegueWithIdentifier:@"go2APorLinkWifiConfig" sender:nil];
                                                     }];
    
    UIAlertAction *apHttpAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"wifi_mode_ap_http",@"热点http配网")
                                                       style:UIAlertActionStyleDefault
                                                     handler:^(UIAlertAction * _Nonnull action) {
                                                            apConfigType = EZAPConfigTypeHttp;
                                                            [self performSegueWithIdentifier:@"go2APorLinkWifiConfig" sender:nil];
                                                     }];
    
    UIAlertAction *lineAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"wifi_mode_line",@"有线连接")
                                                         style:UIAlertActionStyleDefault
                                                       handler:^(UIAlertAction * _Nonnull action) {
                                                           [self.navigationController dismissViewControllerAnimated:YES completion:nil];
                                                     }];
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"cancel",@"取消")
                                                           style:UIAlertActionStyleCancel
                                                         handler:^(UIAlertAction * _Nonnull action) {
                                                         }];
    
    if (self.supportSmartMode) {
        [alertController addAction:normalAction];
    }
    if (self.supportSoundMode) {
        [alertController addAction:soundAction];
    }
    if (self.supportApMode) {
        [alertController addAction:apNetSDKAction];
    }
    if (self.supportApHttpMode) {
        [alertController addAction:apHttpAction];
    }
    [alertController addAction:lineAction];
    [alertController addAction:cancelAction];
    
    [self presentViewController:alertController animated:YES completion:nil];
}

#pragma mark - Custom Methods

/** 刷新WiFi信息 */
- (void)refreshWifiInfo {
    self.nameTextField.text = [EZCommonTool getWiFiName];
    if (kStringIsEmpty(self.nameTextField.text)) {
        self.nextButton.enabled = NO;
        [self showJumpSettingTip];
    } else {
        self.nextButton.enabled = YES;
    }
    
#ifdef JCTest
    if ([self.nameTextField.text containsString:@"ezviz"]) {
        self.nameTextField.text = @"ezviz_mobile_AV";
        self.passwordTextField.text = @"chengjun7";
    }
#endif
}

- (void)showJumpSettingTip {
    UIAlertController *alertController =
        [UIAlertController alertControllerWithTitle:NSLocalizedString(@"alert_title",@"提示")
                                            message:NSLocalizedString(@"wifi_info_no_wifi_msg", @"未连接Wi-Fi,请设置合适的Wi-Fi")
                                     preferredStyle:UIAlertControllerStyleAlert];
    
    UIAlertAction *cancelAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"cancel",@"取消")
                                                           style:UIAlertActionStyleCancel
                                                         handler:nil];
    UIAlertAction *okAction = [UIAlertAction actionWithTitle:NSLocalizedString(@"wifi_info_setting",@"设置")
                                                       style:UIAlertActionStyleDefault
                                                     handler:^(UIAlertAction * _Nonnull action) {
                                                        [EZCommonTool toSystemWiFiSettingPage];
                                                     }];
    [alertController addAction:cancelAction];
    [alertController addAction:okAction];
    
    [self presentViewController:alertController animated:YES completion:nil];
}

#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
    if ([[segue destinationViewController] isKindOfClass:[EZWifiConfigViewController class]]) {
        EZWifiConfigViewController *vc = (EZWifiConfigViewController *)[segue destinationViewController];
        vc.ssid = self.nameTextField.text;
        vc.password = self.passwordTextField.text;
        vc.supportSmartMode = self.supportSmartMode;
        vc.supportSoundMode = self.supportSoundMode;
    } else if ([[segue destinationViewController] isKindOfClass:[EZAPWiFiConfigViewController class]]) {
        EZAPWiFiConfigViewController *vc = (EZAPWiFiConfigViewController *)[segue destinationViewController];
        vc.ssid = self.nameTextField.text;
        vc.password = self.passwordTextField.text;
        vc.apConfigType = apConfigType;
    }
}

@end
