//
//  EZCameraTableViewController.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 16/9/20.
//  Copyright © 2016年 Ezviz. All rights reserved.
//

#import "EZCameraTableViewController.h"

#import "EZCameraInfo.h"

#import "EZRealPlayViewController.h"
#import "EZPlaybackViewController.h"

@interface EZCameraTableViewController ()

@property (nonatomic, strong) NSMutableArray *cameraList;

@end

@implementation EZCameraTableViewController

- (instancetype)init {
    if (self = [super init]) {
        self = [EZStoryBoardTool getViewController:@"EZMain" andIdentifier:@"EZCameraTableViewController"];
    }
    return self;
}

#pragma mark - Life Cycle

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = NSLocalizedString(@"device_camera_list_title", @"设备通道列表");
}

#pragma mark - UITableViewDataSource & UITableViewDelegate

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [self.cameraList count];
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"EZCameraCell" forIndexPath:indexPath];
    
    EZCameraInfo *info = [self.cameraList dd_objectAtIndex:indexPath.row];
    
    cell.textLabel.text = [NSString stringWithFormat:@"%@_%d", info.deviceSerial, (int)info.cameraNo];
    cell.textLabel.lineBreakMode = NSLineBreakByTruncatingHead;
    
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    NSInteger cameraIndex = indexPath.row;
    if (![self.cameraList[cameraIndex] isCamera]) {// 不是视频类设备
        [EZToast show:NSLocalizedString(@"device_isnot_camera_device", @"该设备不是视频类设备")];
        return;
    }
    if (self.playType == EZPlayTypePlayBack) {
        EZPlaybackViewController *playbackVC = [[EZPlaybackViewController alloc] init];
        playbackVC.deviceInfo = self.deviceInfo;
        playbackVC.cameraIndex = cameraIndex;
        [self.navigationController pushViewController:playbackVC animated:YES];
    } else {
        EZRealPlayViewController *livePlayVC = [[EZRealPlayViewController alloc] init];
        livePlayVC.deviceInfo = self.deviceInfo;
        livePlayVC.cameraIndex = cameraIndex;
        [self.navigationController pushViewController:livePlayVC animated:YES];
    }
}

#pragma mark - setter & getter

- (NSMutableArray *)cameraList {
    if (!_cameraList) {
        if (!kArrayIsEmpty(self.deviceInfo.cameraInfo)) {
            _cameraList = [NSMutableArray arrayWithArray:self.deviceInfo.cameraInfo];
        } else {
            _cameraList = [NSMutableArray arrayWithArray:self.deviceInfo.subDeviceInfo];
        }
    }
    return _cameraList;
}

@end
