//
//  EZHubDebugViewController.m
//  EZOpenSDKDemo
//
//  Created by yuqian on 2020/5/18.
//  Copyright © 2020 hikvision. All rights reserved.
//

#import "EZHubDebugViewController.h"
#import "EZPlaybackViewController.h"
#import "EZRealPlayViewController.h"

@interface EZHubDebugViewController ()
@property (weak, nonatomic) IBOutlet UITextField *deviceSerial;
@property (weak, nonatomic) IBOutlet UITextField *channelNo;
@property (weak, nonatomic) IBOutlet UIButton *nextBtn;

@end

@implementation EZHubDebugViewController

- (instancetype)init {
    if (self = [super init]) {
        self = [EZStoryBoardTool getViewController:@"EZMain" andIdentifier:@"EZHubDebugViewController"];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
//    self.deviceSerial.text = [NSString stringWithFormat:@"%@-test123123", _deviceInfo.deviceSerial];
    self.deviceSerial.text = [NSString stringWithFormat:@"ZPFTESTCAS1:test011-test123123"];
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    switch (_playType) {
        case EZPlayTypeLive:
            [self.nextBtn setTitle:@"跳转进行预览" forState:UIControlStateNormal];
            break;
        case EZPlayTypePlayBack:
            [self.nextBtn setTitle:@"跳转进行回放" forState:UIControlStateNormal];
            break;
        default:
            break;
    }
}

- (IBAction)clickNextBtn:(id)sender {
    
    switch (_playType) {
        case EZPlayTypeLive:
        {
            EZRealPlayViewController *vc = [[EZRealPlayViewController alloc] init];
            vc.deviceInfo = _deviceInfo;
            vc.hubCoDevSerial = self.deviceSerial.text;
            vc.cameraIndex = [self.channelNo.text intValue];
            [self.navigationController pushViewController:vc animated:YES];
        }
            break;
        case EZPlayTypePlayBack:
        {
            EZPlaybackViewController *vc = [[EZPlaybackViewController alloc] init];
            vc.deviceInfo = _deviceInfo;
            vc.hubCoDevSerial = self.deviceSerial.text;
            vc.cameraIndex = [self.channelNo.text intValue];
            [self.navigationController pushViewController:vc animated:YES];
        }
            break;
        default:
            break;
    }
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [[UIApplication sharedApplication] sendAction:@selector(resignFirstResponder) to:nil from:nil forEvent:nil];
}

@end
