//
//  CameraListCell.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/10/27.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "DeviceListCell.h"
#import "UIImageView+WebCache.h"
#import "EZDeviceInfo.h"
#import "EZCameraInfo.h"

@implementation DeviceListCell

- (void)setDeviceInfo:(EZDeviceInfo *)deviceInfo {
    _deviceInfo = deviceInfo;
    self.offlineIcon.hidden = _deviceInfo.status == 1;
    self.nameLabel.text = [NSString stringWithFormat:@"%@", kStringIsEmpty(deviceInfo.deviceName) ? [NSString stringWithFormat:@"%@(%@)", deviceInfo.category, deviceInfo.deviceSerial] : deviceInfo.deviceName];
    /**
                此处显示设备的图片，如果要显示设备的实时画面封面图，调用[EZOPENSDK中 captureCamera:_cameraInfo.deviceSerial cameraNo:_cameraInfo.cameraNo completion:^(NSString *url, NSError *error) {
     NSLog(@"[%@] capture cameraNo is [%d] url is %@, error is %@", _cameraInfo.deviceSerial, (int)_cameraInfo.cameraNo, url, error);
 }];
     */
    [self.cameraImageView sd_setImageWithURL:[NSURL URLWithString:deviceInfo.deviceCover] placeholderImageScale:GetImage(@"device_other")];
    self.playButton.userInteractionEnabled = _deviceInfo.status == 1;// 不在线不可点击
    
    // 如果是分享设备，隐藏消息列表按钮和设置按钮
    EZCameraInfo *camera;
    if ([deviceInfo.cameraInfo count] > 0) {
        camera = deviceInfo.cameraInfo[0];
    } else if ([deviceInfo.subDeviceInfo count] > 0) {
        camera = deviceInfo.subDeviceInfo[0];
    }
    BOOL isDisplay = camera && (camera.isShared == 1 || camera.isShared == 0);
    self.messageButton.hidden = !isDisplay;
    self.settingButton.hidden = !isDisplay;
    self.videoTalkButton.hidden = !(deviceInfo.isSupportVideoMeeting && deviceInfo.status == 1);
    
    [self.contentView dd_addSeparatorWithType:ViewSeparatorTypeBottom];
}

- (IBAction)go2Play:(id)sender {
    [self.parentViewController performSelector:@selector(go2Play:) withObject:_deviceInfo];
}

- (IBAction)go2Record:(id)sender {
    [self.parentViewController performSelector:@selector(go2Record:) withObject:_deviceInfo];
}

- (IBAction)go2Setting:(id)sender {
    [self.parentViewController performSelector:@selector(go2Setting:) withObject:_deviceInfo];
}

- (IBAction)go2Message:(id)sender {
    [self.parentViewController performSelector:@selector(go2Message:) withObject:_deviceInfo];
}

- (IBAction)go2VideoTalk:(id)sender {
    [self.parentViewController performSelector:@selector(go2VideoTalk:) withObject:_deviceInfo];
}

@end
