//
//  ServerAreasEnum.m
//  EZOpenSDKDemo
//  开放平台服务端在分为海外和国内，海外又分为5个大区
//  （北美、南美、新加坡（亚洲）、俄罗斯、欧洲）
//  必须根据当前使用的AppKey对应大区切换到所在大区的服务器
//  否则EZOpenSDK的接口调用将会出现异常
//
//  Created by JuneCheng on 2023/12/4.
//  Copyright © 2023 hikvision. All rights reserved.
//

#import "ServerAreasEnum.h"

@implementation ServerAreasEnum

- (NSArray<ServerAreasEnum *> *)allServers {
    if (!_allServers) {
        _allServers = @[
            // 国内
            [ServerAreasEnum initWithId:0 areaName:@"Asia-China(国内)" apiUrl:@"https://open.ys7.com" authUrl:@"https://openauth.ys7.com" defaultOpenAuthAppKey:@"26810f3acd794862b608b6cfbc32a6b8"],
            // 海外：俄罗斯
            [ServerAreasEnum initWithId:5 areaName:@"Asia-Russia(海外：俄罗斯)" apiUrl:@"https://irusopen.ezvizru.com" authUrl:@"https://irusopenauth.ezvizru.com"],
            // 海外：亚洲（服务亚洲的所有国家，但不包括中国和俄罗斯）
            [ServerAreasEnum initWithId:10 areaName:@"Asia(海外：亚洲，不包括中国和俄罗斯)" apiUrl:@"https://isgpopen.ezvizlife.com" authUrl:@"https://isgpopenauth.ezvizlife.com"],
            // 海外：北美洲
            [ServerAreasEnum initWithId:15 areaName:@"North America(海外：北美洲)" apiUrl:@"https://iusopen.ezvizlife.com" authUrl:@"https://iusopenauth.ezvizlife.com"],
            // 海外：南美洲
            [ServerAreasEnum initWithId:20 areaName:@"South America(海外：南美洲)" apiUrl:@"https://isaopen.ezvizlife.com" authUrl:@"https://isaopenauth.ezvizlife.com"],
            // 海外：欧洲
            [ServerAreasEnum initWithId:25 areaName:@"Europe(海外：欧洲)" apiUrl:@"https://ieuopen.ezvizlife.com" authUrl:@"https://ieuopenauth.ezvizlife.com" defaultOpenAuthAppKey:@"5cadedf5478d11e7ae26fa163e8bac01"],
            // 自定义域名
            [ServerAreasEnum initWithId:26 areaName:@"Other(自定义区域)" apiUrl:@"" authUrl:@""],
            // 测试平台:test12
            [ServerAreasEnum initWithId:110 areaName:@"test12" apiUrl:@"https://test12open.ezv-test.com" authUrl:@"https://test12openauth.ezv-test.com" defaultOpenAuthAppKey:@"b22035492c7949bca95286382ed90b01"],
            // 测试平台:test13
            [ServerAreasEnum initWithId:111 areaName:@"test13" apiUrl:@"https://test13open.ezv-test.com" authUrl:@"https://test13openauth.ezv-test.com" defaultOpenAuthAppKey:@"b22035492c7949bca95286382ed90b01"],
            // 测试平台:testcn
            [ServerAreasEnum initWithId:115 areaName:@"testcn" apiUrl:@"https://testcnopen.ezv-test.com" authUrl:@"https://testcnopenauth.ezv-test.com"],
            // 测试平台:testus
            [ServerAreasEnum initWithId:120 areaName:@"testus" apiUrl:@"https://testusopen.ezv-test.com" authUrl:@"https://testusopenauth.ezv-test.com"],
            // 温氏
            [ServerAreasEnum initWithId:126 areaName:@"WenShi" apiUrl:@"https://ezcpcloudopen.wens.com.cn" authUrl:@"https://ezcpcloudopenauth.wens.com.cn"],
            // 华住
            [ServerAreasEnum initWithId:127 areaName:@"HuaZhu" apiUrl:@"https://ezcpatctestopen.ys7.com" authUrl:@"https://ezcpatctestopenauth.ys7.com"]
        ];
    }
    return _allServers;
}

+ (instancetype)sharedInstance {
    static ServerAreasEnum *_sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _sharedInstance = [[ServerAreasEnum alloc] init];
        
    });
    return _sharedInstance;
}

+ (instancetype)initWithId:(NSInteger)ID areaName:(NSString *)areaName apiUrl:(NSString *)apiUrl authUrl:(NSString *)authUrl {
    ServerAreasEnum *serverArea = [[ServerAreasEnum alloc] init];
    serverArea.ID = ID;
    serverArea.areaName = areaName;
    serverArea.apiUrl = apiUrl;
    serverArea.authUrl = authUrl;
    
    return serverArea;
}

+ (instancetype)initWithId:(NSInteger)ID areaName:(NSString *)areaName apiUrl:(NSString *)apiUrl authUrl:(NSString *)authUrl defaultOpenAuthAppKey:(NSString *)defaultOpenAuthAppKey {
    ServerAreasEnum *serverArea = [[ServerAreasEnum alloc] init];
    serverArea.ID = ID;
    serverArea.areaName = areaName;
    serverArea.apiUrl = apiUrl;
    serverArea.authUrl = authUrl;
    serverArea.defaultOpenAuthAppKey = defaultOpenAuthAppKey;
    
    return serverArea;
}

@end
