//
//  EZMessagePhotoViewController.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/11/16.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "EZMessagePhotoViewController.h"
#import "EZMessagePlaybackViewController.h"

@interface EZMessagePhotoViewController ()<MWPhotoBrowserDelegate>

@property (nonatomic, weak) IBOutlet UIView *messageDetailInfoView;
@property (nonatomic, weak) IBOutlet UILabel *titleLabel;
@property (nonatomic, weak) IBOutlet UILabel *timeLabel;
@property (nonatomic, weak) IBOutlet UILabel *contentLabel;
@property (nonatomic, weak) IBOutlet UIButton *recordButton;

@end

@implementation EZMessagePhotoViewController

- (void)viewDidLoad {
    
    self.delegate = self;
    self.displayActionButton = NO;
    self.displaySelectionButtons = NO;
    
    [super viewDidLoad];
    
    [self.view bringSubviewToFront:self.messageDetailInfoView];
    
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.locale = [[NSLocale alloc] initWithLocaleIdentifier:@"zh_CN"];
    formatter.dateFormat = @"yyyy/MM/dd HH:mm:ss";
    self.timeLabel.text = [formatter stringFromDate:self.info.alarmStartTime];
    self.contentLabel.text = [NSString stringWithFormat:@"%@:%@",NSLocalizedString(@"message_from", @"来自"),self.info.alarmName];
}

- (IBAction)go2Next:(id)sender {
    [self performSegueWithIdentifier:@"go2MessagePlayback" sender:self.info];
}

#pragma mark - MWPhotoBrowserDelegate Methods

- (NSUInteger)numberOfPhotosInPhotoBrowser:(MWPhotoBrowser *)photoBrowser {
    return 1;
}

- (id <MWPhoto>)photoBrowser:(MWPhotoBrowser *)photoBrowser photoAtIndex:(NSUInteger)index {
    MWPhoto *photo = [[MWPhoto alloc] initWithImage:_image];
    return photo;
}

- (void)updateNavigation {
    self.title = NSLocalizedString(@"message_detail", @"消息详情");
}

#pragma mark - Navigation

- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    EZAlarmInfo *info = sender;
    
    EZMessagePlaybackViewController *messagePlaybackVC = [segue destinationViewController];
    messagePlaybackVC.info = info;
    messagePlaybackVC.deviceInfo = self.deviceInfo;
    
}

@end
