//
//  EZBandWidthCheckVC.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/6/4.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import "EZBandWidthCheckVC.h"
#import "EZConstants.h"
#import "EZBWCheckResult.h"

static int const checkTime = 15;// 检测15秒

@interface EZBandWidthCheckVC () {
    NSArray *array;
    
    NSString *bwCheckToken;
}

@end

@implementation EZBandWidthCheckVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"带宽检测";
    
    array = @[@[@"开始客户端上行检测", @""],
              @[@"开始客户端上行&下行检测", @""],
              @[@"停止带宽检测", @""],
              @[@"带宽检测token设置", @""],
              ];
    [self setupDataArr:array];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    if (indexPath.row == 0) {// 开始客户端上行检测
        if ([self isBWCheckTokenEmpty]) {
            return;
        }
        [EZOpenSDK startBWCheck:EZBWCheckClientUpward deviceSerial:self.deviceSerial cameraNo:1 checkTime:checkTime bwCheckToken:bwCheckToken completion:^(EZBWCheckResult * _Nonnull result, NSError * _Nullable error) {
            if (error) {
                [EZToast show:[NSString stringWithFormat:@"error code: %d, userInfo: %@", (int)error.code, error.userInfo]];
                return;
            }
            NSString *resString = [result.mj_keyValues mj_JSONString];
            [self showResponseAlertWithTitle:@"客户端上行检测结果" resString:resString];
        }];
    } else if (indexPath.row == 1) {// 开始客户端上行&下行检测
        if ([self isBWCheckTokenEmpty]) {
            return;
        }
        [EZOpenSDK startBWCheck:EZBWCheckClientUpward | EZBWCheckClientDownward deviceSerial:self.deviceSerial cameraNo:1 checkTime:checkTime bwCheckToken:bwCheckToken completion:^(EZBWCheckResult * _Nonnull result, NSError * _Nullable error) {
            if (error) {
                [EZToast show:[NSString stringWithFormat:@"error code: %d, userInfo: %@", (int)error.code, error.userInfo]];
                return;
            }
            NSString *resString = [result.mj_keyValues mj_JSONString];
            [self showResponseAlertWithTitle:@"客户端上行&下行检测结果" resString:resString];
        }];
    } else if (indexPath.row == 2) {// 停止带宽检测
        [EZOpenSDK stopBWCheck];
    } else if (indexPath.row == 3) {// 带宽检测token设置
        [self showAlertWithTitle:@"带宽检测token设置" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入带宽检测token";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                // 测试用，正式上线时删掉
//                textField.text = @"";
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                UITextField *textField = alertSelf.textFields.firstObject;
                bwCheckToken = textField.text;
            }
        }];
    }
}

#pragma mark - 自定义方法

/** 检测 */
- (BOOL)isBWCheckTokenEmpty {
    if (kStringIsEmpty(bwCheckToken)) {
        [EZToast show:@"请输入带宽检测token"];
        return YES;
    }
    return NO;
}

/** 弹框显示数据 */
- (void)showResponseAlertWithTitle:(NSString *)title resString:(NSString *)resString {
    [self showAlertWithTitle:title message:resString appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
        alertMaker.addActionCancelTitle(@"取消");
        alertMaker.addActionDefaultTitle(@"复制");
    } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
        if (buttonIndex == 1) {
            UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
            pasteboard.string = resString;
            [EZToast show:@"已复制到剪贴板"];
        }
    }];
}

@end
