//
//  EZStreamTypeSettingVC.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/3/26.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import "EZStreamTypeSettingVC.h"

@interface EZStreamTypeSettingVC () {
    NSArray *array;
}

@end

@implementation EZStreamTypeSettingVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"取流方式设置";
    
    array = @[@[@"内网直连", [GlobalKit shareKit].enableDirectInner ? @"YES" : @"NO"],
              @[@"P2P", [GlobalKit shareKit].enableP2P ? @"YES" : @"NO"],
              @[@"流媒体", [GlobalKit shareKit].enableVTDU ? @"YES" : @"NO"],
              ];
    [self setupDataArr:array];
}

#pragma mark - UITableViewDataSource

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    static NSString *cellIdentifier = @"previewCellIdentifier";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellIdentifier];
    if (cell == nil) {
        UITableViewCellStyle style = UITableViewCellStyleSubtitle;
        cell = [[UITableViewCell alloc] initWithStyle:style reuseIdentifier:cellIdentifier];

    }
    cell.selectionStyle = UITableViewCellSelectionStyleNone;
    NSString *labelText;
    if (indexPath.row < 9) {
        labelText = [NSString stringWithFormat:@"0%zd - %@", indexPath.row + 1, self.titles[indexPath.row]];
    } else {
        labelText = [NSString stringWithFormat:@"%zd - %@", indexPath.row + 1, self.titles[indexPath.row]];
    }
    cell.textLabel.text = labelText;
    
    // 加上开关状态
    UISwitch *s = [[UISwitch alloc] init];
    s.tag = indexPath.row;
    s.on = [self.classNames[indexPath.row] boolValue];
    [cell.contentView addSubview:s];
    
    [s mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(cell.contentView);
        make.right.equalTo(cell.contentView.mas_right).offset(-20);
    }];
#ifdef EZVIZ_OPEN_DEMO
    [s addTarget:self action:@selector(switchAction:) forControlEvents:UIControlEventValueChanged];
#else
    // 海外不支持设置内网直连 和 流媒体
    if (indexPath.row == 0 || indexPath.row == 2) {
        s.userInteractionEnabled = NO;
    }
        
#endif
    
    return cell;
}

/** 开关点击事件 */
- (void)switchAction:(UISwitch *)s {
    NSInteger index = s.tag;
    BOOL on = [self.classNames[index] boolValue];
    if (index == 0) {
        [EZOpenSDK enableDirectInner:!on];
        [GlobalKit shareKit].enableDirectInner = !on;
    } else if (index == 1) {
        [EZOpenSDK enableP2P:!on];
        [GlobalKit shareKit].enableP2P = !on;
    } else if (index == 2) {
        [EZOpenSDK enableVTDU:!on];
        [GlobalKit shareKit].enableVTDU = !on;
    }
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    // 空实现
}

@end
