//
//  EZTKTokenTestVC.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2024/7/3.
//  Copyright © 2024 hikvision. All rights reserved.
//

#import "EZTKTokenTestVC.h"

@interface EZTKTokenTestVC () {
    NSArray *array;
}

@end

@implementation EZTKTokenTestVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"小权限tkToken测试";
    
    array = @[@[@"设备级tkToken设置", @""],
              @[@"设备通道级tkToken设置", @""],
              @[@"预览tkToken设置", @""],
              @[@"对讲tkToken设置", @""],
              @[@"回放tkToken设置", @""],
              ];
    [self setupDataArr:array];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    NSString *className = self.classNames[indexPath.row];
    if (!kStringIsEmpty(className)) {
        UIViewController *vc = [[NSClassFromString(className) alloc] init];
        vc.title = self.titles[indexPath.row];
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 0) {
        [self showAlertWithTitle:@"设备级tkToken设置" message:@"注：channelNo传*，resourceCategory传global" appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入设备序列号";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入tkToken";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                if (kStringIsEmpty(alertSelf.textFields[0].text) || kStringIsEmpty(alertSelf.textFields[1].text)) {
                    [EZToast show:@"请输入完整的信息"];
                    return;
                }
                [EZOpenSDK setDeviceTokenForDeviceSerial:alertSelf.textFields[0].text deviceToken:alertSelf.textFields[1].text];
            }
        }];
    } else if (indexPath.row == 1) {
        [self showAlertWithTitle:@"设备通道级tkToken设置" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入设备序列号";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入设备通道，不支持*";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.keyboardType = UIKeyboardTypeNumberPad;
                textField.text = @"1";
            }];
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入global tkToken";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"请输入video tkToken";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                if (kStringIsEmpty(alertSelf.textFields[0].text) || kStringIsEmpty(alertSelf.textFields[1].text)
                    || kStringIsEmpty(alertSelf.textFields[2].text) || kStringIsEmpty(alertSelf.textFields[3].text)) {
                    [EZToast show:@"请输入完整的信息"];
                    return;
                }
                [EZOpenSDK setDeviceTokenForDeviceSerial:alertSelf.textFields[0].text cameraNo:alertSelf.textFields[1].text.intValue deviceGlobalToken:alertSelf.textFields[2].text deviceVideoToken:alertSelf.textFields[3].text];
            }
        }];
    } else if (indexPath.row == 2) {// 预览tkToken设置
        [self showAlertWithTitle:@"预览tkToken设置" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                UITextField *textField = alertSelf.textFields.firstObject;
                [GlobalKit shareKit].previewStreamToken = textField.text;
            }
        }];
    } else if (indexPath.row == 3) {// 对讲tkToken设置
        [self showAlertWithTitle:@"对讲tkToken设置" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                UITextField *textField = alertSelf.textFields.firstObject;
                [GlobalKit shareKit].talkStreamToken = textField.text;
            }
        }];
    } else if (indexPath.row == 4) {// 回放tkToken设置
        [self showAlertWithTitle:@"回放streamToken设置" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.placeholder = @"";
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
                textField.text = @"";
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                UITextField *textField = alertSelf.textFields.firstObject;
                [GlobalKit shareKit].playbackStreamToken = textField.text;
            }
        }];
    }
}

@end
