//
//  EZTestVC.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2023/6/20.
//  Copyright © 2023 hikvision. All rights reserved.
//

#import "EZTestVC.h"
#import "SMIPContainerTestViewController.h"
#import "EZDeviceInfo.h"

@interface EZTestVC () {
    NSArray *array;
}

@end

@implementation EZTestVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"萤石功能测试";
    
    BOOL ddnsDemoShow = NO;
#ifdef EZVIZ_GLOBAL_DEMO
    ddnsDemoShow = YES;
#endif
    NSString *autoTestTitle = [kUserDefaults boolForKey:EZAutoTest] ? @"自动化测试(开启)" : @"自动化测试(关闭)";
    array = @[@[@"设备发现", @"EZLocalDeviceListViewController"],
              @[@"DDNS Demo(海外功能，国内不支持)", ddnsDemoShow ? @"EZDdnsDeviceTableViewController" : @""],
              @[@"P2P测试", @"EZP2pTestVC"],
              @[autoTestTitle, @""],
              @[@"取流方式设置", @"EZStreamTypeSettingVC"],
              @[@"设置云录制SpaceId", @""],
              @[@"小权限tkToken设置", @"EZTKTokenTestVC"],
              @[@"接口测试", @"EZHttpInterfaceTestVC"],
              @[@"设备验证码清空", @""],
              @[@"性能/画质优先(随机，多点几次)", @""],
              @[@"左右滑动播放测试", @""],
              ];
    [self setupDataArr:array];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    [tableView deselectRowAtIndexPath:indexPath animated:YES];
    
    NSString *className = self.classNames[indexPath.row];
    if (!kStringIsEmpty(className)) {
        UIViewController *vc = [[NSClassFromString(className) alloc] init];
        vc.title = self.titles[indexPath.row];
        [self.navigationController pushViewController:vc animated:YES];
    } else if (indexPath.row == 3) {// 自动化测试
        [self showAlertWithTitle:@"是否开启自动化测试" message:@"萤石SDK测试人员专用，开启后本应用中的账号登录和退出功能将禁用" appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                [kUserDefaults setBool:YES forKey:EZAutoTest];
                [kUserDefaults synchronize];
            }
        }];
    } else if (indexPath.row == 5) {// 云录制spaceId设置
        [self showAlertWithTitle:@"请输入云录制spaceId" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
            [alertMaker addTextFieldWithConfigurationHandler:^(UITextField * _Nonnull textField) {
                textField.clearButtonMode = UITextFieldViewModeWhileEditing;
            }];
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                UITextField *spaceIdTF = alertSelf.textFields.firstObject;
                [kUserDefaults setValue:spaceIdTF.text forKey:EZCloudRecordSpaceId];
                [kUserDefaults synchronize];
                [EZToast show:@"SpaceId设置成功"];
            }
        }];
    } else if (indexPath.row == 8) {// 验证码清空
        [self showAlertWithTitle:@"是否清空所有设备验证码" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
            alertMaker.addActionCancelTitle(@"取消");
            alertMaker.addActionDefaultTitle(@"确定");
        } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
            if (buttonIndex == 1) {
                [[GlobalKit shareKit] clearAllDeviceSerialVerifyCode];
                [EZToast show:@"所有设备验证码已清空"];
            }
        }];
    } else if (indexPath.row == 9) {// 性能/画质优先
        switch (arc4random()%3) {
            case 1:
                [GlobalKit shareKit].videoQuality = EZVideoQualityTypePerformancePriority;
                [EZToast show:@"已设置为性能优先"];
                break;
            case 2:
                [GlobalKit shareKit].videoQuality = EZVideoQualityTypeQualityPriority;
                [EZToast show:@"已设置为画质优先"];
                break;
            default:
                [GlobalKit shareKit].videoQuality = EZVideoQualityTypeNone;
                [EZToast show:@"已恢复默认，取消性能优先或画质优先"];
                break;
        }
    } else if (indexPath.row == 10) {// 左右滑动播放测试
        NSMutableArray *array = [NSMutableArray array];
        for (int i = 0; i < self.deviceArray.count; i ++) {
            EZDeviceInfo *deviceInfo = self.deviceArray[i];
            
            SMTestPlayConfig *config = [[SMTestPlayConfig alloc] init];
            config.deviceSerial = deviceInfo.deviceSerial;
            config.cameraNo = 1;
            
            [array addObject:config];
        }
        SMIPContainerTestViewController *testVC = [[SMIPContainerTestViewController alloc] initWithConfigs:array];
        [self.navigationController pushViewController:testVC animated:YES];
    }
}

#pragma mark - 懒加载


@end
