//
//  EZAbroadCloudServiceExVC.m
//  EZOpenSDKDemo
//  海外云存储服务支持的接口，国内不支持；The interfaces supported by overseas cloud storage services are not supported in China
//
//  Created by JuneCheng on 2022/1/5.
//  Copyright © 2022 hikvision. All rights reserved.
//

#import "EZAbroadCloudServiceExVC.h"

#import "EZCameraInfo.h"
#import "EZDeviceCloudServiceInfo.h"
#import "EZCloudRecordFile.h"

@interface EZAbroadCloudServiceExVC () {
    NSArray *abstractvideos;
}

@end

@implementation EZAbroadCloudServiceExVC

- (void)viewDidLoad {
    [super viewDidLoad];
    self.navigationItem.title = @"海外云存储服务接口";
    
    [self setupDataArr:@[@[@"检查国家是否支持云存储", @"isSupportCloundServiceReq"],
                         @[@"查询云存储设备通道套餐信息", @"getCloundDevicePackageInfoReq"],
                         @[@"云存储功能暂停恢复", @"setCloundServiceActiveReq"],
                         @[@"查询某月中有视频文件的天(日期)", @"getCloudVideoDays"],
                         @[@"按设备通道删除所有云存储录像片段", @"deleteAllCloudVideo"],
                         @[@"按天增量查询云存储录像列表接口(概要信息)", @"getIncrCloudVideos"],
                         @[@"根据文件id批量查询详情信息接口", @"getCloudVideoDetails"],
                         @[@"删除云存储录像片段", @"deleteCloudVideoFragment"]
                         ]];
}

/** 检查国家是否支持云存储 */
- (void)isSupportCloundServiceReq {
    [EZGlobalSDK isSupportCloundService:^(BOOL isSupport, NSError *error) {
        [EZToast show:[NSString stringWithFormat:@"此国家%@支持云存储服务", isSupport ? @"" : @"不"]];
    }];
}

/** 查询云存储设备通道套餐信息 */
- (void)getCloundDevicePackageInfoReq {
    [EZGlobalSDK getCloundDevicePackageInfo:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo completion:^(EZDeviceCloudServiceInfo *serviceInfo, NSError *error) {
        NSString *resString = [serviceInfo.mj_keyValues mj_JSONString];
        [self showResponseAlertWithTitle:@"查询云存储设备通道套餐信息" resString:resString];
    }];
}

/** 云存储功能暂停恢复 */
- (void)setCloundServiceActiveReq {
    [self showAlertWithTitle:@"暂停/恢复云存储功能" message:nil appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
        alertMaker.addActionCancelTitle(@"暂停");
        alertMaker.addActionDefaultTitle(@"恢复");
    } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
        [EZGlobalSDK setCloundServiceActive:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo enable:buttonIndex == 1 completion:^(NSError *error) {
            if (!error) {
                [EZToast show:[NSString stringWithFormat:@"%@成功", buttonIndex == 1 ? @"恢复" : @"暂停"]];
            }
        }];
    }];
    
}

/** 查询某月中有视频文件的天(日期) */
- (void)getCloudVideoDays {
    [EZGlobalSDK getCloudVideoDays:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo month:[[NSDate date] formattedDateWithFormat:@"yyyyMM"] completion:^(NSArray<NSString *> *dayArray, NSError *error) {
        if (!error) {
            NSString *resString = [dayArray mj_JSONString];
            [self showResponseAlertWithTitle:@"查询某月中有视频文件的天(日期)" resString:resString];
        }
    }];
}

/** 按设备通道删除所有云存储录像片段 */
- (void)deleteAllCloudVideo {
    [EZGlobalSDK deleteAllCloudVideo:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo completion:^(NSError *error) {
        if (!error) {
            [EZToast show:@"云储存视频删除成功"];
        } else if (error.code == EZ_HTTPS_CLOUD_DELETE_ALL_EXCEPT_LAST) {//云存储视频删除完成，除了最后一个在录制的视频无法删除
            [EZToast show:@"云储存视频删除成功，除了最后一个在录制的视频"];
        } else {
            [EZToast show:error.description];
        }
    }];
}

/** 按天增量查询云存储录像列表接口(概要信息) */
- (void)getIncrCloudVideos {
    NSString *searchDateString = [[NSDate date] formattedDateWithFormat:yMdFormat];
    NSString *maxCreateDateString = [[[NSDate date] dateBySubtractingHours:3] formattedDateWithFormat:yMdHmsFormat];
    [EZGlobalSDK getIncrCloudVideos:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo videoType:EZCloudVideoTypeAll searchDate:searchDateString maxCreateTime:maxCreateDateString completion:^(NSArray *abstractvideos, NSError *error) {
        if (!error) {
            self->abstractvideos = abstractvideos;
            NSString *resString = [abstractvideos mj_JSONString];
            [self showResponseAlertWithTitle:@"按天增量查询云存储录像列表接口(概要信息)" resString:resString];
        }
    }];
}

/** 根据文件id批量查询详情信息接口 */
- (void)getCloudVideoDetails {
    if (kArrayIsEmpty(abstractvideos)) {
        [EZToast show:@"请先调用getIncrCloudVideos接口，获取云存储录像概要信息"];
        return;
    }
    [EZGlobalSDK getCloudVideoDetails:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo videos:abstractvideos completion:^(NSArray *couldRecords, NSError *error) {
        if (!error) {
            // 对象中含有NSDate，无法使用mj_JSONString
//            NSString *resString = [couldRecords mj_JSONString];
            NSMutableString *stringM = [NSMutableString string];
            for (EZCloudRecordFile *record in couldRecords) {
                [stringM appendString:[record description]];
                [stringM appendString:@"\n"];
            }
            [self showResponseAlertWithTitle:@"根据文件id批量查询详情信息接口" resString:[NSString stringWithFormat:@"%@", stringM]];
        }
    }];
}

/** 删除云存储录像片段 */
- (void)deleteCloudVideoFragment {
    if (kArrayIsEmpty(abstractvideos)) {
        [EZToast show:@"请先调用getIncrCloudVideos接口，获取云存储录像概要信息"];
        return;
    }
    [EZGlobalSDK deleteCloudVideoFragment:self.cameraInfo.deviceSerial channelNo:self.cameraInfo.cameraNo videos:abstractvideos completion:^(NSError *error) {
        if (!error) {
            [EZToast show:@"云储存视频删除成功"];
        }
    }];
}





/** 弹框显示数据 */
- (void)showResponseAlertWithTitle:(NSString *)title resString:(NSString *)resString {
    [self showAlertWithTitle:title message:resString appearanceProcess:^(JXTAlertController * _Nonnull alertMaker) {
        alertMaker.addActionCancelTitle(@"取消");
        alertMaker.addActionDefaultTitle(@"复制");
    } actionsBlock:^(NSInteger buttonIndex, UIAlertAction * _Nonnull action, JXTAlertController * _Nonnull alertSelf) {
        if (buttonIndex == 1) {
            UIPasteboard *pasteboard = [UIPasteboard generalPasteboard];
            pasteboard.string = resString;
            [EZToast show:@"已复制到剪贴板"];
        }
    }];
}

#pragma mark - UITableViewDelegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    NSString *methodName = self.classNames[indexPath.row];
    SEL selecotor = NSSelectorFromString(methodName);
    if ([self respondsToSelector:selecotor]) {
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Warc-performSelector-leaks"
        [self performSelector:selecotor];
#pragma clang diagnostic pop
    }
}

@end
