//
//  EZRecordCell.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/11/3.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "EZRecordCell.h"
#import "EZDeviceRecordFile.h"
#import "EZCloudRecordFile.h"
#import "UIImageView+AFNetworking.h"

@implementation EZRecordCell {
    
    EZDeviceRecordFile *deviceFile;
    EZCloudRecordFile *cloudFile;
}

- (void)setCloudRecord:(EZCloudRecordFile *)cloudFile selected:(BOOL)selected {
    if (![cloudFile isKindOfClass:[EZCloudRecordFile class]]) {
        return;
    }
    self.imageView.backgroundColor = [UIColor clearColor];
    self.imageView.layer.cornerRadius = 5.f;
    self.imageView.layer.masksToBounds = YES;
    self.imageView.layer.borderWidth = 2.0f;
    self.imageView.layer.borderColor = [UIColor clearColor].CGColor;
    //https://cloud.ys7.com:8089/api/cloud?method=download&fid=bf883130-8e13-11e5-8000-a4b5707128a7&session=hik%24shipin7%231%23USK%23at.05idkxni22jmnf4x4f3o380e0oum07ve-7sjmcfm1m8-18q74ue-zhxrqgkur
    NSURL *url = [NSURL URLWithString:cloudFile.coverPic];
    NSMutableURLRequest *request = [NSMutableURLRequest requestWithURL:url];
    request.HTTPMethod = @"POST";
    NSString *password = @"";
    // 判断是否加密
    if (![cloudFile.encryption isEqualToString:@""]) {
        // 注意该密码是一定要正确的，否则会得不到图片数据
        password = [[GlobalKit shareKit].deviceVerifyCodeBySerial valueForKey:self.deviceSerial];
    }
    NSString *body = [NSString stringWithFormat:@"%@&x=%d&decodekey=%@", cloudFile.coverPic, 200, password];
    request.HTTPBody = [body dataUsingEncoding:NSUTF8StringEncoding];
    EZWeak(self);
    [self.imageView setImageWithURLRequest:request
                          placeholderImage:[UIImage imageNamed:@"message_callhelp"]
                                   success:^(NSURLRequest * _Nonnull request, NSHTTPURLResponse * _Nullable response, UIImage * _Nonnull image) {
                                       EZStrong(self);
                                       strongself.imageView.image = image;
                                   }
                                   failure:^(NSURLRequest * _Nonnull request, NSHTTPURLResponse * _Nullable response, NSError * _Nonnull error) {
                                       NSLog(@"error = %@",error);
                                   }];
    
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.locale = [[NSLocale alloc] initWithLocaleIdentifier:@"zh_CN"];
    formatter.dateFormat = @"HH:mm";
    self.timeLabel.text = [formatter stringFromDate:cloudFile.startTime];
    self.timeLabel.textColor = [UIColor whiteColor];
    self.durationLabel.text = [self getRecordDurationWithStopTime:cloudFile.stopTime startTime:cloudFile.startTime];
    
    if (selected) {
        UIColor *tintColor = [UIColor dd_hexStringToColor:@"0x1b9ee2"];
        self.imageView.layer.borderColor = tintColor.CGColor;
//        self.timeLabel.textColor = tintColor;
    }
    
    self->cloudFile = cloudFile;
}

- (void)setDeviceRecord:(EZDeviceRecordFile *)deviceFile selected:(BOOL)selected {
    if (![deviceFile isKindOfClass:[EZDeviceRecordFile class]]) {
        return;
    }
    self.imageView.backgroundColor = [UIColor grayColor];
    self.imageView.layer.cornerRadius = 5.f;
    self.imageView.layer.masksToBounds = YES;
    self.imageView.layer.borderWidth = 2.0f;
    self.imageView.layer.borderColor = [UIColor clearColor].CGColor;
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    formatter.locale = [[NSLocale alloc] initWithLocaleIdentifier:@"zh_CN"];
    formatter.dateFormat = @"HH:mm";
    self.timeLabel.text = [formatter stringFromDate:deviceFile.startTime];
    self.timeLabel.textColor = [UIColor whiteColor];
    self.durationLabel.text = [self getRecordDurationWithStopTime:deviceFile.stopTime startTime:deviceFile.startTime];
    self.imageView.image = deviceFile.imageData ? [UIImage imageWithData:deviceFile.imageData] : [UIImage imageNamed:@"message_callhelp"];
    
    if (selected) {
        UIColor *tintColor = [UIColor dd_hexStringToColor:@"0x1b9ee2"];
        self.imageView.layer.borderColor = tintColor.CGColor;
//        self.timeLabel.textColor = tintColor;
    }
    
    self->deviceFile = deviceFile;
}

/** 计算录像时长 */
- (NSString *)getRecordDurationWithStopTime:(NSDate *)stopTime startTime:(NSDate *)startTime {
    double _duringSeconds = [stopTime secondsLaterThan:startTime];
    int minute =  (int)_duringSeconds / 60;
    int seconds = (int)_duringSeconds % 60;
    
    return [NSString stringWithFormat:@"%d'%d\"", minute, seconds];
}

@end
