//
//  SMIPContainerTestViewController.m
//  SM_LivePlayBack_BusinessCmp
//
//  Created by hik on 2024/10/10.
//

#import "SMIPContainerTestViewController.h"
#import "SMTestIPCPlayerContainer.h"
#import "SMTestPlayerViewModel.h"

#import "EZPlayer.h"

@interface SMIPContainerTestViewController ()<SMTestIPCPlayerContainerDelegate, EZPlayerDelegate>
@property (nonatomic, strong) SMTestIPCPlayerContainer *playerContainer;
@property (nonatomic, strong) EZPlayer *realPlayer;
@property (nonatomic, strong) SMTestPlayerViewModel *viewModel;
@end

@implementation SMIPContainerTestViewController

// MARK: Init

- (instancetype)initWithConfigs:(NSArray<SMTestPlayConfig *> *)configs {
    self = [super init];
    if (self) {
        _viewModel = [[SMTestPlayerViewModel alloc] initWithConfigs:configs];
    }
    return self;
}

// MARK: LifeCycle

- (void)dealloc {
    if (_realPlayer) {
        [EZOpenSDK releasePlayer:_realPlayer];
    }
}

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view.
    [self setupUI];
    [self startPlay];
}

- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
    [self stopPlay];
}

- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
//    [self stopPlay];
}

- (void)setupUI {
    self.view.backgroundColor = UIColor.whiteColor;
    [self.view addSubview:self.playerContainer];
}

// MARK: Play

- (void)startPlay {
    [self.realPlayer startRealPlay];
}

- (void)stopPlay {
    [self.realPlayer stopRealPlay];
}

// MARK: SMIPCPlayerContainerDelegate

- (void)playerContainer:(SMTestIPCPlayerContainer *)playerContainer willScrollFromIndex:(NSInteger)fromIndex {
    NSLog(@"aaaa_will scroll from %ld", (long)fromIndex);
}

- (void)playerContainer:(SMTestIPCPlayerContainer *)playerContainer didScrollFromIndex:(NSInteger)fromIndex toIndex:(NSInteger)toIndex {
    NSLog(@"aaaa_did scroll from %ld to %ld", (long)fromIndex, (long)toIndex);
    [self stopPlay];

    [self.viewModel scrollToIndex:toIndex];
}

- (void)playerContainerDidEndScrolling:(SMTestIPCPlayerContainer *)playerContainer {
    NSLog(@"aaaa_end srcoll currentIndex = %ld", (long)playerContainer.currentIndex);
    
    [_realPlayer resetDeviceSerial:self.viewModel.deviceSerial cameraNo:self.viewModel.cameraNo];
    NSString *verifyCode = [[GlobalKit shareKit].deviceVerifyCodeBySerial objectForKey:self.viewModel.deviceSerial];
    [_realPlayer setPlayVerifyCode:verifyCode];
    [_realPlayer setPlayerView:self.playerContainer.playView];
    
    [self startPlay];
}

// MARK: Getter

- (EZPlayer *)realPlayer {
    if (!_realPlayer) {
        _realPlayer = [EZOpenSDK createPlayerWithDeviceSerial:self.viewModel.deviceSerial cameraNo:self.viewModel.cameraNo useSubStream:NO];
        NSString *verifyCode = [[GlobalKit shareKit].deviceVerifyCodeBySerial objectForKey:self.viewModel.deviceSerial];
        [_realPlayer setPlayVerifyCode:verifyCode];
        _realPlayer.delegate = self;
        [_realPlayer setHDPriority:YES];
        [_realPlayer setPlayerView:self.playerContainer.playView];
    }
    return _realPlayer;
}

- (SMTestIPCPlayerContainer *)playerContainer {
    if (!_playerContainer) {
        _playerContainer = [[SMTestIPCPlayerContainer alloc] initWithIndex:0 videoCount:self.viewModel.configs.count delegate:self];
        _playerContainer.frame = CGRectMake(0, 0, MAINSCREEN_WIDTH, 230);
    }
    return _playerContainer;
}


@end
