//
//  SMTestIPCPlayerContainer.h
//  SM_LivePlayBack_BusinessCmp
//
//  Created by Lee on 2022/10/9.
//

#import <UIKit/UIKit.h>
#import "SMTestScrollView.h"

#define MAINSCREEN_WIDTH [UIScreen mainScreen].bounds.size.width

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, SMTestIPCScrollStare) {
    SMTestIPCScrollStareNormal,                                    ///< IPC Player Container初始化默认状态
    SMTestIPCScrollStareBegan,                                     ///< IPC Player Container被用户操作后，开始滑动
    SMTestIPCScrollStareChanged,                                   ///< IPC Player Container被用户操作后，处于滑动状态
    SMTestIPCScrollStareEnded,                                     ///< IPC Player Container被用户操作后，处于滑动停止状态,没有滑动
    SMTestIPCScrollStareCancelled                                  ///< IPC Player Container被用户操作后，处于滑动取消状态
};

@class SMTestIPCPlayerContainer;

@protocol SMTestIPCPlayerContainerDelegate <NSObject>

@optional

// 即将开始滑动，有可能滑动距离不够，滑动会被取消
- (void)playerContainer:(SMTestIPCPlayerContainer *)playerContainer willScrollFromIndex:(NSInteger)fromIndex;
// 滑动已经识别翻页，不会被取消
- (void)playerContainer:(SMTestIPCPlayerContainer *)playerContainer didScrollFromIndex:(NSInteger)fromIndex toIndex:(NSInteger)toIndex;
// 滑动完全结束直至停止
- (void)playerContainerDidEndScrolling:(SMTestIPCPlayerContainer *)playerContainer;
// 滑动完全结束直至停止
- (void)playerContainerDidCancleScrolling:(SMTestIPCPlayerContainer *)playerContainer;

@end

@interface SMTestIPCPlayerContainer : UIView

@property (nonatomic, weak, readonly) id<SMTestIPCPlayerContainerDelegate> delegate;
@property (nonatomic, assign, readonly) NSInteger currentIndex;
@property (nonatomic, assign, readonly) SMTestIPCScrollStare scrollStare;
@property (nonatomic, strong, readonly) SMTestScrollView *scrollView;
@property (nonatomic, strong, readonly) UIView *playView;

- (instancetype)init NS_UNAVAILABLE;
+ (instancetype)new NS_UNAVAILABLE;

- (instancetype)initWithIndex:(NSInteger)index
                   videoCount:(NSInteger)videoCount
                     delegate:(id<SMTestIPCPlayerContainerDelegate>)delegate;
- (void)scrollToInitialIndex;

@end

NS_ASSUME_NONNULL_END
