//
//  SMTestPlayerViewModel.m
//  SM_LivePlayBack_BusinessCmp
//
//  Created by hik on 2024/10/11.
//

#import "SMTestPlayerViewModel.h"
#import "SMTestPlayConfig.h"

@interface SMTestPlayerViewModel ()

@property (nonatomic, assign, readwrite) NSUInteger cameraNo;
@property (nonatomic, strong, readwrite) NSString *deviceSerial;
@property (nonatomic, assign, readwrite) NSUInteger currentIndex; 
@property (nonatomic, strong, readwrite) NSArray<SMTestPlayConfig *> *configs;

@end

@implementation SMTestPlayerViewModel

- (instancetype)initWithConfigs:(NSArray<SMTestPlayConfig *> *)configs {
    self = [super init];
    if (self) {
        _configs = configs;
        self.currentIndex = 0;
    }
    return self;
}

- (void)scrollToIndex:(NSUInteger)index {
    self.currentIndex = index;
}

- (void)setCurrentIndex:(NSUInteger)currentIndex {
    _currentIndex = currentIndex;
    SMTestPlayConfig *currentConfig = [self.configs objectAtIndex:currentIndex];
    self.deviceSerial = currentConfig.deviceSerial;
    self.cameraNo = currentConfig.cameraNo;
}

@end
