//
//  SMScrollView.h
//  SM_LivePlayBack_BusinessCmp
//
//  Created by Lee on 2022/10/11.
//

#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, SMScrollViewLayout) {
    SMScrollViewLayoutHorizontal,
    SMScrollViewLayoutVertical
};

@interface SMTestScrollView : UIScrollView

@property (nonatomic, strong) UIView *container;

// subview的排布方向，默认是 SMScrollViewLayoutHorizontal
@property (nonatomic, assign) SMScrollViewLayout layout;
@property (nonatomic, assign) CGSize itemSize;
@property (nonatomic, assign) CGFloat innerSpace;

/// 是否需要处理系统侧滑返回的手势冲突，默认是NO
@property (nonatomic, assign) BOOL needHandlePopGestureConflict;
/// 系统侧滑返回生效的距离，默认是30
@property (nonatomic, assign) NSInteger popGestureValidDistance;
/// 当位置不在第一页视图时是否也能侧滑返回，默认是NO
@property (nonatomic, assign) BOOL canPopBackWhenNotInFirstPageView;

- (void)setup;

/**
 *  在scrollview上用约束进行布局，加上一个container，比较好布局
 *  @param view 将要在contaner上的view

 */
- (void)containerAppendSubview:(UIView *)view;

/**
 *  @brief 给 subview 添加约束
 */
- (void)containerLayoutSubview;

/**
 *  删除container上所有的子视图
 */
- (void)containerRemoveAllSubviews;

@end

NS_ASSUME_NONNULL_END
