//
//  SMScrollView.m
//  SM_LivePlayBack_BusinessCmp
//
//  Created by Lee on 2022/10/11.
//

#import "SMTestScrollView.h"
#import "Masonry.h"

@implementation SMTestScrollView

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.popGestureValidDistance = 30;
        [self setup];
    }
    return self;
}

- (void)awakeFromNib {
    [super awakeFromNib];
    self.popGestureValidDistance = 30;
    [self setup];
}

- (void)setup {}

- (void)containerAppendSubview:(UIView *)view{
    [self.container addSubview:view];
}

- (void)containerLayoutSubview {
    UIView *preView;
    for (NSInteger i = 0; i < self.container.subviews.count ; i ++) {
        UIView *currentView = self.container.subviews[i];
        if (self.layout == SMScrollViewLayoutHorizontal) {
            [currentView mas_remakeConstraints:^(MASConstraintMaker *make) {
                if ( i == 0) {
                    make.left.mas_equalTo(0);
                }else{
                    make.left.equalTo(preView.mas_right).offset(self.innerSpace);
                }
                make.top.mas_equalTo(0);
                make.bottom.mas_equalTo(0);
                if (self.itemSize.width != 0) {
                    make.width.mas_equalTo(self.itemSize.width);
                }
                if (self.itemSize.height != 0) {
                    make.height.mas_equalTo(self.itemSize.height);
                }
                if (i == self.container.subviews.count - 1) {
                    make.right.mas_equalTo(0);
                }
            }];
        } else {
            [currentView mas_remakeConstraints:^(MASConstraintMaker *make) {
                make.left.mas_equalTo(0);
                make.right.mas_equalTo(0);
                if (self.itemSize.width != 0) {
                    make.width.mas_equalTo(self.itemSize.width);
                }
                if (self.itemSize.height != 0) {
                    make.height.mas_equalTo(self.itemSize.height);
                }
                
                if ( i == 0) {
                    make.top.mas_equalTo(0);
                } else {
                    make.top.equalTo(preView.mas_bottom).offset(self.innerSpace);
                }
                
                if (i == self.container.subviews.count - 1) {
                    make.bottom.mas_equalTo(0);
                }
            }];
        }
        currentView.tag = i;
        currentView.userInteractionEnabled = true;
        preView = currentView;
    }
}

- (void)containerRemoveAllSubviews {
    [self.container.subviews makeObjectsPerformSelector:@selector(removeFromSuperview)];
}

#pragma mark - UIGestureRecognizerDelegate
/// 如果是侧滑返回，则scrollview的右滑就没用了，返回NO，让scrollview的右滑失效
- (BOOL)gestureRecognizerShouldBegin:(UIGestureRecognizer *)gestureRecognizer {
    return ![self canPanBack:gestureRecognizer];
}

/// 暂时不需要使用这个代理方法做处理
/// 是否支持多手势触发，返回YES，则可以多手势一起触发，手势事件会一直往下传递，返回NO则为互斥
//- (BOOL)gestureRecognizer:(UIGestureRecognizer *)gestureRecognizer shouldRecognizeSimultaneouslyWithGestureRecognizer:(nonnull UIGestureRecognizer *)otherGestureRecognizer {
//    return [self canPanBack:gestureRecognizer];
//}

/// 是否可以系统侧滑返回
- (BOOL)canPanBack:(UIGestureRecognizer *)gestureRecognizer {
    if (!self.needHandlePopGestureConflict || gestureRecognizer != self.panGestureRecognizer) {
        return NO;
    }
    
    UIGestureRecognizerState state = gestureRecognizer.state;
    if (state == UIGestureRecognizerStateBegan || state == UIGestureRecognizerStatePossible) {
        CGPoint point = [self.panGestureRecognizer translationInView:self];
        //也可根据速度来判断方向
//        CGPoint velocity = [self.panGestureRecognizer velocityInView:self];
        NSInteger locDistance = (NSInteger)UIScreen.mainScreen.bounds.size.width;
        NSInteger locationPointX = (NSInteger)[gestureRecognizer locationInView:self].x;
        NSInteger offsetX = (NSInteger)self.contentOffset.x;
        BOOL isValidDistance = locationPointX % locDistance < self.popGestureValidDistance;
        if (point.x > 0 && isValidDistance && (offsetX <= 0 || (self.canPopBackWhenNotInFirstPageView && offsetX % locDistance == 0))) {
            return YES;
        }
    }
    return NO;
}

#pragma mark - Getters

- (UIView *)container {
    if (!_container) {
        _container = [UIView new];
        _container.backgroundColor = [UIColor clearColor];
        [self addSubview:_container];
        [_container mas_makeConstraints:^(MASConstraintMaker *make) {
            make.edges.insets(UIEdgeInsetsZero);
        }];
    }
    return _container;
}

@end
