//
//  EZOfflineCameraCell.m
//  EZOpenSDKDemo
//
//  Created by yuqian on 2020/3/10.
//  Copyright © 2020 hikvision. All rights reserved.
//

#import "EZOfflineCameraCell.h"

@interface EZOfflineCameraCell()

@property (nonatomic, strong) UILabel *tipLabel;

@end

@implementation EZOfflineCameraCell

- (instancetype)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        self.contentView.backgroundColor = [UIColor blackColor];
        self.contentView.layer.masksToBounds = YES;
        self.contentView.layer.cornerRadius = 10.0;
        
        [self.contentView addSubview:self.tipLabel];
        [self.tipLabel mas_makeConstraints:^(MASConstraintMaker *make) {
            make.center.equalTo(self.contentView);
        }];
    }
    return self;
}

- (UILabel *)tipLabel {
    
    if (!_tipLabel) {
        _tipLabel = [[UILabel alloc]init];
        _tipLabel.text = @"设备不在线";
        _tipLabel.font = [UIFont systemFontOfSize:12.0];
        _tipLabel.textColor = [UIColor whiteColor];
        _tipLabel.textAlignment = NSTextAlignmentCenter;
    }
    return _tipLabel;
}

@end
