//
//  EZWaterMarkView.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/9/22.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import "EZWaterMarkView.h"
#import "EZCustomSlider.h"
#import "StepSlider.h"
#import "EZPlayWaterMarkConfig.h"

NS_ASSUME_NONNULL_BEGIN

@interface EZWaterMarkView ()<EZCustomSliderDelegate>

@property (nonatomic, strong) UILabel *lab_switch_title;///< 水印开关title
@property (nonatomic, strong) UISwitch *switch_waterMark;///< 水印开关
@property (nonatomic, strong) UIScrollView *sv_waterMark;///< 水印设置视图
@property (nonatomic, strong) UIButton *btn_close;///< 关闭按钮
@property (nonatomic, strong) EZCustomSlider *slider_font_size;///< 字体大小
@property (nonatomic, strong) EZCustomSlider *slider_font_space;///< 字体行间距
@property (nonatomic, strong) EZCustomSlider *slider_rotate_angle;///< 字体倾斜角度
@property (nonatomic, strong) UILabel *lab_font_alignment;///< 字体对齐方式title
@property (nonatomic, strong) StepSlider *slider_font_alignment;///<字体对齐方式
@property (nonatomic, strong) EZCustomSlider *slider_font_position_x;///< x轴比例位置
@property (nonatomic, strong) EZCustomSlider *slider_font_position_y;///< y轴比例位置
@property (nonatomic, strong) EZCustomSlider *slider_font_color_red;///< 红
@property (nonatomic, strong) EZCustomSlider *slider_font_color_green;///< 绿
@property (nonatomic, strong) EZCustomSlider *slider_font_color_blue;///< 蓝
@property (nonatomic, strong) EZCustomSlider *slider_font_alpha;///< 透明度
@property (nonatomic, strong) UILabel *lab_switch_font_color_adapt;///< 字体颜色自适应title
@property (nonatomic, strong) UISwitch *switch_font_color_adapt;///< 字体颜色自适应开关
@property (nonatomic, strong) UILabel *lab_switch_fill_full_screen;///< 水印铺满全屏title
@property (nonatomic, strong) UISwitch *switch_fill_full_screen;///< 水印铺满全屏开关
@property (nonatomic, strong) EZCustomSlider *slider_font_row_number;///< 行数
@property (nonatomic, strong) EZCustomSlider *slider_font_column_number;///< 列数
@property (nonatomic, strong) UILabel *lab_window_adapt;///< 窗口自适应title
@property (nonatomic, strong) StepSlider *slider_window_adapt;///< 窗口自适应
@property (nonatomic, strong) EZCustomSlider *slider_window_adapt_row_space;///< 自适应行列数行间距
@property (nonatomic, strong) EZCustomSlider *slider_window_adapt_column_space;///< 自适应行列数列间距

@property (nonatomic, strong) EZPlayWaterMarkConfig *waterMarkConfig;///< 水印配置
@property (nonatomic, assign) CGSize playerViewSize;///< 播放器视图Size

@end

@implementation EZWaterMarkView

- (instancetype)initWithFrame:(CGRect)frame waterMarkConfig:(EZPlayWaterMarkConfig *)waterMarkConfig playerViewSize:(CGSize)playerViewSize {
    self.waterMarkConfig = waterMarkConfig;
    self.playerViewSize = playerViewSize;
    return [self initWithFrame:frame];
}

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setUI];
        [self setLayout];
        DISPATCH_AFTER(0.1, ^{
            self.sv_waterMark.contentSize = CGSizeMake(kScreenWidth - 20, self.slider_window_adapt_column_space.bottom + 1);
        });
    }
    return self;
}

/** 创建UI */
- (void)setUI {
    self.backgroundColor = [UIColor whiteColor];
    
    [self addSubview:self.lab_switch_title];
    [self addSubview:self.switch_waterMark];
    [self addSubview:self.btn_close];
    [self addSubview:self.sv_waterMark];
    [self.sv_waterMark addSubview:self.slider_font_size];
    [self.sv_waterMark addSubview:self.slider_font_space];
    [self.sv_waterMark addSubview:self.slider_rotate_angle];
    [self.sv_waterMark addSubview:self.lab_font_alignment];
    [self.sv_waterMark addSubview:self.slider_font_alignment];
    [self.sv_waterMark addSubview:self.slider_font_position_x];
    [self.sv_waterMark addSubview:self.slider_font_position_y];
    [self.sv_waterMark addSubview:self.slider_font_color_red];
    [self.sv_waterMark addSubview:self.slider_font_color_green];
    [self.sv_waterMark addSubview:self.slider_font_color_blue];
    [self.sv_waterMark addSubview:self.slider_font_alpha];
    [self.sv_waterMark addSubview:self.lab_switch_font_color_adapt];
    [self.sv_waterMark addSubview:self.switch_font_color_adapt];
    [self.sv_waterMark addSubview:self.lab_switch_fill_full_screen];
    [self.sv_waterMark addSubview:self.switch_fill_full_screen];
    [self.sv_waterMark addSubview:self.slider_font_row_number];
    [self.sv_waterMark addSubview:self.slider_font_column_number];
    [self.sv_waterMark addSubview:self.lab_window_adapt];
    [self.sv_waterMark addSubview:self.slider_window_adapt];
    [self.sv_waterMark addSubview:self.slider_window_adapt_row_space];
    [self.sv_waterMark addSubview:self.slider_window_adapt_column_space];
}

#pragma mark - Public Methods

/** 显示水印窗口 */
- (void)show:(UIViewController *)viewController {
    // 打开水印
    self.switch_waterMark.on = YES;
    [self switchAction:self.switch_waterMark];
    [UIView animateWithDuration:0.3
                     animations:^{
        self.y = 0;
    } completion:^(BOOL finished) {
        
    }];
}

/** 窗口关闭 */
- (void)closeAction {
    [UIView animateWithDuration:0.3
                     animations:^{
        self.y = self.height;
    } completion:^(BOOL finished) {
        [self removeFromSuperview];
    }];
}

#pragma mark - 事件

/** 开关 */
- (void)switchAction:(id)sender {
    UISwitch *switchButton = (UISwitch *)sender;
    if (switchButton == self.switch_waterMark) {
        if (switchButton.on) {
            self.sv_waterMark.hidden = NO;
            [self onWaterMarkInfoChanged];
        } else {
            self.sv_waterMark.hidden = YES;
            [self onClearWaterMarkInfo];
        }
    } else if (switchButton == self.switch_font_color_adapt) {
        self.waterMarkConfig.fontColorAdapt = switchButton.on;
        self.slider_font_color_red.slider.enabled = !switchButton.on;
        self.slider_font_color_green.slider.enabled = !switchButton.on;
        self.slider_font_color_blue.slider.enabled = !switchButton.on;
        [self onWaterMarkInfoChanged];
    } else if (switchButton == self.switch_fill_full_screen) {
        self.waterMarkConfig.fillFullScreen = switchButton.on;
        self.slider_font_row_number.slider.enabled = switchButton.on;
        self.slider_font_column_number.slider.enabled = switchButton.on;
        if (self.waterMarkConfig.windowAdaptMode != EZWaterMarkWindowAdaptModeFontRowColumn) {
            self.slider_font_position_x.slider.enabled = !switchButton.on;
            self.slider_font_position_y.slider.enabled = !switchButton.on;
        }
        [self onWaterMarkInfoChanged];
    }
}

- (void)stepSliderValueChanged:(id)sender {
    StepSlider *stepSlider = (StepSlider *)sender;
    if (stepSlider == self.slider_font_alignment) {// 水印字体对齐方式
        if (stepSlider.index == 0) {
            self.waterMarkConfig.fontAlignment = EZWaterMarkTextAlignmentCenter;
        } else if (stepSlider.index == 1) {
            self.waterMarkConfig.fontAlignment = EZWaterMarkTextAlignmentLeft;
        } else if (stepSlider.index == 2) {
//            self.waterMarkConfig.fontAlignment = EZWaterMarkTextAlignmentRight;
            [EZToast show:@"暂不支持右对齐"];
        }
        [self onWaterMarkInfoChanged];
    } else if (stepSlider == self.slider_window_adapt) {// 窗口自适应
        self.slider_window_adapt_row_space.slider.enabled = NO;
        self.slider_window_adapt_column_space.slider.enabled = NO;
        self.switch_fill_full_screen.enabled = NO;
        self.slider_font_row_number.slider.enabled = NO;
        self.slider_font_column_number.slider.enabled = NO;
        self.slider_font_position_x.slider.enabled = NO;
        self.slider_font_position_y.slider.enabled = NO;
        if (stepSlider.index == 0) {// 关闭窗口自适应
            self.waterMarkConfig.windowAdaptMode = EZWaterMarkWindowAdaptModeNone;
            self.switch_fill_full_screen.enabled = YES;
            if (self.waterMarkConfig.fillFullScreen) {
                self.slider_font_row_number.slider.enabled = YES;
                self.slider_font_column_number.slider.enabled = YES;
            } else {
                self.slider_font_position_x.slider.enabled = YES;
                self.slider_font_position_y.slider.enabled = YES;
            }
        } else if (stepSlider.index == 1) {// 字体行数和列数自适应
            self.waterMarkConfig.windowAdaptMode = EZWaterMarkWindowAdaptModeFontRowColumn;
            self.slider_window_adapt_row_space.slider.enabled = YES;
            self.slider_window_adapt_column_space.slider.enabled = YES;
        } else if (stepSlider.index == 2) {// 字体大小自适应
            self.waterMarkConfig.windowAdaptMode = EZWaterMarkWindowAdaptModeFontSize;
            self.switch_fill_full_screen.enabled = YES;
            if (self.waterMarkConfig.fillFullScreen) {
                self.slider_font_row_number.slider.enabled = YES;
                self.slider_font_column_number.slider.enabled = YES;
            } else {
                self.slider_font_position_x.slider.enabled = YES;
                self.slider_font_position_y.slider.enabled = YES;
            }
            // 设置为字体大小自适应时，必须设置windowAdaptBaseWindowWidth 和 windowAdaptBaseWindowHeight
            self.waterMarkConfig.windowAdaptBaseWindowWidth = self.playerViewSize.width;
            self.waterMarkConfig.windowAdaptBaseWindowHeight = self.playerViewSize.height;
        }
        [self onWaterMarkInfoChanged];
    }
}

#pragma mark - EZCustomSliderDelegate

- (void)customSlider:(EZCustomSlider *_Nullable)slider valueChanged:(float)value {
    if (slider == self.slider_font_size) {// 水印字体大小
        self.waterMarkConfig.fontWidth = (int)value;
        self.waterMarkConfig.fontHeight = (int)value;
    } else if (slider == self.slider_font_space) {// 水印字体行间距
        self.waterMarkConfig.fontSpace = value;
    } else if (slider == self.slider_rotate_angle) {// 水印字体倾斜角度
        self.waterMarkConfig.fontRotateAngle = (int)value;
    } else if (slider == self.slider_font_position_x) {// x轴比例开始位置
        self.waterMarkConfig.startPosX = value;
    } else if (slider == self.slider_font_position_y) {// y轴比例开始位置
        self.waterMarkConfig.startPosY = value;
    } else if (slider == self.slider_font_color_red) {// 水印字体颜色-红
        self.waterMarkConfig.red = (int)value;
    } else if (slider == self.slider_font_color_green) {// 水印字体颜色-绿
        self.waterMarkConfig.green = (int)value;
    } else if (slider == self.slider_font_color_blue) {// 水印字体颜色-蓝
        self.waterMarkConfig.blue = (int)value;
    } else if (slider == self.slider_font_alpha) {// 水印字体-透明度
        self.waterMarkConfig.alpha = (int)value;
    } else if (slider == self.slider_font_row_number) {// 水印行数
        self.waterMarkConfig.rowNumber = (int)value;
    } else if (slider == self.slider_font_column_number) {// 水印列数
        self.waterMarkConfig.columnNumber = (int)value;
    } else if (slider == self.slider_window_adapt_row_space) {// 设置自适应行列数行间距
        self.waterMarkConfig.windowAdaptRowSpace = (int)value;
    } else if (slider == self.slider_window_adapt_column_space) {// 设置自适应行列数列间距
        self.waterMarkConfig.windowAdaptColumnSpace = (int)value;
    }
    
    [self onWaterMarkInfoChanged];
}

#pragma mark - 其他方法

/** 水印信息设置回调 */
- (void)onWaterMarkInfoChanged {
    if (self.waterMarkInfoChangedBlock) {
        self.waterMarkInfoChangedBlock();
    }
}

/** 水印信息清除回调 */
- (void)onClearWaterMarkInfo {
    if (self.waterMarkInfoClearBlock) {
        self.waterMarkInfoClearBlock();
    }
}

#pragma mark - 懒加载

- (UIScrollView *)sv_waterMark {
    if (!_sv_waterMark) {
        _sv_waterMark = [[UIScrollView alloc] init];
        _sv_waterMark.showsVerticalScrollIndicator = NO;
    }
    return _sv_waterMark;
}

- (UILabel *)lab_switch_title {
    if (!_lab_switch_title) {
        _lab_switch_title = [[UILabel alloc] init];
        _lab_switch_title.font = [UIFont systemFontOfSize:14.f];
        _lab_switch_title.textColor = [UIColor grayColor];
        _lab_switch_title.text = @"水印开关";
    }
    return _lab_switch_title;
}

- (UISwitch *)switch_waterMark {
    if (!_switch_waterMark) {
        _switch_waterMark = [[UISwitch alloc] init];
        _switch_waterMark.transform = CGAffineTransformMakeScale(0.8, 0.8);
        [_switch_waterMark addTarget:self action:@selector(switchAction:) forControlEvents:UIControlEventValueChanged];
    }
    return _switch_waterMark;
}

- (UILabel *)lab_switch_font_color_adapt {
    if (!_lab_switch_font_color_adapt) {
        _lab_switch_font_color_adapt = [[UILabel alloc] init];
        _lab_switch_font_color_adapt.font = [UIFont systemFontOfSize:14.f];
        _lab_switch_font_color_adapt.textColor = [UIColor grayColor];
        _lab_switch_font_color_adapt.text = @"字体颜色自适应";
    }
    return _lab_switch_font_color_adapt;
}

- (UISwitch *)switch_font_color_adapt {
    if (!_switch_font_color_adapt) {
        _switch_font_color_adapt = [[UISwitch alloc] init];
        _switch_font_color_adapt.transform = CGAffineTransformMakeScale(0.8, 0.8);
        [_switch_font_color_adapt addTarget:self action:@selector(switchAction:) forControlEvents:UIControlEventValueChanged];
        _switch_font_color_adapt.on = self.waterMarkConfig.fontColorAdapt;
    }
    return _switch_font_color_adapt;
}

- (UILabel *)lab_switch_fill_full_screen {
    if (!_lab_switch_fill_full_screen) {
        _lab_switch_fill_full_screen = [[UILabel alloc] init];
        _lab_switch_fill_full_screen.font = [UIFont systemFontOfSize:14.f];
        _lab_switch_fill_full_screen.textColor = [UIColor grayColor];
        _lab_switch_fill_full_screen.text = @"水印铺满全屏";
    }
    return _lab_switch_fill_full_screen;
}

- (UISwitch *)switch_fill_full_screen {
    if (!_switch_fill_full_screen) {
        _switch_fill_full_screen = [[UISwitch alloc] init];
        _switch_fill_full_screen.transform = CGAffineTransformMakeScale(0.8, 0.8);
        [_switch_fill_full_screen addTarget:self action:@selector(switchAction:) forControlEvents:UIControlEventValueChanged];
        _switch_fill_full_screen.on = self.waterMarkConfig.fillFullScreen;
    }
    return _switch_fill_full_screen;
}

- (UIButton *)btn_close {
    if (!_btn_close) {
        _btn_close = [UIButton buttonWithType:UIButtonTypeCustom];
        [_btn_close setImage:[UIImage imageNamed:@"play_close"] forState:UIControlStateNormal];
        [_btn_close addTarget:self action:@selector(closeAction) forControlEvents:UIControlEventTouchUpInside];
    }
    return _btn_close;
}

- (EZCustomSlider *)slider_font_size {
    if (!_slider_font_size) {
        _slider_font_size = [[EZCustomSlider alloc] initWithTitle:@"字体大小" minimumValue:15 maximumValue:100 currentValue:self.waterMarkConfig.fontWidth];
        _slider_font_size.delegate = self;
    }
    return _slider_font_size;
}

- (EZCustomSlider *)slider_font_space {
    if (!_slider_font_space) {
        _slider_font_space = [[EZCustomSlider alloc] initWithTitle:@"字体行间距" minimumValue:1 maximumValue:2 currentValue:self.waterMarkConfig.fontSpace];
        _slider_font_space.delegate = self;
    }
    return _slider_font_space;
}

- (EZCustomSlider *)slider_rotate_angle {
    if (!_slider_rotate_angle) {
        _slider_rotate_angle = [[EZCustomSlider alloc] initWithTitle:@"字体倾斜角度" minimumValue:0 maximumValue:360 currentValue:self.waterMarkConfig.fontRotateAngle];
        _slider_rotate_angle.delegate = self;
    }
    return _slider_rotate_angle;
}

- (UILabel *)lab_font_alignment {
    if (!_lab_font_alignment) {
        _lab_font_alignment = [[UILabel alloc] init];
        _lab_font_alignment.font = [UIFont systemFontOfSize:14.f];
        _lab_font_alignment.textColor = [UIColor grayColor];
        _lab_font_alignment.textAlignment = NSTextAlignmentRight;
        _lab_font_alignment.text = @"字体对齐方式：";
    }
    return _lab_font_alignment;
}

- (StepSlider *)slider_font_alignment {
    if (!_slider_font_alignment) {
        _slider_font_alignment = [[StepSlider alloc] init];
        _slider_font_alignment.labels = @[@"居中对齐", @"左对齐", @"右对齐"];
        _slider_font_alignment.adjustLabel = YES;
        _slider_font_alignment.labelFont = [UIFont systemFontOfSize:14.f];
        _slider_font_alignment.labelColor = [UIColor lightGrayColor];
        _slider_font_alignment.tintColor = HEXColor(0x3fb895);
        _slider_font_alignment.trackColor = HEXColor(0xe4e4e5);
        _slider_font_alignment.sliderCircleColor = HEXColor(0x3fb895);
        _slider_font_alignment.sliderCircleRadius = 8.f;
        _slider_font_alignment.labelOffset = 0.f;
        [_slider_font_alignment addTarget:self action:@selector(stepSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
        _slider_font_alignment.index = self.waterMarkConfig.fontAlignment;
    }
    return _slider_font_alignment;
}

- (EZCustomSlider *)slider_font_position_x {
    if (!_slider_font_position_x) {
        _slider_font_position_x = [[EZCustomSlider alloc] initWithTitle:@"x轴比例位置" minimumValue:0 maximumValue:1 currentValue:self.waterMarkConfig.startPosX];
        _slider_font_position_x.delegate = self;
        if (self.waterMarkConfig.windowAdaptMode == EZWaterMarkWindowAdaptModeFontRowColumn) {
            _slider_font_position_x.slider.enabled = NO;
            _slider_font_position_y.slider.enabled = NO;
        }
    }
    return _slider_font_position_x;
}

- (EZCustomSlider *)slider_font_position_y {
    if (!_slider_font_position_y) {
        _slider_font_position_y = [[EZCustomSlider alloc] initWithTitle:@"y轴比例位置" minimumValue:0 maximumValue:1 currentValue:self.waterMarkConfig.startPosY];
        _slider_font_position_y.delegate = self;
    }
    return _slider_font_position_y;
}

- (EZCustomSlider *)slider_font_color_red {
    if (!_slider_font_color_red) {
        _slider_font_color_red = [[EZCustomSlider alloc] initWithTitle:@"红" minimumValue:0 maximumValue:255 currentValue:self.waterMarkConfig.red];
        _slider_font_color_red.delegate = self;
        if (self.waterMarkConfig.fontColorAdapt) {
            _slider_font_color_red.slider.enabled = NO;
        }
    }
    return _slider_font_color_red;
}

- (EZCustomSlider *)slider_font_color_green {
    if (!_slider_font_color_green) {
        _slider_font_color_green = [[EZCustomSlider alloc] initWithTitle:@"绿" minimumValue:0 maximumValue:255 currentValue:self.waterMarkConfig.green];
        _slider_font_color_green.delegate = self;
        if (self.waterMarkConfig.fontColorAdapt) {
            _slider_font_color_green.slider.enabled = NO;
        }
    }
    return _slider_font_color_green;
}

- (EZCustomSlider *)slider_font_color_blue {
    if (!_slider_font_color_blue) {
        _slider_font_color_blue = [[EZCustomSlider alloc] initWithTitle:@"蓝" minimumValue:0 maximumValue:255 currentValue:self.waterMarkConfig.blue];
        _slider_font_color_blue.delegate = self;
        if (self.waterMarkConfig.fontColorAdapt) {
            _slider_font_color_blue.slider.enabled = NO;
        }
    }
    return _slider_font_color_blue;
}

- (EZCustomSlider *)slider_font_alpha {
    if (!_slider_font_alpha) {
        _slider_font_alpha = [[EZCustomSlider alloc] initWithTitle:@"透明度" minimumValue:0 maximumValue:100 currentValue:self.waterMarkConfig.alpha];
        _slider_font_alpha.delegate = self;
    }
    return _slider_font_alpha;
}

- (EZCustomSlider *)slider_font_row_number {
    if (!_slider_font_row_number) {
        _slider_font_row_number = [[EZCustomSlider alloc] initWithTitle:@"行数" minimumValue:1 maximumValue:9 currentValue:self.waterMarkConfig.rowNumber];
        _slider_font_row_number.delegate = self;
        _slider_font_row_number.slider.enabled = self.waterMarkConfig.fillFullScreen;
    }
    return _slider_font_row_number;
}

- (EZCustomSlider *)slider_font_column_number {
    if (!_slider_font_column_number) {
        _slider_font_column_number = [[EZCustomSlider alloc] initWithTitle:@"列数" minimumValue:1 maximumValue:9 currentValue:self.waterMarkConfig.columnNumber];
        _slider_font_column_number.delegate = self;
        _slider_font_column_number.slider.enabled = self.waterMarkConfig.fillFullScreen;
    }
    return _slider_font_column_number;
}

- (UILabel *)lab_window_adapt {
    if (!_lab_window_adapt) {
        _lab_window_adapt = [[UILabel alloc] init];
        _lab_window_adapt.font = [UIFont systemFontOfSize:14.f];
        _lab_window_adapt.textColor = [UIColor grayColor];
        _lab_window_adapt.textAlignment = NSTextAlignmentRight;
        _lab_window_adapt.text = @"窗口自适应：";
    }
    return _lab_window_adapt;
}

- (StepSlider *)slider_window_adapt {
    if (!_slider_window_adapt) {
        _slider_window_adapt = [[StepSlider alloc] init];
        _slider_window_adapt.labels = @[@"关闭", @"行列数自适应", @"大小自适应"];
        _slider_window_adapt.adjustLabel = YES;
        _slider_window_adapt.labelFont = [UIFont systemFontOfSize:14.f];
        _slider_window_adapt.labelColor = [UIColor lightGrayColor];
        _slider_window_adapt.tintColor = HEXColor(0x3fb895);
        _slider_window_adapt.trackColor = HEXColor(0xe4e4e5);
        _slider_window_adapt.sliderCircleColor = HEXColor(0x3fb895);
        _slider_window_adapt.sliderCircleRadius = 8.f;
        _slider_window_adapt.labelOffset = 0.f;
        [_slider_window_adapt addTarget:self action:@selector(stepSliderValueChanged:) forControlEvents:UIControlEventValueChanged];
        _slider_window_adapt.index = self.waterMarkConfig.windowAdaptMode;
    }
    return _slider_window_adapt;
}

- (EZCustomSlider *)slider_window_adapt_row_space {
    if (!_slider_window_adapt_row_space) {
        _slider_window_adapt_row_space = [[EZCustomSlider alloc] initWithTitle:@"自适应行列数行间距" minimumValue:1 maximumValue:300 currentValue:self.waterMarkConfig.windowAdaptRowSpace];
        _slider_window_adapt_row_space.delegate = self;
    }
    return _slider_window_adapt_row_space;
}

- (EZCustomSlider *)slider_window_adapt_column_space {
    if (!_slider_window_adapt_column_space) {
        _slider_window_adapt_column_space = [[EZCustomSlider alloc] initWithTitle:@"自适应行列数列间距" minimumValue:1 maximumValue:300 currentValue:self.waterMarkConfig.windowAdaptColumnSpace];
        _slider_window_adapt_column_space.delegate = self;
    }
    return _slider_window_adapt_column_space;
}

#pragma mark - 设置约束

- (void)setLayout {
    [self.lab_switch_title mas_makeConstraints:^(MASConstraintMaker *make) {
        make.left.top.equalTo(self).offset(15);
    }];
    [self.switch_waterMark mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lab_switch_title);
        make.left.equalTo(self.lab_switch_title.mas_right).offset(10);
    }];
    [self.btn_close mas_makeConstraints:^(MASConstraintMaker *make) {
        make.width.height.mas_equalTo(50);
        make.top.equalTo(self);
        make.right.equalTo(self);
    }];
    [self.sv_waterMark mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.switch_waterMark.mas_bottom).offset(20);
        make.left.equalTo(self).offset(10);
        make.right.equalTo(self).offset(-10);
        make.bottom.equalTo(self);
    }];
    [self.slider_font_size mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.sv_waterMark);
        make.left.equalTo(self).offset(10);
        make.right.equalTo(self).offset(-10);
        make.height.mas_equalTo(38);
    }];
    [self.slider_font_space mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_size.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_rotate_angle mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_space.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_alignment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_rotate_angle.mas_bottom);
        make.left.equalTo(self.lab_font_alignment.mas_right);
        make.right.equalTo(self.slider_font_size).offset(-7);
    }];
    [self.lab_font_alignment mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_alignment).offset(3);
        make.right.equalTo(self.slider_font_size.lab_title);
    }];
    [self.slider_font_position_x mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_alignment.mas_bottom).offset(5);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_position_y mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_position_x.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_color_red mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_position_y.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_color_green mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_color_red.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_color_blue mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_color_green.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_alpha mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_color_blue.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.lab_switch_font_color_adapt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_alpha.mas_bottom).offset(10);
        make.left.equalTo(self.slider_font_size).offset(5);
    }];
    [self.switch_font_color_adapt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lab_switch_font_color_adapt);
        make.left.equalTo(self.lab_switch_font_color_adapt.mas_right);
    }];
    [self.lab_switch_fill_full_screen mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lab_switch_font_color_adapt);
        make.left.equalTo(self.switch_font_color_adapt.mas_right).offset(20);
    }];
    [self.switch_fill_full_screen mas_makeConstraints:^(MASConstraintMaker *make) {
        make.centerY.equalTo(self.lab_switch_font_color_adapt);
        make.left.equalTo(self.lab_switch_fill_full_screen.mas_right);
    }];
    [self.slider_font_row_number mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.lab_switch_font_color_adapt.mas_bottom).offset(15);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_font_column_number mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_row_number.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_window_adapt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_font_column_number.mas_bottom);
        make.left.equalTo(self.lab_window_adapt.mas_right);
        make.right.equalTo(self.slider_font_size).offset(-7);
    }];
    [self.lab_window_adapt mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_window_adapt).offset(3);
        make.right.equalTo(self.slider_font_size.lab_title);
    }];
    [self.slider_window_adapt_row_space mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_window_adapt.mas_bottom).offset(5);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_window_adapt_row_space setTitleWidth:150];
    [self.slider_window_adapt_column_space mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.equalTo(self.slider_window_adapt_row_space.mas_bottom);
        make.left.right.height.equalTo(self.slider_font_size);
    }];
    [self.slider_window_adapt_column_space setTitleWidth:150];
}

@end

NS_ASSUME_NONNULL_END
