//
//  FecViewLayoutHelper.h
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2023/9/2.
//  Copyright © 2023 hikvision. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "EZPlayer.h"

@class EZDeviceInfo;

NS_ASSUME_NONNULL_BEGIN

@interface FecViewLayoutHelper : NSObject

/// 对象初始化后设置以下属性
@property (nonatomic, strong) UIView *scrollView;
@property (nonatomic, strong) NSLayoutConstraint *playerViewAspectContraint;
@property (nonatomic, strong) UIView *playerView;///< 播放视图
@property (nonatomic, strong) EZPlayer *player;///< 预览播放器
/// 对象初始化后设置以上属性

@property (nonatomic, strong) UIView *ptz1PlayView;///<
@property (nonatomic, strong) UIView *ptz2PlayView;///<
@property (nonatomic, strong) UIView *ptz3PlayView;///<
@property (nonatomic, strong) UIView *ptz4PlayView;///<
@property (nonatomic, strong) UIView *ptz5PlayView;///<
@property (nonatomic, strong) UIView *ptz6PlayView;///<

/** 打开鱼眼矫正 */
- (void)openFecCorrect:(EZFecCorrectType)fecCorrectType fecPlaceType:(EZFecPlaceType)fecPlaceType;

/** 播放器宽高比例设置为1:1 */
- (void)setPlayViewAspectRadioWith1V1;
/** 播放器宽高比例设置为16:9 */
- (void)setPlayViewAspectRadioWith16V9;

/** 是否支持矫正模式 */
+ (BOOL)isFecDevice:(EZDeviceInfo *)deviceInfo;
/** 获取安装模式对应的能力集值 */
+ (int)getSupportInt:(EZFecPlaceType)fecPlaceType deviceInfo:(EZDeviceInfo *)deviceInfo;
/** 根据能力值设置各种矫正模式按钮的状态 */
+ (void)setFecCorrectButtonsState:(NSArray<UIButton *> *)buttons supportValue:(int)supportValue;

@end

NS_ASSUME_NONNULL_END
