//
//  EZEditViewController.m
//  EZOpenSDKDemo
//
//  Created by DeJohn Dong on 15/12/16.
//  Copyright © 2015年 Ezviz. All rights reserved.
//

#import "EZEditViewController.h"

#import "EZDeviceTableViewController.h"
#import "EZSettingViewController.h"

@interface EZEditViewController ()<UITextFieldDelegate>

@property (nonatomic, weak) IBOutlet UITextField *deviceNameTextField;

@end

@implementation EZEditViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.title = NSLocalizedString(@"device_modify_name_title", @"修改设备名称");
    
}

#pragma mark - UITextFieldDelegate Methods

- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string {
    if (self.deviceNameTextField == textField) {
        NSString *strTemp = [NSString stringWithFormat:@"%@%@", textField.text, string];
        if (strTemp.length > 50) {
            return NO;
        }
        return YES;
    }
    return YES;
}

#pragma mark - Action Methods

- (IBAction)saveName:(id)sender {
    [EZOPENSDK setDeviceName:self.deviceNameTextField.text
                deviceSerial:self.deviceInfo.deviceSerial
                  completion:^(NSError *error) {
                      NSLog(@"error = %@",error);
                      if (!error) {
                          
                          NSArray *viewControllers = self.navigationController.viewControllers;
                          for (UIViewController *vc in viewControllers) {
                              if ([vc isKindOfClass:[EZDeviceTableViewController class]]) {// 刷新设备列表
                                  ((EZDeviceTableViewController *)vc).needRefresh = YES;
                              } else if ([vc isKindOfClass:[EZSettingViewController class]]) {// 刷新设置页面设备名
                                  ((EZSettingViewController *)vc).deviceInfo.deviceName = self.deviceNameTextField.text;
                              }
                          }
                          [self.navigationController popViewControllerAnimated:YES];
                      }
                  }];
}

@end
