//
//  EZJoinMeetingViewController.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/4/16.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import "EZJoinMeetingViewController.h"
#import "EZBusinessTool.h"
#import "ErtcHelper.h"

#import "EZCameraInfo.h"

#import "ErtcRoomViewController.h"

@interface EZJoinMeetingViewController ()

@property (weak, nonatomic) IBOutlet UITextField *appIdTextField;
@property (weak, nonatomic) IBOutlet UITextField *ertcTokenTextField;
@property (weak, nonatomic) IBOutlet UITextField *ertcHttpTokenTextField;
@property (weak, nonatomic) IBOutlet UITextField *roomIdTextField;
@property (weak, nonatomic) IBOutlet UITextField *userIdTextField;

@end

@implementation EZJoinMeetingViewController

- (instancetype)init {
    if (self = [super init]) {
        self = [EZStoryBoardTool getViewController:@"VideoTalk" andIdentifier:@"EZJoinMeetingViewController"];
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];

#ifdef JCTest
#endif
}

#pragma mark - Action Methods 点击事件

- (IBAction)videoTalkAction:(id)sender {
    if (![self checkVideoTalkParams]) {
        return;
    }
    [self checkPermissions:^(BOOL enable) {
        if (enable) {
            [self initErtcEngine:YES];
        }
    }];
}

/**
 * 设备端端发起视频通话后，客户端接听
 */
- (IBAction)answerDeviceCallAction:(id)sender {
    if (![self checkVideoTalkParams]) {
        return;
    }
    [self checkPermissions:^(BOOL enable) {
        if (enable) {
            [self initErtcEngine:NO];
        }
    }];
}

/**
 * 设备端端发起视频通话后，客户端拒接
 */
- (IBAction)rejectDeviceCallAction:(id)sender {
    if (![self checkVideoTalkParams]) {
        return;
    }
    [EZOpenSDK rejectVideoCallReqFromDevice:self.appIdTextField.text ertcToken:self.ertcTokenTextField.text roomId:self.roomIdTextField.text deviceSerial:self.cameraInfo.deviceSerial cameraNo:self.cameraInfo.cameraNo account:self.userIdTextField.text completion:^(NSError * _Nonnull error) {
        NSLog(@"rejectVideoCallReqFromDevice error:%@", error);
        if (!error) {
            [EZToast show:@"拒接成功"];
        }
    }];
}

#pragma mark - ERTC初始化

/**
 * ERTC初始化
 * @param isClientCallDevice 是否是客户端呼叫设备端
 */
- (void)initErtcEngine:(BOOL)isClientCallDevice {
    NSString *appId = [self.appIdTextField.text trim];
    NSString *ertcToken = [self.ertcTokenTextField.text trim];
    NSString *ertcHttpToken = [self.ertcHttpTokenTextField.text trim];
    NSString *roomId = [self.roomIdTextField.text trim];
    NSString *userId = [self.userIdTextField.text trim];
    
    [ErtcHelper initERTCEngine:appId initBlock:^(ERTCEngine * _Nullable instance, NSError * _Nullable error) {
        if (!error) {
            NSLog(@"ERTCEngine init OK");
            [ErtcHelper sharedInstance].ertcEngine = instance;
            
            ERTCParam *ertcParam = [[ERTCParam alloc] init];
            ertcParam.roomId = roomId;
            ertcParam.userId = userId;
            ertcParam.token = ertcToken;
            ertcParam.appID = appId;
            ertcParam.apiUrl = [kUserDefaults objectForKey:UserApiUrl];
            ErtcRoomViewController *ertcRoomVC = [[ErtcRoomViewController alloc] init];
            ertcRoomVC.ertcParam = ertcParam;
            ertcRoomVC.ertcHttpToken = ertcHttpToken;
            ertcRoomVC.cameraInfo = self.cameraInfo;
            ertcRoomVC.isClientCallDevice = isClientCallDevice;
            [self.navigationController pushViewController:ertcRoomVC animated:YES];
        } else {
            NSLog(@"ERTCEngine init failed--->%@", error);
        }
    }];
}

#pragma mark - 其他方法

/** 请求权限 */
- (void)checkPermissions:(void(^)(BOOL enable))block {
    [EZBusinessTool checkCameraPermissionResult:^(BOOL enable) {
        dispatch_async(dispatch_get_main_queue(), ^{
            if (enable) {
                [EZBusinessTool checkMicPermissionResult:^(BOOL enable) {
                    if (enable) {
                        dispatch_async(dispatch_get_main_queue(), ^{
                            block(YES);
                        });
                    } else {
                        [EZToast show:NSLocalizedString(@"no_mic_permission", @"未开启麦克风权限")];
                        block(NO);
                    }
                }];
            } else {
                [EZToast show:NSLocalizedString(@"no_camera_permission", @"未开启相机权限")];
                block(NO);
            }
        });
        
    }];
}

/** 检查入参 */
- (BOOL)checkVideoTalkParams {
    NSString *appId = [self.appIdTextField.text trim];
    NSString *ertcToken = [self.ertcTokenTextField.text trim];
    NSString *ertcHttpToken = [self.ertcHttpTokenTextField.text trim];
    NSString *roomId = [self.roomIdTextField.text trim];
    NSString *userId = [self.userIdTextField.text trim];
    if (kStringIsEmpty(appId) || kStringIsEmpty(ertcToken) || kStringIsEmpty(ertcHttpToken) || kStringIsEmpty(roomId) || kStringIsEmpty(userId)) {
        [EZToast show:@"信息不能为空"];
        return NO;
    }
    return YES;
}


@end
